// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: Granule-main.h,v 1.29 2008/01/06 16:51:10 vlg Exp $
//------------------------------------------------------------------------------
//                            Granule-main.h
//------------------------------------------------------------------------------
//  Copyright (c) 2004 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed Dec 31 23:18:34 2003
//
//------------------------------------------------------------------------------

#ifndef MAIN_H
#define MAIN_H

#include <assa/Assure.h>

using ASSA::APP;
using ASSA::TRACE;
using ASSA::ALL;

enum { GRAPP     = ASSA::APP,	// 0x00000002
	   GUITRACE  = ASSA::USR1,	// 0x00000004
	   DECK      = ASSA::USR2,	// 0x00000008
	   GEOM      = ASSA::USR3,	// 0x00000010
       KEYIN     = ASSA::RES5,  // 0x02000000
       CSVPARSER = ASSA::RES6   // 0x04000000
};

typedef enum {
    Start = 0,
    Dirty,						/// Lesson deck has been modified
    Clean,						/// No modifications has been done
    Finish						
} WMState;

typedef enum { 
	FRONT, 
	BACK,
	EXAMPLE,
	ASF,
	ASB
} SideSelection;

typedef enum {
	QFONT, 			// Question font
	AFONT, 			// Answer font
	EFONT, 			// Example font
	IFONT, 			// Input font:
	PFONT,			// Application font
	FONT_ENTRY_SZ
} TextFontType;

typedef enum {
	TXTFGCLR,					// Text foreground color
	TXTBGCLR,					// Text background color
	SEPCLR,						// Separator color
	FRMCLR,						// Frame color
	COLOR_ENTRY_SZ
} TextColorType;

typedef enum { 
	LOAD_OK, 
	LOAD_FAILED 
} DeckLoadStatus;

typedef enum {
	INSTALL_DECK,				// Load a deck from a file
	ADD_TO_DECK					// Add cards to a deck from another deck file
} DeckAction;

typedef enum {
	NEW_DECK,					// Brand new deck (different from MODIFIED)
	INVALID_DECK,				// Tried and failed to load the deck
	MODIFIED_DECK,				// Deck has been modified with edit/add/delete
	CLEAN_DECK					// Deck doesn't need to be saved
} DeckEditStatus;

enum {
	CARDBOXES_MIN = 5,
	CARDBOXES_MAX = 30,
	MAX_CARDS     = 100000,		// Maximum cards in Deck/CardFile
	CARD_STATS_SZ = 6,
};

typedef enum {
	ANSWER_BAD_BLACKOUT, // 0:Incorrect answer; complete blackout
	ANSWER_BAD_PARTIAL,	 // 1:Incorrect answer; the correct one remembered
	ANSWER_BAD_RECALL,	 // 2:Incorrect answer; correct one easealy recalled

	ANSWER_OK_DIFFICULT, // 3:Correct answer; recalled with serious difficulty
	ANSWER_OK_HESITANT,  // 4:Correct answer; after some hesitation
	ANSWER_OK			 // 5:Correct answer; perfect response
} AnswerQuality;

typedef enum {
	SPACE_SEP,
	TAB_SEP,
	COLON_SEP,
	SEMICOLON_SEP,
	COMMA_SEP,
} CSVSeparator;

/** Indexes into text alignment combo control widgets.
 *  These differ from both Gtk::AlignmentEnum and Gtk::Justification.
 */
enum {
	TA_X_ALIGN_CENTER,
	TA_X_ALIGN_LEFT,
	TA_X_ALIGN_RIGHT
};

enum {
	TA_Y_ALIGN_CENTER,
	TA_Y_ALIGN_TOP,
	TA_Y_ALIGN_BOTTOM
};

enum {
	TA_JUSTIFY_CENTER,
	TA_JUSTIFY_LEFT,
	TA_JUSTIFY_RIGHT,
	TA_JUSTIFY_FILL
};

typedef enum {
	PATH_RELATIVE,
	PATH_ABSOLUTE
} PathMode;

/*------------------------------------------------------------------------------
 * Some useful defines and define macros
 *------------------------------------------------------------------------------
 */
#define CARD_FILE_EXT  ".cdf"
#define DECK_FILE_EXT  ".dkf"
#define UNKNOWN_FNAME  "Unknown"       /* Name of 'New' CardFile */


#endif /* MAIN_H */

