// -*- c++ -*-
//------------------------------------------------------------------------------
// $Id: MyInputDialog.h,v 1.1 2006/12/26 04:53:55 vlg Exp $
//------------------------------------------------------------------------------
//                            MyInputDialog.h
//------------------------------------------------------------------------------
//  Copyright (c) 2006 by Vladislav Grinchenko 
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Mon Dec 25 15:53:51 EST 2006
//
//------------------------------------------------------------------------------
#ifndef MY_INPUT_DIALOG_H
#define MY_INPUT_DIALOG_H

#include <gtkmm/messagedialog.h>
#include <gtkmm/entry.h>


/* @class MyInputDialog

   A standard question dialog and two buttons, 'OK' and 'Cancel',
   with additional input entry field positioned below the the message.

   The run() method returns Gtk::RESPONSE_OK if 'OK' button is pressed
   and Gtk::RESPONSE_CANCEL if 'Cancel' button is pressed.

   @param message_ - Message to display
   @param value_   - Initial value of the entry widget.
*/
class MyInputDialog : public Gtk::MessageDialog
{
public:
	MyInputDialog (const Glib::ustring& message_, const Glib::ustring& value_);

	Glib::ustring get_entry_value () const;

private:
	Gtk::Entry* m_local_entry;
};

inline
Glib::ustring 
MyInputDialog::
get_entry_value () const 
{ 
	if (m_local_entry != NULL) {
		return (m_local_entry->get_text ());
	}
}

#endif /* MY_INPUT_DIALOG */
