#ifndef _VIEWER_H
#define _VIEWER_H
#include <qtabwidget.h>
#include "osl/state/simpleState.h"
#include "osl/stl/vector.h"
#include <utility>
namespace gpsshogi
{
  namespace gui
  {
    class Board;
  }
}

class MoveList;
class AnalysisViewer;
class CheckmateViewer;
class NtesukiViewer;
class KifuViewer;
class QuiescenceViewer;
class NetworkViewer;
#if QT_VERSION < 0x040000
class BoardEditor;
#endif
class BoardEditor2;
class QPixmap;

namespace viewer
{  
struct EvalInfo
{
  int total;
  int opening, mid, ending;
  EvalInfo() : total(0), opening(0), mid(0), ending(0)
  {
  }
};
}


class Viewer : public QTabWidget
{
Q_OBJECT
public:
  QString dirPath;
  Viewer(QWidget *parent = 0, const char *name = 0);
  const viewer::EvalInfo evalState();
  void progressOfState(osl::stl::vector<int>&);
  std::pair<double,double> checkmateProbability();
  int moveCount() const;
  osl::Player turn() const;
  const osl::state::SimpleState& getState();
  void open(const std::string& fileName); // csa
  void openUsi(const std::string& fileName);
  void openKakinoki(const std::string& fileName); // kakinoki
  void openKi2(const std::string& fileName); // ki2
  void open(const std::string& fileName, int index); // kisen
  void moveTo(int index); // only works on kifuView for now
  bool isSenteView() const;
  QString getFilename();
signals:
  void statusChanged();
  void orientationChanged(bool sente);
  void effectChanged(bool on);
  void analyzeOnlineDisabled();
public slots:
  void open();
  void nextFile();
  void prevFile();
  void watchFile(bool enable);
  void openUrl();
  void reloadUrl();
  void hirate();
  void network();
  void view();
  void viewInNewTab();
  void forward();
  void backward();
  void toInitialState();
  void toLastState();
  void analyze();
  void analyzeInNewTab();
  void checkmateSearch();
  void altCheckmateSearch();
  void checkmateSimulation();
  void ntesukiSearch();
  void quiescenceSearch();
  void quiescenceSearchHalf();
  void piecePairDialog();
  void moveGenerateDialog();
  void toggleOrientation();
  void saveMovesToCurrent();
  void exportCurrent();
  void copy();
  void copyBoardAndMoves();
  void copyUsi();
  void copyBoardAndMovesUsi();
  void setOrientation(bool gote);
  void enableEffect(bool on);
  void highlightLastMove(bool on);
  void setAnalyzeOnline(bool enable);
  void kifuAnalyze();
  void openEvalGraph();
  void editState();
  void evalDebug();
  void testEvalDebug();
private slots:
  void closeTab();
  void notifyOrientation(QWidget *widget);
  void notifyEffect(QWidget *widget);
  void chatReceived();
  void chatDisplayed();
private:
  void openUrl(bool reload);
  void resetIcon();
  void setChatIcon();
  void analyze(bool newTab);
  QString getFilenameToSave();

  AnalysisViewer *analysisViewer;
  CheckmateViewer *checkmateViewer;
  NtesukiViewer *ntesukiViewer;
  QuiescenceViewer *quiescenceViewer;
  KifuViewer *kifuViewer;
  NetworkViewer *networkViewer;
#if QT_VERSION < 0x040000
  BoardEditor *boardEditor;
#endif
  BoardEditor2 *editor;

  bool chatIcon;
};
#endif // _VIEWER_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
