#include "networkBoard.h"
#include <qstringlist.h>
#include <qregexp.h>

/* The format we will be expected:
 *
 * BEGIN Game_Summary
 * Protocol_Version:1.0
 * Protocol_Mode:Server
 * Format:Shogi 1.0
 * Game_ID:wdoor+bg_71-0-30+gps2p+gps4p_bg+20051103211852
 * Name+:gps2p
 * Name-:gps4p_bg
 * Rematch_On_Draw:NO
 * To_Move:+
 * BEGIN Time
 * Time_Unit:1sec
 * Total_Time:0
 * Byoyomi:30
 * Least_Time_Per_Move:1
 * Remaining_Time+:0
 * Remaining_Time-:0
 * Last_Move:-0068KA,T24
 * Current_Turn:158
 * END Time
 * BEGIN Square
 * Jishogi_Declaration:1.1
 * P1-KY-HI *  *  *  *  *  * -RY
 * P2 *  *  *  *  *  *  *  *  * 
 * P3 * -OU *  * +GI+TO+TO *  * 
 * P4-FU-FU * +KI-FU *  * +KI+FU
 * P5 *  * -FU *  * -FU *  *  * 
 * P6+FU+FU * -FU+FU *  *  *  * 
 * P7+OU+GI *  * -NY+FU *  * -UM
 * P8+KY+GI * -KA *  *  *  *  * 
 * P9 * +KE * -GI+KY *  * -TO * 
 * P-00FU00FU00FU00FU00KE00KE00KE00KI00KI
 * +
 * END Square
 * END Game_Summary
 */
NetworkBoard::
NetworkBoard(const QString& str)
{
  QStringList lines = QStringList::split("\n", str);
  QRegExp line_re("(.+)\\:(.*)");

  QStringList::iterator line_it = lines.begin();

  //read headers
  for (;line_it != lines.end(); line_it++)
  {
    const QString& line = *line_it;
    if (line_re.search(line) == -1)
    {
      if (line.find("BEGIN Square") != -1) break;
    }
    values[line_re.cap(1)] = line_re.cap(2);
    header.append(line);
  }

  line_it++; //BEGIN Square
  // line_it++; //Jishogi delcaration

  //read board
  for (;line_it != lines.end(); line_it++)
  {
    const QString& line = *line_it;
    if (line.find("END") != -1)
    {
      continue;
    }
    board.append(line);
    board.append("\n");
  }
}

QString
NetworkBoard::
getBoard() const
{
  return board;
}

QString
NetworkBoard::
getValue(const QString& str) const
{
  return values[str];
}

QString
NetworkBoard::
getCsa() const
{
  QString csa;
  
  //append some information from header
  csa.append("'ID ");
  csa.append(values["Game_ID"]);
  csa.append("\nN+");
  csa.append(values["Name+"]);
  csa.append("\nN-");
  csa.append(values["Name-"]);
  csa.append("\n");
  csa.append(board);

  //a bug in shogi server 2005/11/4
  if (values["Last_Move"].find("+") != -1)
  {
    csa.replace(csa.findRev('+'), 1, '-');
  }

  csa.append("'LAST ");
  csa.append(values["Last_Move"]);

  return csa;
}
