#include "boardAndListTabChild.h"
#include "moveTree.h"

#include "osl/stl/vector.h"

#include "gpsshogi/gui/board.h"
#include "moveGeneratorDialog.h"
#include <qinputdialog.h>

BoardAndListTabChild::BoardAndListTabChild(QWidget *parent, const char *name)
  : BoardTabChild(parent, name), numMoves(0)
{
}

void BoardAndListTabChild::init()
{
  board->setManualMovement(false);
  moveTree->setRootIsDecorated(true);
#if QT_VERSION >= 0x040000
  connect(moveTree, SIGNAL(clicked(Q3ListViewItem *, const QPoint&, int)),
	  this, SLOT(updateBoardSlot(Q3ListViewItem *)));
  connect(moveTree, SIGNAL(returnPressed(Q3ListViewItem *)),
	  this, SLOT(updateBoardSlot(Q3ListViewItem *)));
#else
  connect(moveTree, SIGNAL(clicked(QListViewItem *, const QPoint&, int)),
	  this, SLOT(updateBoardSlot(QListViewItem *)));
  connect(moveTree, SIGNAL(returnPressed(QListViewItem *)),
	  this, SLOT(updateBoardSlot(QListViewItem *)));
#endif
  connect(moveTree, SIGNAL(moveGenerate()),
	  this, SLOT(moveGenerateDialog()));
}

void BoardAndListTabChild::updateBoardSlot(Q3ListViewItem *item)
{
  if (item)
    updateBoard(item);
}

void BoardAndListTabChild::updateBoard(Q3ListViewItem *li)
{
  MoveTreeItem *item = (MoveTreeItem *)li;
  osl::stl::vector<osl::Move> moves;
  for (; item; item = (MoveTreeItem *)item->parent())
  {
    moves.push_back(item->getMove());
  }
  osl::NumEffectState newState(initialState);
  osl::Move last_moved;
  for (int i = moves.size() - 1; i >= 0; i--)
  {
    if (moves[i].isInvalid())
      continue;
    newState.makeMove(moves[i]);
    last_moved = moves[i];
  }
  numMoves = moves.size();
  board->setState(newState, last_moved); 
}

void BoardAndListTabChild::forward()
{
  tryForward();
  return;
}

bool BoardAndListTabChild::tryForward()
{
  MoveTreeItem *item = (MoveTreeItem *)moveTree->selectedItem();
  if (item)
  {
    item->setOpen(true);
  }
  for (MoveTreeItem *child =
	 (MoveTreeItem *)(item ? item->firstChild() : moveTree->firstChild());
       child;
       child = (MoveTreeItem *)child->nextSibling())
  {
    if (child->isBestMove())
    {
      updateBoard(child);
      moveTree->setSelected(child, true);
      moveTree->ensureItemVisible(child);
      return true;
    }
  }
  return false;
}

void BoardAndListTabChild::backward()
{
  MoveTreeItem *item = (MoveTreeItem *)moveTree->selectedItem();
  if (item && item->parent())
  {
    updateBoard((MoveTreeItem *)item->parent());
    moveTree->setSelected(item->parent(), true);
    moveTree->ensureItemVisible(item->parent());
  }
  else
  {
    updateBoard(0);
    if (item)
    {
      moveTree->setSelected(item, false);
      moveTree->ensureItemVisible(item);
    }
  }
}

osl::NumEffectState BoardAndListTabChild::getStateAndMovesToCurrent(osl::stl::vector<osl::Move> &moves)
{
  MoveTreeItem *item = (MoveTreeItem *)moveTree->selectedItem();
  if (item && item->getMove().isInvalid())
    return initialState;
  osl::stl::vector<osl::Move> movesOnTree;
  for (; item; item = (MoveTreeItem *)item->parent())
  {
    movesOnTree.push_back(item->getMove());
  }
  for (int i = movesOnTree.size() - 1; i >= 0; i--)
  {
    moves.push_back(movesOnTree[i]);
  }
  return initialState;
}

void BoardAndListTabChild::toLastState()
{
  while (tryForward())
    ;
}

