#ifndef _BOARD_EDITOR_H
#define _BOARD_EDITOR_H
#include "boardAndListTabChild.h"
#include "gpsshogi/gui/editboard.h"

class MoveList;
class QPushButton;

class BoardEditor : public BoardAndListTabChild
{
  Q_OBJECT
public:
  typedef osl::state::SimpleState state_t;
  BoardEditor(QWidget *parent = 0, const char *name = 0);

  void forward();
  void backward();
  void toLastState();
  int moveCount() const;
  state_t getStateAndMovesToCurrent(osl::stl::vector<osl::Move>&);

  MoveList *moveList;
  const state_t& getState() const;
  osl::Player turn() const;

protected:
  //virtual void paintEvent(QPaintEvent *event);

private:
  unsigned int index;
  state_t initialState;
  void updateState();
  state_t dummy_state;

private slots:
  void get_move(osl::Move);
};
#endif // _BOARD_EDITOR_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
