#include "boardEditor.h"
#include "moveList.h"

#include "gpsshogi/gui/util.h"

#include "osl/apply_move/applyMove.h"
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

using gpsshogi::gui::Util;

/* ======================================================================
 * BoardEditor
 */
BoardEditor::
BoardEditor(QWidget *parent, const char *name)
  : BoardAndListTabChild(parent, name), index(0),
    dummy_state(osl::HIRATE)
{
  initialState.setPiece(osl::BLACK, osl::Position(), osl::KING);
  initialState.setPieceAll(osl::WHITE);
  board = new gpsshogi::gui::EditBoard(initialState, this);
  moveList = new MoveList(this);

  QHBoxLayout *main_layout = new QHBoxLayout(this);
  main_layout->addWidget(moveList);
  main_layout->addWidget(board);
  QVBoxLayout *buttons_layout = new QVBoxLayout(this);
  QPushButton *image = new QPushButton( "Image", this);
  QPushButton *toggle = new QPushButton( "Toggle", this);
  QPushButton *reset = new QPushButton( "Reset", this);
  QPushButton *set_initial = new QPushButton( "Set Initial", this);

  buttons_layout->addStretch(1);
  buttons_layout->addWidget(image);
  buttons_layout->addWidget(toggle);
  buttons_layout->addStretch(10);
  buttons_layout->addWidget(reset);
  buttons_layout->addStretch(1);
  buttons_layout->addWidget(set_initial);
  buttons_layout->addStretch(1);

  main_layout->addLayout(buttons_layout);

  QObject::connect(board, SIGNAL(moved(osl::Move)),
		   SLOT(get_move(osl::Move)));
  QObject::connect(image, SIGNAL(clicked()),
		   board, SLOT(readPict()));
  QObject::connect(toggle, SIGNAL(clicked()),
		   board, SLOT(togglePlayer()));
  QObject::connect(reset, SIGNAL(clicked()),
		   board, SLOT(reset()));
  QObject::connect(set_initial, SIGNAL(clicked()),
		   board, SLOT(setInitialPieces()));
  QObject::connect(board, SIGNAL(statusChanged()),
		   SIGNAL(statusChanged()));
}

void BoardEditor::forward()
{
  if (index < moveList->numMoves())
  {
    index++;
  }

  updateState();
}

void BoardEditor::backward()
{
  if (index > 0)
  {
    index--;
  }

  updateState();
}

void BoardEditor::updateState()
{
  osl::state::SimpleState state(initialState);
  return;
#if 0
  for (unsigned int i = 0; i < index; i++)
  {
    osl::ApplyMoveOfTurn::doMove(state, moveList->getMove(i));
  }
  board->setState(state);
#endif
}

void BoardEditor::toLastState()
{
  index = moveList->numMoves();
  updateState();
}

int BoardEditor::moveCount() const
{
  return index;
}

const osl::state::SimpleState& BoardEditor::
getState() const
{
  return dummy_state;
}

osl::Player BoardEditor::
turn() const
{
  return board->getState().getTurn();
}

osl::state::SimpleState BoardEditor::
getStateAndMovesToCurrent(osl::stl::vector<osl::Move> &moves)
{
#if 0
  moves.reserve(index);
  for (unsigned int i = 0; i < index; i++)
  {
    moves.push_back(moveList->getMove(i));
  }
  return initialState;
#else
  return board->getState();
#endif
}

void BoardEditor::get_move(osl::Move move)
{
  moveList->pushMove(move);
  index++;
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
