/*

    Data automatically generated from recode output:

        'recode -lf "CP1253" 2>/dev/null'


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

*/

#ifndef cp1253_h
#define cp1253_h

#define cet_cs_name_cp1253 "CP1253"

const char *cet_cs_alias_cp1253[] = 
{
	"CP1253", "1253", "ms-greek", "windows-1253", "WIN-CP1253",
	NULL
};

#define cet_ucs4_ofs_cp1253 128
#define cet_ucs4_cnt_cp1253 127

const int cet_ucs4_map_cp1253[cet_ucs4_cnt_cp1253] =
{
	0x20ac,     -1, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021, 
	    -1, 0x2030,     -1, 0x2039,     -1,     -1,     -1,     -1, 
	    -1, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, 
	    -1, 0x2122,     -1, 0x203a,     -1,     -1,     -1,     -1, 
	0x00a0, 0x0385, 0x0386, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 
	0x00a8, 0x00a9,     -1, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x2015, 
	0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x0384, 0x00b5, 0x00b6, 0x00b7, 
	0x0388, 0x0389, 0x038a, 0x00bb, 0x038c, 0x00bd, 0x038e, 0x038f, 
	0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 
	0x0398, 0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 
	0x03a0, 0x03a1,     -1, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 
	0x03a8, 0x03a9, 0x03aa, 0x03ab, 0x03ac, 0x03ad, 0x03ae, 0x03af, 
	0x03b0, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 
	0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 
	0x03c0, 0x03c1, 0x03c2, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 
	0x03c8, 0x03c9, 0x03ca, 0x03cb, 0x03cc, 0x03cd, 0x03ce
};

#define cet_ucs4_to_cp1253_ct 90

const cet_ucs4_link_t cet_ucs4_to_cp1253_links[cet_ucs4_to_cp1253_ct] =
{
	 {0x0192, 0x83} /* minuscule latine f hameon */,
	 {0x0384, 0xb4} /* grec tonos */,
	 {0x0385, 0xa1} /* accent and diaeresis (tonos and dialytika) */,
	 {0x0386, 0xa2} /* capital letter alpha with acute */,
	 {0x0388, 0xb8} /* capital letter epsilon with acute */,
	 {0x0389, 0xb9} /* capital letter eta with acute */,
	 {0x038a, 0xba} /* capital letter iota with acute */,
	 {0x038c, 0xbc} /* capital letter omicron with acute */,
	 {0x038e, 0xbe} /* capital letter upsilon with acute */,
	 {0x038f, 0xbf} /* capital letter omega with acute */,
	 {0x0390, 0xc0} /* small letter iota with acute and diaeresis */,
	 {0x0391, 0xc1} /* capital letter alpha */,
	 {0x0392, 0xc2} /* capital letter beta */,
	 {0x0393, 0xc3} /* capital letter gamma */,
	 {0x0394, 0xc4} /* capital letter delta */,
	 {0x0395, 0xc5} /* capital letter epsilon */,
	 {0x0396, 0xc6} /* capital letter zeta */,
	 {0x0397, 0xc7} /* capital letter eta */,
	 {0x0398, 0xc8} /* capital letter theta */,
	 {0x0399, 0xc9} /* capital letter iota */,
	 {0x039a, 0xca} /* capital letter kappa */,
	 {0x039b, 0xcb} /* capital letter lamda */,
	 {0x039c, 0xcc} /* capital letter mu */,
	 {0x039d, 0xcd} /* capital letter nu */,
	 {0x039e, 0xce} /* capital letter xi */,
	 {0x039f, 0xcf} /* capital letter omicron */,
	 {0x03a0, 0xd0} /* capital letter pi */,
	 {0x03a1, 0xd1} /* capital letter rho */,
	 {0x03a3, 0xd3} /* capital letter sigma */,
	 {0x03a4, 0xd4} /* capital letter tau */,
	 {0x03a5, 0xd5} /* capital letter upsilon */,
	 {0x03a6, 0xd6} /* capital letter phi */,
	 {0x03a7, 0xd7} /* capital letter chi */,
	 {0x03a8, 0xd8} /* capital letter psi */,
	 {0x03a9, 0xd9} /* capital letter omega */,
	 {0x03aa, 0xda} /* capital letter iota with diaeresis */,
	 {0x03ab, 0xdb} /* capital letter upsilon with diaeresis */,
	 {0x03ac, 0xdc} /* small letter alpha with acute */,
	 {0x03ad, 0xdd} /* small letter epsilon with acute */,
	 {0x03ae, 0xde} /* small letter eta with acute */,
	 {0x03af, 0xdf} /* small letter iota with acute */,
	 {0x03b0, 0xe0} /* small letter upsilon with acute and diaeresis */,
	 {0x03b1, 0xe1} /* small letter alpha */,
	 {0x03b2, 0xe2} /* small letter beta */,
	 {0x03b3, 0xe3} /* small letter gamma */,
	 {0x03b4, 0xe4} /* small letter delta */,
	 {0x03b5, 0xe5} /* small letter epsilon */,
	 {0x03b6, 0xe6} /* small letter zeta */,
	 {0x03b7, 0xe7} /* small letter eta */,
	 {0x03b8, 0xe8} /* small letter theta */,
	 {0x03b9, 0xe9} /* small letter iota */,
	 {0x03ba, 0xea} /* small letter kappa */,
	 {0x03bb, 0xeb} /* small letter lamda */,
	 {0x03bc, 0xec} /* small letter mu */,
	 {0x03bd, 0xed} /* small letter nu */,
	 {0x03be, 0xee} /* small letter xi */,
	 {0x03bf, 0xef} /* small letter omicron */,
	 {0x03c0, 0xf0} /* small letter pi */,
	 {0x03c1, 0xf1} /* small letter rho */,
	 {0x03c2, 0xf2} /* small letter final sigma */,
	 {0x03c3, 0xf3} /* small letter sigma */,
	 {0x03c4, 0xf4} /* small letter tau */,
	 {0x03c5, 0xf5} /* small letter upsilon */,
	 {0x03c6, 0xf6} /* small letter phi */,
	 {0x03c7, 0xf7} /* small letter chi */,
	 {0x03c8, 0xf8} /* small letter psi */,
	 {0x03c9, 0xf9} /* small letter omega */,
	 {0x03ca, 0xfa} /* small letter iota with diaeresis */,
	 {0x03cb, 0xfb} /* small letter upsilon with diaeresis */,
	 {0x03cc, 0xfc} /* small letter omicron with acute */,
	 {0x03cd, 0xfd} /* small letter upsilon with acute */,
	 {0x03ce, 0xfe} /* small letter omega with acute */,
	 {0x2013, 0x96} /* dash */,
	 {0x2014, 0x97} /* dash */,
	 {0x2015, 0xaf} /* bar */,
	 {0x2018, 0x91} /* single quotation mark */,
	 {0x2019, 0x92} /* single quotation mark */,
	 {0x201a, 0x82} /* low-9 quotation mark */,
	 {0x201c, 0x93} /* double quotation mark */,
	 {0x201d, 0x94} /* double quotation mark */,
	 {0x201e, 0x84} /* low-9 quotation mark */,
	 {0x2020, 0x86} /* dagger */,
	 {0x2021, 0x87} /* dagger */,
	 {0x2022, 0x95} /* puce */,
	 {0x2026, 0x85} /* horizontal ellipsis */,
	 {0x2030, 0x89} /* mille sign */,
	 {0x2039, 0x8b} /* left-pointing angle quotation mark */,
	 {0x203a, 0x9b} /* right-pointing angle quotation mark */,
	 {0x20ac, 0x80} /* euro */,
	 {0x2122, 0x99} /* mark sign */
};

/* Extra table was generated from bestfit1253.txt located at
   ftp.unicode.org:/Public/MAPPINGS/VENDORS/MICSFT/WindowsBestFit/ */
  
const cet_ucs4_link_t cet_ucs4_to_cp1253_extra[] = 
{
	{0x0191, 0x83} /* latin capital letter f with hook */,
	{0x030d, 0xb4} /* combining vertical line above */,
	{0x2195, 0xa6} /* up down arrow */,
	{0x21a8, 0xa6} /* up down arrow with base */,
	{0x2302, 0xa6} /* house */,
	{0x2502, 0xa6} /* box drawings light vertical */,
	{0x2510, 0xac} /* box drawings light down and left */,
	{0x2551, 0xa6} /* box drawings double vertical */,
	{0x2557, 0xac} /* box drawings double down and left */,
	{0x2560, 0xa6} /* box drawings double vertical and right */,
	{0x2563, 0xa6} /* box drawings double vertical and left */,
	{0x2569, 0xa6} /* box drawings double up and horizontal */,
	{0x25a0, 0xa6} /* black square */,
	{0x25bc, 0xa1} /* black down-pointing triangle */,
	{0x25d8, 0x95} /* inverse bullet */,
	{0x2660, 0xa6} /* black spade suit */,
	{0x2663, 0xa6} /* black club suit */,
	{0x2665, 0xa6} /* black heart suit */,
	{0x2666, 0xa6} /* black diamond suit */
};

#define cet_ucs4_to_cp1253_extra_ct sizeof(cet_ucs4_to_cp1253_extra) / sizeof(cet_ucs4_to_cp1253_extra[0])

cet_cs_vec_t cet_cs_vec_cp1253 =	/* defined in cet.h */
{	
	cet_cs_name_cp1253,		/* name of character set	*/
	cet_cs_alias_cp1253,		/* alias table			*/

	NULL,				/* ... to UCS-4 converter (multi-byte) */
	NULL,				/* UCS-4 to ... converter (multi-byte) */

	cet_ucs4_map_cp1253,		/* char to UCS-4 value table	*/
	cet_ucs4_ofs_cp1253,		/* first non standard character	*/
	cet_ucs4_cnt_cp1253,		/* number of values in table	*/

	cet_ucs4_to_cp1253_links,	/* UCS-4 to char links		*/
	cet_ucs4_to_cp1253_ct,		/* number of links		*/

	cet_ucs4_to_cp1253_extra,	/* hand made UCS-4 links	*/
	cet_ucs4_to_cp1253_extra_ct,	/* number of extra links	*/

	NULL	/* for internal use */
};


/*
const int cp1253_ucs4_full_map[] =
{
	0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 
	0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f, 
	0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 
	0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f, 
	0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
	0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
	0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
	0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
	0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
	0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
	0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
	0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
	0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f, 
	0x20ac,     -1, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021, 
	    -1, 0x2030,     -1, 0x2039,     -1,     -1,     -1,     -1, 
	    -1, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, 
	    -1, 0x2122,     -1, 0x203a,     -1,     -1,     -1,     -1, 
	0x00a0, 0x0385, 0x0386, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 
	0x00a8, 0x00a9,     -1, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x2015, 
	0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x0384, 0x00b5, 0x00b6, 0x00b7, 
	0x0388, 0x0389, 0x038a, 0x00bb, 0x038c, 0x00bd, 0x038e, 0x038f, 
	0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 
	0x0398, 0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 
	0x03a0, 0x03a1,     -1, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 
	0x03a8, 0x03a9, 0x03aa, 0x03ab, 0x03ac, 0x03ad, 0x03ae, 0x03af, 
	0x03b0, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 
	0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 
	0x03c0, 0x03c1, 0x03c2, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 
	0x03c8, 0x03c9, 0x03ca, 0x03cb, 0x03cc, 0x03cd, 0x03ce,     -1
};
*/

#endif
