/* $Id: freebsd.h,v 1.2 2000/03/13 20:53:25 bergo Exp $ */

/* Process/CPU/Memory/etc. polling for FreeBSD*/

#include "transient.h"

#ifdef HAVEFREEBSD

#ifndef FREEBSD_H
#define FREEBSD_H

#include <gtk/gtk.h>
#include "polling.h"

class dpair {
 public:
  gint number;
  char name[64];
};

/// provides ONE kvm object for polling
class Kvm {
  public:
	  Kvm();
	  void *getp();
	  void *reference();
	  void dereference();

  private:
	  void Open();
	  void Close();
	  int refcount;
	  void *kvmp;
};

/// process list polling via FreeBSD
class FreeBSDProcessListPoller : public ProcessListPoller {
 public:
  /// constructor
  FreeBSDProcessListPoller();

  /// dereference kvm
  virtual void terminate();

  /// actual polling done here
  void poll();
};

/// process details via FreeBSD
class FreeBSDProcessDetailsPoller : public ProcessDetailsPoller {
 public:
  /// trivial constructor
  FreeBSDProcessDetailsPoller();

  /// dereference kvm
  virtual void terminate();

  /// actual polling done here
  void poll(int whichpid);

 private:
  void parse_process_flags(unsigned long flags,char *dest);
  void make_signal_string(unsigned long sigs,char *dest);
};

/// system information
class FreeBSDSystemInfoProvider : public SystemInfoProvider {
 public:
  /// trivial constructor.
  FreeBSDSystemInfoProvider();

  /// dereference kvm
  virtual void terminate();

  /// actual gathering done here.
  void update();

 private:
  gulong prevTotal,prevUsed;

  void update_cpu();
  void update_memory();
  int swapmode(unsigned long *retavail, unsigned long *retfree);

};


#endif /* inclusion guards */

#endif /* HAVEFREEBSD */
