/* pmud Monitor panel applet
 *
 * By Uwe Steinmann <uwe@steinmann.cx>
 *
 * Enjoy.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License  
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GIMON_H__
#define __GIMON_H__

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <panel-applet.h>

#define GRAPH_DATA_SAMPLES 2000
typedef struct _GRAPH_DATA {
	gfloat *xindex;    /* used for x coordinate */
	gfloat *current;
	gfloat *voltage;
} GRAPH_DATA;

typedef struct _BAT_STATUS {
	int present;
	int ac_on;
	int charging;
	int charge;
	int maxcharge;
	float current;
	float	voltage;
} BAT_STATUS;

typedef struct _PMUD_STATUS {
	BAT_STATUS bat[2]; /* 0 = bat left; 1 = bat right */
	char errmsg[100];
} PMUD_STATUS;

typedef struct _PmudData {
	PanelApplet *app;
	GtkWidget *globalbox;
	GtkWidget *pb;        // Property box
	GtkWidget *ch;        // charge box
	GtkWidget *databox_left, *databox_right;
	GtkWidget *marker_left, *marker_right;
	gfloat *markerx_left, *markerx_right;
	gfloat *markery_left, *markery_right;
	GtkWidget *xcoord_left, *ycoord_left;
	GtkWidget *xcoord_right, *ycoord_right;
	GtkWidget *charge_left, *charge_right;
	GtkWidget *bar1, *bar2;
	GtkWidget *gauge1, *gauge2;
	GtkWidget *gaugeframe1, *gaugeframe2;
	GtkTooltips *tooltip;
	PanelAppletOrient orient;
	GtkWidget *status_pixmap;
	GdkPixbuf *battery_in_pixmap;
	GdkPixbuf *ac_in_pixmap;
	GdkPixbuf *charge_in_pixmap;
	int height, width;
	int updatetime;
	int timeout;
	int graphupdatetime;
	int graphtimeout;
	int numsamples;
	int port;
	char *servername;
	gboolean show_current;
	gboolean sample_only;

	PMUD_STATUS *pmud_status;
	PMUD_STATUS *old_pmud_status;
	int valid_data;      /* 0 if current pmud_status is valid */

	GRAPH_DATA *graph_data_left, *graph_data_right;
#ifdef PMUD
	int pmudinfo;
#else
#endif
} PmudData;

#endif
