/*
Copyright (C) 2000-2005  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

int **typemax;
int *ctype;
static inline int is_subtype(int a, int b) {return typemax[a][b]==b;}

/*Mode:
  Mvar :  value cannot be determined at compile time
  Msidef: Statement has (probably) a side effect
  Mterm:  Statement never return.
  Mprec:  function need the prec arg.
  Melse     :  This is an if else block, (try to) be clever...
  If there is doubt, set Mvar, Msidef and Mprec but not Mterm.
  moveblock:
  Msemicomma:  This is a full statement, no need of ';'
  Mparens   :  May need to be braced by parens.
  Mbrace    :  This is a false block, no need of '{}'
  Mcopy     :  May need to be gcopyed.
  Mlong     :  long that need to be casted to GEN
*/
#define MODHERIT ((1<<Mvar)|(1<<Msidef)|(1<<Mterm)|(1<<Mprec))
typedef enum {Mvar, Msidef, Mterm, Mprec, Msemicomma, Mparens, Mbrace, Melse, Mcopy, Mlong, Msimple} Menum;

typedef enum {Gempty, Gvoid, Gnegbool, Gbool, Gsmall_int, Gsmall, Gint, Greal, Glg, Gvecsmall, Gvec, Gvar, Ggen, Ggenstr, Gstr, Gclosure, Gfunc_GG, Gnotype} Genum;

#ifdef TYPE
const char *Mneeded[]={"var","sidef","term","prec","semicomma","parens","brace","else","copy","long","simple",NULL};

const char *GPneeded[]={"empty","void","negbool","bool","small_int","small","int","real","lg","vecsmall","vec","var","gen","genstr","str","closure","func_GG","notype",NULL};
#endif
