# tests/test_greeting.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist
from gozerbot.plugins import plugins
import unittest

plugins.reload('gozerplugs.plugs', 'greeting')

class test_greeting(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'
    b.channels['#test'] = {}
    
    def test_greetingadd(self):
        result = self.b.test('greeting-add')
        self.assert_(stringinlist('<txt>', result))

    def test_greetingadd2(self):
        result = self.b.test('greeting-add mekker')
        self.b.test('greeting-del %s' % \
str(len(plugins['greeting'].greetings['test'])-1))
        self.assert_(stringinlist('added', result))

    def test_greetingdel(self):
        result = self.b.test('greeting-del')
        self.assert_(stringinlist('<nr>', result))

    def test_greetingdel2(self):
        self.b.test('greeting-add mekker')
        result = self.b.test('greeting-del %s' % \
str(len(plugins['greeting'].greetings['test'])-1))
        self.assert_(stringinlist('removed', result))

    def test_greetinglist(self):
        self.b.test('greeting-add mekker')
        result = self.b.test('greeting-list')
        self.b.test('greeting-del %s' % \
str(len(plugins['greeting'].greetings['test'])-1))
        self.assert_(stringinlist('mekker', result))
