# tests/test_core.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist
from gozerbot.plugins import plugins
import unittest

plugins.reload('gozerplugs.plugs', 'core')

class test_core(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'
    b.channels['#test'] = {}

    def test_encoding(self):
        result = self.b.test('encoding')
        self.assert_(stringinlist('default', result))

    def test_uptime(self):
        result = self.b.test('uptime')
        self.assert_(stringinlist('uptime', result))

    def test_userhostcache(self):
        result = self.b.test('userhostcache')
        self.assert_(stringinlist('test', result))

    def test_list(self):
        result = self.b.test('list')
        self.assert_(stringinlist('core', result))

    def test_list2(self):
        result = self.b.test('list core')
        self.assert_(stringinlist('uptime', result))

    def test_list2(self):
        result = self.b.test('list mekker')
        self.assert_(stringinlist('no commands', result))

    def test_available(self):
        result = self.b.test('available')
        self.assert_(stringinlist('core', result))

    def test_available(self):
        result = self.b.test('available')
        self.assert_(stringinlist('core', result))

    def test_commands(self):
        result = self.b.test('commands')
        self.assert_(stringinlist('commands', result))

    def test_commands2(self):
        result = self.b.test('commands OPER')
        self.assert_(stringinlist('reboot', result))

    def test_perm(self):
        result = self.b.test('perm')
        self.assert_(stringinlist('<cmnd>', result))

    def test_perm2(self):
        result = self.b.test('perm mekker2')
        self.assert_(stringinlist("can't find", result))

    def test_perm3(self):
        result = self.b.test('perm reboot')
        self.assert_(stringinlist("OPER", result))

    def test_cc(self):
        result = self.b.test('cc')
        self.assert_(stringinlist("default", result))

    def test_cc2(self):
        result = self.b.test('cc mekker')
        self.assert_(stringinlist("only one", result))

    def test_cc2(self):
        result = self.b.test('cc @')
        self.b.channels['#test']['cc'] ='!'
        self.assert_(stringinlist("set to", result))

    def test_ccadd(self):
        result = self.b.test('cc-add mekker')
        self.assert_(stringinlist("only one", result))

    def test_ccadd2(self):
        result = self.b.test('cc-add $')
        self.b.test('cc-del $')
        self.assert_(stringinlist("added", result))

    def test_ccdel(self):
        result = self.b.test('cc-del mekker')
        self.assert_(stringinlist("only one", result))

    def test_ccdel2(self):
        self.b.test('cc-add $')
        result = self.b.test('cc-del $')
        self.assert_(stringinlist("deleted", result))

    def test_intro(self):
        result = self.b.test('intro mekker')
        self.assert_(stringinlist("send", result))

    def test_loglevel(self):
        result = self.b.test('loglevel')
        self.assert_(stringinlist("loglevel is", result))

    def test_loglevel2(self):
        result = self.b.test('loglevel 100')
        self.assert_(stringinlist("100", result))

    def test_loglevel3(self):
        result = self.b.test('loglevel mekker')
        self.assert_(stringinlist("i need", result))

    def test_partylist(self):
        result = self.b.test('partylist')
        self.assert_(stringinlist("no party", result))

    def test_partysilent(self):
        result = self.b.test('party-silent')
        self.assert_(stringinlist("silent", result))

    def test_partyloud(self):
        result = self.b.test('party-loud')
        self.assert_(stringinlist("loud", result))

    def test_running(self):
        result = self.b.test('running')
        self.assert_(stringinlist("handleloop", result))

    def test_save(self):
        result = self.b.test('save')
        self.assert_(stringinlist("done", result))

    def test_version(self):
        result = self.b.test('version')
        self.assert_(stringinlist("GOZERBOT", result))

    def test_whereis(self):
        result = self.b.test('whereis')
        self.assert_(stringinlist("<cmnd>", result))

    def test_whereis2(self):
        result = self.b.test('whereis mekker')
        self.assert_(stringinlist("can't find", result))

    def test_whereis3(self):
        result = self.b.test('whereis version')
        self.assert_(stringinlist("core", result))

    def test_help(self):
        result = self.b.test('help')
        self.assert_(stringinlist("help", result))

    def test_help2(self):
        result = self.b.test('help core')
        self.assert_(stringinlist("plugin", result))

    def test_help3(self):
        result = self.b.test('help version')
        self.assert_(stringinlist("command", result))

    def test_apro(self):
        result = self.b.test('apro')
        self.assert_(stringinlist("<what>", result))

    def test_apro2(self):
        result = self.b.test('apro mekker')
        self.assert_(stringinlist("no matching", result))

    def test_apro3(self):
        result = self.b.test('apro version')
        self.assert_(stringinlist("version", result))

    def test_u(self):
        result = self.b.test('u')
        self.assert_(stringinlist("<nick>", result))

    def test_u2(self):
        result = self.b.test('u mekker')
        self.assert_(stringinlist("can't get", result))

    def test_u3(self):
        result = self.b.test('u test')
        self.assert_(stringinlist("test@test", result))
