# tests/test_alias.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist
from gozerbot.plugins import plugins
import unittest

plugins.reload('gozerplugs.plugs', 'alias')
plugins.reload('gozerplugs.plugs', 'core')

class test_alias(unittest.TestCase):
    b = Bot()

    def __init__(self, bla):
        self.b.userhosts['test'] = 'test@test'
        unittest.TestCase.__init__(self, bla)

    def test_alias(self):
        result = self.b.test('alias-set')
        self.assert_(stringinlist('<from>', result))

    def test_alias2(self):
        result = self.b.test('alias-set mekker')
        self.assert_(stringinlist('<from>', result))

    def test_alias3(self):
        result = self.b.test('alias-set mekker bla')
        self.assert_(stringinlist('not exist', result))

    def test_alias4(self):
        result = self.b.test('alias-set mekker version')
        self.assert_(stringinlist('alias added', result))

    def test_alias5(self):
        result = self.b.test('alias-set mekker avail')
        self.assert_(stringinlist('cannot', result))

    def test_alias6(self):
        self.b.test('alias-set mekker version')
        result = self.b.test('mekker')
        self.assert_(stringinlist('GOZERBOT', result))

    def test_aliasget(self):
        result = self.b.test('alias-get')
        self.assert_(stringinlist('<what>', result))

    def test_aliasget2(self):
        result = self.b.test('alias-get blablabla')
        self.assert_(stringinlist('there is no', result))

    def test_aliasget3(self):
        self.b.test('alias-set mekker version')
        result = self.b.test('alias-get mekker')
        self.assert_(stringinlist('version', result))

    def test_aliassearch(self):
        result = self.b.test('alias-search')
        self.assert_(stringinlist('<what>', result))

    def test_aliassearch2(self):
        result = self.b.test('alias-search blablabla')
        self.assert_(stringinlist('no blablabla found', result))

    def test_aliassearch3(self):
        self.b.test('alias-set mekker version')
        result = self.b.test('alias-search mekker')
        self.assert_(stringinlist('version', result))

    def test_aliasdel(self):
        result = self.b.test('alias-del')
        self.assert_(stringinlist('<what>', result))

    def test_aliasdel2(self):
        result = self.b.test('alias-del blablabla')
        self.assert_(stringinlist('there is no', result))

    def test_aliasdel3(self):
        result = self.b.test('alias-del mekker')
        self.assert_(stringinlist('alias deleted', result))
