# plugs/upgrade.py
#
#

""" upgrade command .. determine on svn/mercurial update's output if plugs can
    be reloaded or that the bot has to be rebooted
"""

__copyright__ = 'this file is in the public domain'

from gozerbot.fleet import fleet
from gozerbot.plugins import plugins
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.generic import reboot, gozerpopen, lockdec, handle_exception
from gozerbot.eventhandler import mainhandler
from gozerbot.plughelp import plughelp
from gozerbot.config import config, gethgrev
from gozerbot.lockmanager import lockmanager
from gozerbot.partyline import partyline
import os, os.path, time

plughelp.add('upgrade', "do a mercurial hg pull -u / svn update  and see if \
we need to reboot .. if only plugins are updated we don't need to reboot \
because we can reload them")

def handle_hgupgrade(bot, ievent, silent=None):
    """ upgrade .. do a mercurial pull -u .. see if we need to reboot \
        otherwise reload plugins """
    startrev = int(gethgrev())
    url = None
    if ievent.rest:
        if not ievent.rest.startswith('http://'):
            ievent.reply('i need a url as argument')
            return
        url = ievent.rest
    else:
        url = config['upgradeurl']
    args = ['hg', 'pull', '-u']
    userargs = []
    if url:
        userargs.append(url)
    try:
        proces = gozerpopen(args, userargs)
    except Exception, ex:
        ievent.reply('error running popen: %s' % str(ex))
        return
    nochange = 0
    lines = proces.fromchild.readlines()
    proces.close()
    res = []
    for i in lines:
        if 'abort: error:' in i:
            ievent.reply('failed to update ==>  %s' % i)
            return
        if 'no changes' in i:
            nochange = 1
        res.append(i.strip())
    if nochange:
        ievent.reply('no changes')
        return
    else:
        not silent and ievent.reply(' .. '.join(res))
    rev = gethgrev()
    ievent.reply('revision is %s' % rev)
    args = ['hg', 'diff', '-r%s' % startrev]
    try:
        proces = gozerpopen(args)
    except Exception, ex:
        ievent.reply('error running popen: %s' % str(ex))
        return
    data = proces.fromchild.readlines()
    returncode = proces.close()
    if returncode != 0:
        ievent.reply("can't run hg diff")
        return
    files = []
    plugs = []
    dbplugs = []
    needreboot = 0
    for i in data:
        if i.startswith('+++') or i.startswith('---'):
            if len(i.split()) < 2:
                continue
            filename = '%s' % os.sep
            filename = filename.join(i.split()[1].split(os.sep)[1:])
            if filename == 'dev/null':
                continue
            if filename not in files:
                files.append(filename)
            if not filename.endswith('.py'):
                continue
            if filename.startswith('gozerbot'): 
                needreboot = 1
            elif filename.find('dbplugs') != -1:
                if not config['dbenable']:
                    continue
                if filename not in dbplugs:
                    dbplugs.append(filename)
            elif filename.find('plugs') != -1:
                if filename not in plugs:
                    plugs.append(filename)
    not silent and ievent.reply('files: ' + ' '.join(files))
    summary = []
    args = ['hg', 'log', '-r%s:%s' % (rev, startrev+1)]
    try:
        proces = gozerpopen(args)
    except Exception, ex:
        ievent.reply('error running popen: %s' % str(ex))
        return
    data = proces.fromchild.readlines()
    returncode = proces.close()
    if returncode == 0:
        for i in data:
            if i.startswith('summary:'):
                summary.append(i.split('summary:')[1].strip())
        not silent and ievent.reply("summaries: %s" % ' .. '.join(summary))
    if needreboot:
        ievent.reply('rebooting')
        time.sleep(4)
        try:
            plugins.exit()
            fleet.save()
        finally:
            time.sleep(1)
            mainhandler.put(0, reboot)
            return
    config.load()
    if not plugs and not dbplugs:
        ievent.reply('nothing to reload')
        return
    ievent.reply("reloading %s" %  " .. ".join(dbplugs + plugs))
    failed = plugins.listreload(plugs)
    if config['dbenable']:
        failed += plugins.listreload(dbplugs)
    if failed:
        ievent.reply("failed to reload %s" % ' .. '.join(failed))
        return
    else:
        ievent.reply('done')

cmnds.add('upgrade-hg', handle_hgupgrade, ['OPER', 'UPGRADE'])
examples.add('upgrade-hg', 'do a mercurial upgrade', 'upgrade-hg')

def handle_svnupgrade(bot, ievent, silent=None):
    """ do a svn update and check if we have to reboot or that plugs reload
        is enough
    """
    ievent.reply("doing svn upgrade")
    args = ['svn', 'update']
    try:
        proces = gozerpopen(args)
    except Exception, ex:
        ievent.reply('error running popen: %s' % str(ex))
        return
    data = proces.fromchild.readlines()
    returncode = proces.close()
    if returncode:
        ievent.reply('error running svn update')
        return
    plugs = []
    dbplugs = []
    needreboot = 0
    res = []
    for line in data:
        res.append(line.strip())
    if res:
        ievent.reply(" .. ".join(res))
    # see if we need to reboot and if not what plugins need to be reloaded
    for line in res:
        try:
            (svnaction, filename) = line.split()
        except ValueError:
            continue
        if svnaction == 'D':
            continue
        if filename.startswith('gozerbot'): 
            needreboot = 1
            break
        elif filename.find('dbplugs') != -1:
            if not config['dbenable']:
                continue
            if filename not in dbplugs:
                dbplugs.append(filename)
        elif filename.find('plugs') != -1:
            if filename not in plugs:
                plugs.append(filename)
    if needreboot:
        ievent.reply('need reboot')
        time.sleep(4)
        try:
            plugins.exit()
            fleet.save()
        finally:
            time.sleep(1)
            mainhandler.put(0, reboot)
    if not plugs and not dbplugs:
        ievent.reply('nothing to reload')
        return
    ievent.reply("reloading %s" %  " .. ".join(dbplugs + plugs))
    failed = plugins.listreload(plugs)
    if config['dbenable']:
        failed += plugins.listreload(dbplugs)
    if failed:
        ievent.reply("failed to reload %s" % ' .. '.join(failed))
        return
    else:
        ievent.reply('done')

cmnds.add('upgrade-svn', handle_svnupgrade, ['OPER', 'UPGRADE'])
examples.add('upgrade-svn', 'upgrade the bot with svn', 'upgrade-svn')

def handle_upgradesilent(bot, ievent):
    """ do a 'silent' upgrade """
    lockmanager.acquire('up')
    if os.path.isdir('.hg'):
        try:
            handle_hgupgrade(bot, ievent, True)
        except Exception, ex: 
            handle_exception(ievent=ievent)
        lockmanager.release('up')
        return
    if os.path.isdir('.svn'):
        try:
            handle_svnupgrade(bot, ievent, True)
        except Exception, ex: 
            handle_exception(ievent=ievent)
        lockmanager.release('up')
        return
    ievent.reply('i need a svn or mercurial repository for upgrade to work')
    lockmanager.release('up')
    
cmnds.add('upgrade', handle_upgradesilent, ['OPER', 'UPGRADE'])
examples.add('upgrade', 'do a svn or mercurial upgrade', \
'upgrade')

def handle_upgradeloud(bot, ievent):
    """ do a verbose upgrade """
    lockmanager.acquire('up')
    if os.path.isdir('.hg'):
        try:
            handle_hgupgrade(bot, ievent)
        except Exception, ex: 
            handle_exception(ievent=ievent)
        lockmanager.release('up')
        return
    if os.path.isdir('.svn'):
        try:
            handle_svnupgrade(bot, ievent)
        except Exception, ex: 
            handle_exception(ievent=ievent)
        lockmanager.release('up')
        return
    ievent.reply('i need a svn or mercurial repository for upgrade to work')
    lockmanager.release('up')
    
cmnds.add('upgrade-loud', handle_upgradeloud, ['OPER'])
examples.add('upgrade-loud', 'do a svn or mercurial upgrade', 'upgrade-loud')
