# plugs/install.py
#
#

""" install plugins from remote site """

__copyright__ = 'this file is in the public domain'

from gozerbot.datadir import datadir
from gozerbot.generic import geturl2, waitforuser, touch
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.plugins import plugins
from gozerbot.plughelp import plughelp
from gozerbot.aliases import aliasdel
from gozerbot.pdod import Pdod
from gozerbot.pgp import pgp, PgpNoPubkeyException, NoGPGException
import re, urllib2, urlparse, os

class Cfg(Pdod):

    """ contains plugin version data """
    def __init__(self):
        Pdod.__init__(self, os.path.join(datadir, 'install'))

    def add(self, plugin, version):
        """ add plugin version """
        self.data[plugin] = version
        self.save()

    def list(self):
        """ list plugin versions """
        return self.data

cfg = Cfg()

plughelp.add('install', 'install plugin from webserver')

# check if logs dir exists if not create it
if not os.path.isdir('myplugs'):
    os.mkdir('myplugs')
    touch('myplugs/__init__.py') 

installsites = ['http://gozerbot.org/plugs', 'http://tehmaze.com/plugs']

def install(url):
    """ install a plugin from url """
    signature = geturl2("%s.asc" % url)
    if not signature:
        return 0
    plug = geturl2(url)
    fingerprint = pgp.verify_signature(plug, signature)
    if not fingerprint:
        return 0
    what = url.split('/')[-1]
    plugfile = open('myplugs' + os.sep + '%s' % what,'w')
    plugfile.write(plug)
    plugfile.close()
    if hasattr(plug, 'info') and plug.info.has_key('last-modified'):
        cfg.add(what, [url, plug.info['last-modified']])
    return 1

def install_pgp(plugserver, dirr, what, ievent, signature):
    """ install a plugin from plugserver/dirr using signature to verify """
    if not plugserver.startswith('http://'):
        plugserver = 'http://' + plugserver
    if what.endswith('.py'):
        what = what[:-3]
    what = what.split(os.sep)[-1]
    url = '%s/%s/%s.py' % (plugserver, dirr, what)
    try:
        plug = geturl2(url)
    except urllib2.HTTPError:
        ievent.reply("no %s plugin on server" % what)
        return
    except urllib2.URLError, ex:
        ievent.reply("there was a problem fetching %s .. %s" % (url, str(ex)))
        return
    try:
        fingerprint = pgp.verify_signature(plug, signature)
    except NoGPGException, e:
        ievent.reply("couldn't run gpg .. please install gnupg if you want \
to install remote plugins")
        return
    except PgpNoPubkeyException, e:
        ievent.reply("could not verify pgp signature, key %s not found \
(use install-key)" % str(e))
        return
    if not fingerprint:
        ievent.reply('could not verify pgp signature, no valid signature \
found')
        return
    ievent.reply('plugin %s verified with key id %s' % (what, fingerprint))
    plugfile = open('myplugs' + os.sep + '%s.py' % what,'w')
    plugfile.write(plug)
    plugfile.close()
    if hasattr(plug, 'info') and plug.info.has_key('last-modified'):
        while '//' in dirr:
            dirr = dirr.replace('//', '/')
        cfg.add(what, [url, plug.info['last-modified']])
    return 1

def update():
    """ update remote installed plugins """
    updated = []
    all = cfg.list()
    for plug in all.keys():
        try:
            if plug in plugins.plugdeny.data:
                continue
            data = geturl2(all[plug][0])
            if hasattr(data, 'info') and data.info.has_key('last-modified'):
                if data.info['last-modified'] > all[plug][1]:
                    updated.append(all[plug][0])
        except urllib2.HTTPError:
            pass
        except urllib2.URLError:
            pass
    return updated

def handle_install(bot, ievent):
    """ install <server> <dir> <plugin> .. install plugin from server """
    if ievent.stripped != bot.owner:
        ievent.reply('only owneruserhost can use install')
        return
    try:
        (server, dirr, plug) = ievent.args
    except ValueError:
        if 'install-plug' in ievent.origtxt:
            ievent.missing("<server> <dir> <plug>")
        else:
            ievent.missing("<server> <dir> <plug> (maybe try install-plug ?)")
        return
    if plug.endswith('.py'):
        plug = plug[:-3]
    plug = plug.split(os.sep)[-1]
    url = 'http://%s/%s/%s' % (server, dirr, plug)
    try:
        readme = geturl2(url + '.README')
        if readme:
            readme = readme.replace('\n', ' .. ')
            readme = re.sub('\s+', ' ', readme)
            readme += ' (yes/no)'
            ievent.reply(readme)
            response =  waitforuser(bot, ievent.userhost)
            if not response or response.txt != 'yes':
                ievent.reply('not installing %s' % plug)
                return
    except:
        pass
    signature = None
    try:
        if not plug.endswith('.py'):
            what = plug + '.py'
        else:
            what = plug
        signature = geturl2("http://%s/%s/%s.asc" % (server, dirr, what))
    except urllib2.URLError, ex:
        ievent.reply("there was a problem fetching %s .. %s" % (what + \
'.asc', str(ex)))
        return
    except urllib2.HTTPError:
        ievent.reply('could not fetch pgp signature .. not installing %s' % \
plug)
        return
    ievent.reply('fetching %s' % plug)
    if not install_pgp(server, dirr, plug, ievent, signature):
        ievent.reply('failed to install %s' % plug)
        return
    if plugins.reload('myplugs', plug):
        ievent.reply("%s reloaded" % plug)
    else:
        ievent.reply('reload of %s failed' % plug)

cmnds.add('install', handle_install, 'OPER')
examples.add('install', 'install <server> <dir> <plug>: install \
http://<plugserver>/<dir>/<plugin>.py from server (maybe try install-plug \
?)', 'install r8.cg.nu plugs dict')

def handle_installplug(bot, ievent):
    """ remotely install a plugin """
    if ievent.stripped != bot.owner:
        ievent.reply('only owneruserhost can use install')
        return
    try:
        plug = ievent.args[0]
    except IndexError:
        ievent.missing('<plugname>')
        return
    plug = plug.split(os.sep)[-1]
    errors = {}
    ok = False
    for i in installsites:
        url = i + '/' + plug + '.py'
        try:
            readme = geturl2(url[:-3] + '.README')
            if readme:
                readme = readme.replace('\n', ' .. ')
                readme = re.sub('\s+', ' ', readme)
                readme += ' (yes/no)'
                ievent.reply(readme)
                response =  waitforuser(bot, ievent.userhost)
                if not response or response.txt != 'yes':
                    ievent.reply('not installing %s' % plug)
                    return
        except:
            pass
        try:
            if install(url):
                ievent.reply('%s installed' % url) 
                ok = True
                break
        except NoGPGException, ex:
            ievent.reply("couldn't run gpg .. please install gnupg if you \
want to install remote plugins")
            return
        except Exception, ex:
            errors[url] = str(ex)
    if ok and plugins.reload('myplugs', plug):
        ievent.reply("%s reloaded" % plug)
        return
    elif ok:
        ievent.reply('reload of %s failed' % plug)
        return
    errorlist = []
    for i, j in errors.iteritems():
        errorlist.append("%s => %s" % (i, j)) 
    ievent.reply("couldn't install %s .. reasons: " % plug, errorlist, \
dot=True)
    
cmnds.add('install-plug', handle_installplug, 'OPER')
examples.add('install-plug', 'try to install a plugin checking all knows \
sites', 'install-plug 8b')
aliasdel('install-plug')

def handle_installkey(bot, ievent):
    """ install a remote gpg key into the keyring """
    if len(ievent.args) != 1:
        return ievent.missing('<key id> or <key file url>')
    url = ievent.args[0]
    if url.startswith('http://'):
        try:
            pubkey = geturl2(url)
        except urllib2.HTTPError:
            return ievent.reply('failed to fetch key from %s' % ievent.args[0])
        except urllib2.URLError, ex:
            ievent.reply("there was a problem fetching %s .. %s" % (url, \
str(ex)))
            return
        fingerprint = pgp.imports(pubkey)
        if fingerprint:
            return ievent.reply('installed key with fingerprint %s' % \
fingerprint)
        else:
            return ievent.reply('no valid pgp public key found')
    if not re.compile('^[0-9a-f]*', re.I).search(ievent.args[0]):
        return ievent.reply('invalid key id') 
    if pgp.imports_keyserver(ievent.args[0]):
        return ievent.reply('imported key %s from %s' % \
(ievent.args[0].upper(), pgp.keyserver))
    ievent.reply('failed to import key %s from %s' % (ievent.args[0].upper(), \
pgp.keyserver))

cmnds.add('install-key', handle_installkey, 'OPER')
examples.add('install-key', 'install a pgp key', \
'1) install-key 2A22EC17F9EBC3D8 2) install-key \
http://pgp.mit.edu:11371/pks/lookup?op=get&search=0xF9EBC3D8')

def handle_installlist(bot, ievent):
    """ install-list .. list the available remote installable plugs """
    if ievent.stripped != bot.owner:
        ievent.reply('only owneruserhost can use install')
        return
    errors = []
    result = []
    for i in installsites:
        try:
            pluglist = geturl2(i)
        except Exception, ex:
            errors.append(i)
            continue
        result += re.findall('<a href="(.*?)\.py">', pluglist)
        try:
            result.remove('__init__')
        except ValueError:
            pass
    if result:
        result.sort()
        ievent.reply('available plugins: ', result, dot=True)
    if errors:
        ievent.reply("couldn't extract plugin list from: ", errors, dot=True)

cmnds.add('install-list', handle_installlist, 'OPER')
examples.add('install-list', 'list plugins that can be installed', \
'install-list')

def handle_installsites(bot, ievent):
    """ show from which sites one can install plugins """
    ievent.reply("install sites: ", installsites, dot=True)

cmnds.add('install-sites', handle_installsites, 'USER')

def handle_installupdate(bot, ievent):
    """ update command for remote installed plugins """ 
    updating = update()
    update_pass = []
    update_fail = []
    plugs = []
    if updating:
        updating.sort()
        ievent.reply('updating: %s' % ', '.join(updating))
        for release in updating:
            parts = urlparse.urlparse(release)
            what = parts[2].split('/')[-1].replace('.py', '')
            try:
                install(release)
                update_pass.append(what)
            except Exception, ex:
                update_fail.append(release)
        update_pass.sort()
        update_fail.sort()
        if update_fail:
            ievent.reply("failed updating %s" % " .. ".join(update_fail))
        if update_pass:
            plugs = ['myplugs/%s.py' % plug for plug in update_pass]
            ievent.reply("reloading %s" %  " .. ".join(plugs))
            failed = plugins.listreload(plugs)
            if failed:
                ievent.reply("failed to reload %s" % ' .. '.join(failed))
                return
            else:
                ievent.reply('done')
    else:
        ievent.reply('no updates found') 

cmnds.add('install-update', handle_installupdate, 'OPER')

def handle_installversion(bot, ievent):
    """ show versions of installed plugins """
    all = cfg.list()
    plugs = all.keys()
    if plugs:
        plugs.sort()
        ievent.reply(', '.join(['%s: %s' % (all[plug][0], all[plug][1]) \
for plug in plugs]))
    else:
        ievent.reply('no versions tracked')

cmnds.add('install-version', handle_installversion, 'OPER')
