<?php
/*
 * This code is part of GOsa (http://www.gosa-project.org)
 * Copyright (C) 2003-2008 GONICUS GmbH
 *
 * ID: $$Id: class_target_list.inc 9850 2008-03-14 14:15:12Z hickert $$
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

class objectSelect extends management
{
    // Tab definition 
    protected $skipFooter = TRUE;
    protected $skipHeader = TRUE;

    var $plHeadline = "Object selection";

    function __construct($config,$ui)
    {
        $this->config = $config;
        $this->ui = $ui;
        $this->storagePoints = array(
                get_ou("core", "userRDN"), 
                get_ou("core", "groupRDN"),
                get_ou("termgeneric", "terminalRDN"),
                get_ou("workgeneric", "workstationRDN"),
                get_ou("servgeneric", "serverRDN"),
                get_ou("printgeneric", "printerRDN"),
                get_ou("phoneGeneric", "phoneRDN"));

        // Build filter
        if (session::global_is_set(get_class($this)."_filter")){
            $filter= session::global_get(get_class($this)."_filter");
        } else {
            $filter = new filter(get_template_path("selectObject-filter.xml", true, dirname(__FILE__)));
            $filter->setObjectStorage($this->storagePoints);
        }
        $this->setFilter($filter);

        // Build headpage
        $headpage = new listing(get_template_path("selectObject-list.xml", true, dirname(__FILE__)));
        $headpage->registerElementFilter("depLabel", "objectSelect::filterDepLabel");
        $this->registerAction("open","openEntry");
        $headpage->setFilter($filter);
        parent::__construct($config, $ui, "object", $headpage);
    }


    // An action handler which enables to switch into deparmtment by clicking the names.
    function openEntry($action,$entry)
    {
        $headpage = $this->getHeadpage();
        $headpage->setBase(array_pop($entry));
    }


    // A filter which allows to open a department by clicking on the departments name.
    static function filterDepLabel($row,$dn,$pid,$base,$objectClass, $cn)
    {
        $cn = $cn[0];
        if(!in_array('gosaDepartment', $objectClass)){
            return($cn);
        }
        if($dn == $base){
            $cn =".";
        }
        $dn= LDAP::fix(func_get_arg(1));
        return("<a href='?plug=".$_GET['plug']."&amp;PID=$pid&amp;act=listing_open_$row' title='$dn'>$cn</a>");
    }

    function save()
    {
        $act = $this->detectPostActions();
        $headpage = $this->getHeadpage();
        if(!isset($act['targets'])) return(array());
        $ret = array();
        foreach($act['targets'] as $dn){
            $ret[] = $headpage->getEntry($dn);
        }
        return($ret);
    }
}
// vim:tabstop=2:expandtab:shiftwidth=2:filetype=php:syntax:ruler:
?>
