/*
 * Copyright (C) 2007  Miriam Ruiz <little_miry@yahoo.es>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _games_filter_h
#define _games_filter_h

#include "taghandler.h"

#include <set>
#include <ept/debtags/tag.h>

class PackageFilter
{
public:
	PackageFilter();
	~PackageFilter();

	enum {
		Green = 1, // Green light, the tag/package is safe
		Unknown,   // The calification for the tag/package is unknown
		Yellow,    // Yellow light, handle with care
		Red,       // Green light, the tag/package is definitely unsafe
		Black,     // Mayday, mayday, the tag/package might be really dangerous!
	};

	typedef ept::debtags::Tag Tag;
	typedef std::set<Tag> TagSet;

	bool GreenTag(const Tag &tag);
	bool YellowTag(const Tag &tag);
	bool RedTag(const Tag &tag);
	bool BlackTag(const Tag &tag);
	int TagValue(const Tag &tag);
	int TagsValue(const TagSet &tags);

protected:
	FilterTagHandler tagdata;
	FilterTagHandler::Result green_tags;
	FilterTagHandler::Result yellow_tags;
	FilterTagHandler::Result red_tags;
	FilterTagHandler::Result black_tags;
};

#endif
