/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2011 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#include "gmdefs.h"
#include "GMFilename.h"

const char section_window[] = "window";
const char section_import[] = "import";
const char section_export[] = "export";
const char section_player[] = "player";
const char section_colors[] = "colors";
const char section_dbus[]   = "dbus";
const char section_app[]    = "application";
const char section_sync[]   = "sync";

const char key_import_default_field[]="default-user-title";
const char key_import_track_from_filelist[]="track-from-filelist";
const char key_import_replace_underscores[]="replace-underscores";
const char key_import_parse_filename_only[]="parse-filename-only";
const char key_import_filename_template[]="filename-template";
const char key_import_parse_method[]="parse-method";
const char key_import_exclude_folder[]="exclude-folder";
const char key_import_exclude_file[]="exclude-file";

const char key_export_format_template[]="format-template";
const char key_export_character_filter[]="character-filter";
const char key_export_encoding[]="encoding";
const char key_export_lowercase[]="lowercase";
const char key_export_lowercase_extension[]="lowercase-extension";
const char key_export_underscore[]="underscore";

const char key_gui_format_title[]="title-format";
const char key_gui_show_status_bar[]="show-statusbar";
const char key_gui_hide_player_when_close[]="hide-player-when-close";
const char key_gui_toolbar_bigicons[]="toolbar-bigicons";
const char key_gui_toolbar_docktop[]="toolbar-docktop";
const char key_gui_toolbar_showlabels[]="toolbar-labels";
const char key_gui_show_browser_icons[]="browser-icons";
const char key_gui_keywords[]="sort-keywords";
const char key_gui_show_playing_albumcover[]="show-playing-albumcover";
const char key_gui_show_albumcovers[]="show-albumcovers";
const char key_gui_tray_icon[]="tray-icon";
const char key_gui_show_playing_titlebar[]="show-playing-titlebar";
const char key_gui_coverdisplay_size[]="cover-display-size";
const char key_gui_show_opengl_coverview[]="show-opengl-coverview";


const char key_gui_row_color[]="row-color";
const char key_gui_play_color[]="play-color";
const char key_gui_playtext_color[]="playtext-color";
const char key_gui_tray_color[]="tray-back-color";

const char key_play_repeat[]="repeat-mode";
const char key_play_replaygain[]="replay-gain";
const char key_play_close_stream[]="close-audio-stream";
const char key_play_pause_close_device[]="pause-close-device";
const char key_play_gapless[]="gapless-playback";
const char key_play_shuffle[]="shuffle";
const char key_play_open_device_on_startup[]="open_audio_device_on_startup";

const char key_dbus_notify_daemon[]="notification-daemon";

const char key_sync_import_new[]="import-new";
const char key_sync_remove_missing[]="remove-missing";
const char key_sync_remove_all[]="remove-all";
const char key_sync_update[]="update";
const char key_sync_update_always[]="update-always";



GMImportOptions::GMImportOptions() :
  default_field("Untitled"),
  filename_template("%P/%A/%N %T"),
  track_from_filelist(false),
  replace_underscores(true),
  parse_method(PARSE_BOTH){
  }

void GMImportOptions::save(FXSettings & reg) const {
  reg.writeBoolEntry(section_import,key_import_track_from_filelist,track_from_filelist);
  reg.writeBoolEntry(section_import,key_import_replace_underscores,replace_underscores);
  reg.writeStringEntry(section_import,key_import_default_field,default_field.text());
  reg.writeStringEntry(section_import,key_import_filename_template,filename_template.text());
  reg.writeStringEntry(section_import,key_import_exclude_folder,exclude_folder.text());
  reg.writeStringEntry(section_import,key_import_exclude_file,exclude_file.text());
#if FOXVERSION < FXVERSION(1,7,0)
  reg.writeUnsignedEntry(section_import,key_import_parse_method,parse_method);
#else
  reg.writeUIntEntry(section_import,key_import_parse_method,parse_method);
#endif
  }

void GMImportOptions::load(FXSettings & reg) {
  track_from_filelist    = reg.readBoolEntry(section_import,key_import_track_from_filelist,track_from_filelist);
  replace_underscores    = reg.readBoolEntry(section_import,key_import_replace_underscores,replace_underscores);
  default_field          = reg.readStringEntry(section_import,key_import_default_field,default_field.text());
  filename_template      = reg.readStringEntry(section_import,key_import_filename_template,filename_template.text());
  exclude_folder         = reg.readStringEntry(section_import,key_import_exclude_folder,exclude_folder.text());
  exclude_file           = reg.readStringEntry(section_import,key_import_exclude_file,exclude_file.text());
#if FOXVERSION < FXVERSION(1,7,0)
  parse_method           = FXMIN(reg.readUnsignedEntry(section_import,key_import_parse_method,parse_method),(FXuint)PARSE_BOTH);
#else
  parse_method           = FXMIN(reg.readUIntEntry(section_import,key_import_parse_method,parse_method),(FXuint)PARSE_BOTH);
#endif

  }


GMSyncOptions::GMSyncOptions() :
  import_new(true),
  remove_missing(true),
  remove_all(false),
  update(false),
  update_always(false) {
  }

void GMSyncOptions::save(FXSettings & reg) const {
  reg.writeBoolEntry(section_sync,key_sync_import_new,import_new);
  reg.writeBoolEntry(section_sync,key_sync_remove_missing,remove_missing);
  reg.writeBoolEntry(section_sync,key_sync_remove_all,remove_all);
  reg.writeBoolEntry(section_sync,key_sync_update,update);
  reg.writeBoolEntry(section_sync,key_sync_update_always,update_always);
  }

void GMSyncOptions::load(FXSettings & reg) {
  import_new     = reg.readBoolEntry(section_sync,key_sync_import_new,import_new);
  remove_missing = reg.readBoolEntry(section_sync,key_sync_remove_missing,remove_missing);
  remove_all     = reg.readBoolEntry(section_sync,key_sync_remove_all,remove_all);
  update         = reg.readBoolEntry(section_sync,key_sync_update,update);
  update_always  = reg.readBoolEntry(section_sync,key_sync_update_always,update_always);
  }


GMPreferences::GMPreferences() :
  export_format_template("%N %T"),
  export_character_filter("\'\\#~!\"$&();<>|`^*?[]/.:"),
  gui_format_title("%N - %T - %P"),

  gui_show_status_bar(true),
  gui_hide_player_when_close(false),
  gui_toolbar_bigicons(true),
  gui_toolbar_docktop(true),
  gui_toolbar_showlabels(true),
  gui_show_browser_icons(true),
  gui_show_playing_albumcover(false),
  gui_show_albumcovers(false),
  gui_tray_icon(false),
  gui_show_playing_titlebar(false),
  gui_show_opengl_coverview(true),
  gui_coverdisplay_size(256),

  play_replaygain(REPLAYGAIN_OFF),
  play_repeat(REPEAT_ALL),
  play_close_stream(false),
  play_pause_close_device(false),
  play_gapless(true),
  play_shuffle(false),
  play_open_device_on_startup(false),

  export_encoding(GMFilename::ENCODING_ASCII),
  export_lowercase(false),
  export_lowercase_extension(true),
  export_underscore(false),

  dbus_notify_daemon(false) {
  resetColors();
  }

void GMPreferences::save(FXSettings & reg) const {
  FXString keywords;
  getKeyWords(keywords);

  /// Write out version information
  reg.writeIntEntry(section_app,"major-version",APPLICATION_MAJOR);
  reg.writeIntEntry(section_app,"minor-version",APPLICATION_MINOR);
  reg.writeIntEntry(section_app,"level-version",APPLICATION_LEVEL);

  import.save(reg);
  sync.save(reg);

  /// Export
  reg.writeBoolEntry(section_export,key_export_lowercase,export_lowercase);
  reg.writeBoolEntry(section_export,key_export_lowercase_extension,export_lowercase_extension);
  reg.writeBoolEntry(section_export,key_export_underscore,export_underscore);
  reg.writeStringEntry(section_export,key_export_format_template,export_format_template.text());
  reg.writeStringEntry(section_export,key_export_character_filter,export_character_filter.text());

#if FOXVERSION < FXVERSION(1,7,0)
  reg.writeUnsignedEntry(section_export,key_export_encoding,export_encoding);
#else
  reg.writeUIntEntry(section_export,key_export_encoding,export_encoding);
#endif

  /// Colors
  reg.writeColorEntry(section_colors,key_gui_row_color,gui_row_color);
  reg.writeColorEntry(section_colors,key_gui_play_color,gui_play_color);
  reg.writeColorEntry(section_colors,key_gui_playtext_color,gui_playtext_color);
  reg.writeColorEntry(section_colors,key_gui_tray_color,gui_tray_color);

  /// Window
  reg.writeBoolEntry(section_window,key_gui_hide_player_when_close,gui_hide_player_when_close);
  reg.writeBoolEntry(section_window,key_gui_show_status_bar,gui_show_status_bar);
  reg.writeBoolEntry(section_window,key_gui_toolbar_bigicons,gui_toolbar_bigicons);
  reg.writeBoolEntry(section_window,key_gui_toolbar_docktop,gui_toolbar_docktop);
  reg.writeBoolEntry(section_window,key_gui_toolbar_showlabels,gui_toolbar_showlabels);
  reg.writeBoolEntry(section_window,key_gui_show_browser_icons,gui_show_browser_icons);
  reg.writeStringEntry(section_window,key_gui_keywords,keywords.text());
  reg.writeBoolEntry(section_window,key_gui_show_playing_albumcover,gui_show_playing_albumcover);
  reg.writeBoolEntry(section_window,key_gui_show_albumcovers,gui_show_albumcovers);
  reg.writeBoolEntry(section_window,key_gui_tray_icon,gui_tray_icon);
  reg.writeBoolEntry(section_window,key_gui_show_playing_titlebar,gui_show_playing_titlebar);
  reg.writeBoolEntry(section_window,key_gui_show_opengl_coverview,gui_show_opengl_coverview);
  reg.writeIntEntry(section_window,key_gui_coverdisplay_size,gui_coverdisplay_size);
  reg.writeStringEntry(section_window,key_gui_format_title,gui_format_title.text());


  /// Player
  reg.writeIntEntry(section_player,key_play_repeat,play_repeat);
  reg.writeIntEntry(section_player,key_play_replaygain,play_replaygain);
  reg.writeBoolEntry(section_player,key_play_close_stream,play_close_stream);
  reg.writeBoolEntry(section_player,key_play_pause_close_device,play_pause_close_device);
  reg.writeBoolEntry(section_player,key_play_gapless,play_gapless);
  reg.writeBoolEntry(section_player,key_play_shuffle,play_shuffle);
  reg.writeBoolEntry(section_player,key_play_open_device_on_startup,play_open_device_on_startup);

  /// Dbus
  reg.writeBoolEntry(section_dbus,key_dbus_notify_daemon,dbus_notify_daemon);
  }


void GMPreferences::load(FXSettings & reg) {
  FXString keywords="a;an;the";

  /// Remove Keys that interfere with new ones..
  if (reg.readIntEntry(section_app,"major-version",0)==0 && reg.readIntEntry(section_app,"minor-version",8)<9) {
    FXint s;
    FXStringDict *dict;
    for (s = reg.first(); s < reg.size(); s = reg.next(s)){
      dict = reg.data(s);
      dict->remove("browse-showcolumn-no");
      dict->remove("list-showcolumn-no");
      }
    }

  /// Write out version information
  reg.writeIntEntry(section_app,"major-version",APPLICATION_MAJOR);
  reg.writeIntEntry(section_app,"minor-version",APPLICATION_MINOR);
  reg.writeIntEntry(section_app,"level-version",APPLICATION_LEVEL);


  import.load(reg);
  sync.load(reg);

  /// Export
  export_lowercase              = reg.readBoolEntry(section_export,key_export_lowercase,export_lowercase);
  export_lowercase_extension    = reg.readBoolEntry(section_export,key_export_lowercase_extension,export_lowercase_extension);
  export_underscore             = reg.readBoolEntry(section_export,key_export_underscore,export_underscore);
  export_format_template        = reg.readStringEntry(section_export,key_export_format_template,export_format_template.text());
  export_character_filter       = reg.readStringEntry(section_export,key_export_character_filter,export_character_filter.text());

#if FOXVERSION < FXVERSION(1,7,0)
  export_encoding 							= FXMIN(GMFilename::ENCODING_LAST-1,reg.readUnsignedEntry(section_export,key_export_encoding,export_encoding));
#else
  export_encoding 							= FXMIN(GMFilename::ENCODING_LAST-1,reg.readUIntEntry(section_export,key_export_encoding,export_encoding));
#endif

  /// Colors
  gui_row_color                 = reg.readColorEntry(section_colors,key_gui_row_color,gui_row_color);
  gui_play_color                = reg.readColorEntry(section_colors,key_gui_play_color,gui_play_color);
  gui_playtext_color            = reg.readColorEntry(section_colors,key_gui_playtext_color,gui_playtext_color);
  gui_tray_color                = reg.readColorEntry(section_colors,key_gui_tray_color,FXApp::instance()->getBaseColor());

  /// Window
  gui_hide_player_when_close    = reg.readBoolEntry(section_window,key_gui_hide_player_when_close,gui_hide_player_when_close);
  gui_show_status_bar           = reg.readBoolEntry(section_window,key_gui_show_status_bar,gui_show_status_bar);
  gui_toolbar_bigicons          = reg.readBoolEntry(section_window,key_gui_toolbar_bigicons,gui_toolbar_bigicons);
  gui_toolbar_docktop           = reg.readBoolEntry(section_window,key_gui_toolbar_docktop,gui_toolbar_docktop);
  gui_toolbar_showlabels        = reg.readBoolEntry(section_window,key_gui_toolbar_showlabels,gui_toolbar_showlabels);
  gui_show_browser_icons        = reg.readBoolEntry(section_window,key_gui_show_browser_icons,gui_show_browser_icons);
  keywords                      = reg.readStringEntry(section_window,key_gui_keywords,keywords.text());
  gui_show_playing_albumcover   = reg.readBoolEntry(section_window,key_gui_show_playing_albumcover,gui_show_playing_albumcover);
  gui_show_albumcovers          = reg.readBoolEntry(section_window,key_gui_show_albumcovers,gui_show_albumcovers);
  gui_tray_icon                 = reg.readBoolEntry(section_window,key_gui_tray_icon,gui_tray_icon);
  gui_show_playing_titlebar     = reg.readBoolEntry(section_window,key_gui_show_playing_titlebar,gui_show_playing_titlebar);
  gui_show_opengl_coverview     = reg.readBoolEntry(section_window,key_gui_show_opengl_coverview,gui_show_opengl_coverview);
  gui_coverdisplay_size         = reg.readIntEntry(section_window,key_gui_coverdisplay_size,gui_coverdisplay_size);
  gui_format_title              = reg.readStringEntry(section_window,key_gui_format_title,gui_format_title.text());


  /// Player
  play_repeat                   = reg.readIntEntry(section_player,key_play_repeat,play_repeat);
  play_replaygain               = reg.readIntEntry(section_player,key_play_replaygain,play_replaygain);
  play_close_stream             = reg.readBoolEntry(section_player,key_play_close_stream,play_close_stream);
  play_pause_close_device       = reg.readBoolEntry(section_player,key_play_pause_close_device,play_pause_close_device);
  play_gapless                  = reg.readBoolEntry(section_player,key_play_gapless,play_gapless);
  play_shuffle                  = reg.readBoolEntry(section_player,key_play_shuffle,play_shuffle);
  play_open_device_on_startup   = reg.readBoolEntry(section_player,key_play_open_device_on_startup,play_open_device_on_startup);

  /// Dbus
  dbus_notify_daemon            = reg.readBoolEntry(section_dbus,key_dbus_notify_daemon,dbus_notify_daemon);
  setKeyWords(keywords);
  }



void GMPreferences::resetColors(){
  gui_row_color=FXRGB(240,240,240);
  gui_play_color=FXRGB(210,230,210);
  gui_playtext_color=FXRGB(0,0,0);
  gui_tray_color=FXRGB(0,0,0);
  }

void GMPreferences::setKeyWords(const FXString & keywords) {
  gui_sort_keywords.clear();
  FXint numkeywords=keywords.contains(';')+1;
  FXString key;
  for (FXint i=0;i<numkeywords;i++){
    key=keywords.section(';',i);
    if (!key.empty()) gui_sort_keywords.append(key+" ");
    }
  }

void GMPreferences::getKeyWords(FXString & keywords) const {
  if (gui_sort_keywords.no()){
    keywords+=FXString(gui_sort_keywords[0]).trim();
    for (FXint i=1;i<gui_sort_keywords.no();i++) {
      keywords+=";" + FXString(gui_sort_keywords[i]).trim();
      }
    }
  }


void GMPreferences::parseCommandLine(int argc,char **argv){
  for (FXint i=0;i<argc;i++){
    if (comparecase(argv[i],"--disable-opengl")==0) {
      gui_show_opengl_coverview=false;
      }
    }
  }




