/* gobby - A GTKmm driven libobby client
 * Copyright (C) 2005 0x539 dev group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _GOBBY_COMMON_HPP_
#define _GOBBY_COMMON_HPP_

#include "net6/gettext_package.hpp"

#ifndef N_
# define N_(id) (id)
#endif

namespace Gobby
{

/** Initalises gettext for usage with Gobby. Translations a looked up in the
 * given catalog.
 */
void init_gettext(net6::gettext_package& package);

/** Translates a message from the gobby catalog.
 */
const char* _(const char* msgid);

/** Translate pluralised message from the gobby catalog.
 */
const char* ngettext(const char* msgid,
                     const char* msgid_plural,
                     unsigned long int n);

}

#endif // _GOBBY_COMMON_HPP_

