/*
     This file is part of gnunet-qt.
     (C) 2006 Nils Durner (and other contributing authors)

     gnunet-qt is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     gnunet-qt is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/common/assert.cc
 * @brief Assertion function for gnunet-qt
 * @author Nils Durner
 */

#include <QApplication>
#include <QMessageBox>
#include <QString>

void gnunet_qt_assert_quit(char *file, int line)
{
  QString strError = QObject::tr("An internal error has occured and gnunet-qt "
    "will shut down to prevent further damage.\n\nPlease report this problem to "
    "the GNUnet developers (see gnunet.org).\n\nDetailed error information: "
    "assertion failed at %1:%2.")
    .arg(QString(file))
    .arg(QString::number(line));
  
  QMessageBox::critical(NULL, QObject::tr("Fatal error"), strError);
  qApp->exit(1);
  exit(1);
}

/* end of assert.cc */
