/*
     This file is part of GNUnet.
     (C) 2005, 2006 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/search.h
 * @brief code for searching with gnunet-gtk
 * @author Christian Grothoff
 */

#ifndef GTK_SEARCH_H
#define GTK_SEARCH_H

#include <GNUnet/gnunet_ecrs_lib.h>
#include <GNUnet/gnunet_fsui_lib.h>
#include "fs.h"


/**
 * Add the given search result to the search
 * tree at the specified position.
 */
void addEntryToSearchTree (SearchList * searchContext,
                           DownloadList * downloadParent,
                           const ECRS_FileInfo * info, GtkTreeIter * iter);

/**
 * Add the given result to the model (search result
 * list).
 * @param info the information to add to the model
 * @param uri the search URI
 * @param path the tree path that selects where to add
 *        the information, NULL for top-level
 */
void fs_search_result_received (SearchList * searchContext,
                                const ECRS_FileInfo * info,
                                const struct ECRS_URI *uri);

/**
 * A search has been started.  Open tab.
 *
 * @return internal search context
 */
SearchList *fs_search_started (struct FSUI_SearchList *list,
                               const struct ECRS_URI *uri,
                               unsigned int anonymityLevel,
                               unsigned int resultCount,
                               const ECRS_FileInfo * results,
                               FSUI_State state);

/**
 * A search process has been aborted.  Update display.
 */
void fs_search_aborted (SearchList * searchContext);

/**
 * A search process has stopped.  Clean up.
 */
void fs_search_stopped (SearchList * searchContext);

#endif
