// -*- c++ -*-

//  Gnomoradio - gnomoradio/criteria-creator.h
//  Copyright (C) 2004  Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __CRITERIA_CREATOR_H
#define __CRITERIA_CREATOR_H

#include <gtkmm.h>
#include "criteria-input.h"
#include "wraporadio/wraporadio.h"

namespace Gnomoradio
{
	/* This class generates criterion for a searchlist *
	 * using a bunch of CriteriaInputs                 */
	class CriteriaCreator : public Gtk::VBox
	{
	public:
		CriteriaCreator ();

		virtual ~CriteriaCreator ();

		sigc::signal<void> signal_no_more_inputs;
		sigc::signal<void> signal_changed;

		Glib::ustring get_criterion ();
		void set_criterion (Glib::ustring criterion);
		
		void add_new_input (xmlpp::Element *element = 0);
		void remove_input (CriteriaInput *input);
		int get_number_of_inputs () { return inputs.size(); }

		void on_add_input_clicked () { add_new_input(); 
		                               signal_changed.emit(); }		

	protected:
		Gtk::ScrolledWindow s_window;
		
		Gtk::Button add_button;

		std::list<CriteriaInput *> inputs;

		Gtk::OptionMenu boolean_type;
		Gtk::Menu boolean_type_menu;
		Gtk::MenuItem boolean_and, boolean_or;
		
		Gtk::VBox vbox;

		void emit_changed_signal () { signal_changed.emit(); }
	};
}

#endif
