/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4 ts=4:
 *
 * Gnome Apt main application class
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2003-2005 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef GNOME_APT_APP_H
#define GNOME_APT_APP_H

#include <gtk/gtkstatusbar.h>

class ConfFile;
class DrawTree;
class GAptPkgList;

class GAptApp {
public:
	GAptApp (const gchar*, ConfFile*);
	~GAptApp (void);

	gchar* get_geometry (void) const;

	void set_status (const gchar* s) {
		if (_statusbar) {
			gtk_statusbar_pop (GTK_STATUSBAR (_statusbar), context_id);
			gtk_statusbar_push (GTK_STATUSBAR (_statusbar), context_id, s);
		}
  }

  GAptPkgList* pkglist() { return pkglist_; }

  GtkWidget* widget() { return app_; }

private:
  GtkWidget* app_;
	GtkWidget* _statusbar;
	guint context_id;

	DrawTree* app_treeview;
	GAptPkgList* pkglist_;

  static gint keypress_cb(GtkWidget* w, GdkEventKey* event, gpointer data);
  gint key(GdkEventKey* event);
};

#endif
