// Box class
class Box {
public:
    unsigned long _id;		// Identifier
    float _size;		// Size
    float _extend;		// Extensibility
    const char *_type;		// type


    Box& operator = (const Box&) { assert(0); return *this; }

protected:
    int _links;			// #references (>= 1)

    BoxSize& thesize()     { return _size; }
    BoxExtend& theextend() { return _extend; }
    const BoxSize& thesize() const     { return _size; }
    const BoxExtend& theextend() const { return _extend; }

    // Copy constructor
    Box(const Box& box):
	_id(), _size(box._size), _extend(box._extend), 
	_type(box._type), _links(1)
    {}
	
    // Equality
    virtual bool matches(const Box& b, const Box *callbackArg = 0) const;

    // Draw box
    virtual void _draw(Widget w, 
		       const BoxRegion& region, 
		       const BoxRegion& exposed, 
		       GC gc, bool context_selected) const = 0;

public:
    // Save box to stream
    virtual void dump(ostream& s) const = 0;

    // Constructor
    Box(BoxSize s = BoxSize(0, 0), BoxExtend e = BoxExtend(0, 0), 
	const char *t = "Box"):
	_id(), _size(s), _extend(e), _type(t), _links(1)
    {}

    // Destructor
    virtual ~Box()
    {
	assert (_links == 0);
	_type = 0;
    }

    // Create new reference
    virtual Box* link()
    {
	assert(_links > 0);
	_links++;
	return this;
    }

    // Copy box
    virtual Box *dup() const = 0;

    // Same, but only one level deep (if possible)
    virtual Box *dup0() const { return dup(); }

    // Kill reference
    void unlink()
    {
	assert(_links > 0);
	if (--_links == 0)
	    delete this;
    }

    // Resources
    unsigned long id() const                   { return (unsigned long)_id; }
    const char *type() const                   { return _type; }
    float extend() const                   { return _extend; }
    float size() const                       { return _size; }

    float extend(BoxDimension dimension) const
    { 
	return _extend[dimension]; 
    }
    float size(BoxDimension dimension) const 
    { 
	return _size[dimension]; 
    }

    // Build string from string components
    virtual string str() const { return ""; }

    // Return free space in lower right corner
    virtual BoxSize corner() const
    {
	// Default: space of zero width on the right of box
	return BoxSize(0, _size[Y]);
    }

    // Re-calculate box size
    virtual Box* resize() { return this; }

    // Propagate new font
    virtual void newFont(const string&) { resize(); }

    // Draw
};

