#!/bin/bash

. `dirname $0`/../../scripts/CONFIG.sh

print_header "GVD"
parse_opts "$@"

if [ "$clean" = 1 ]; then
   # ??? What should we clean here ?
   echo ""
   exit 0
fi

run_and_exit "make -s -f Makefile.gvd_tests ADAFLAGS=-q"

out=out.$$

$rlimit ./compare test_parse >$out 2>&1
if [ "$?" != 0 ]; then
   echo_with_status 0 "test_parse fails"
   cat $out
fi
   
$rlimit ./compare test_parse_c >$out 2>&1
if [ "$?" != 0 ]; then
   echo_with_status 0 "test_parse_c fails"
   cat $out
fi

if [ "$CPP_TESTING" != "false" ]; then
   $rlimit ./compare test_parse_cpp >$out 2>&1
   if [ "$?" != 0 ]; then
      echo_with_status 0 "test_parse_cpp fails"
      cat $out
   fi
fi

rm $out

echo_with_status 1 ""
