with Ada.Finalization;

package T1 is

   type Variant is private;
   type Variant_Kind is (VK_Null, VK_Num, VK_String, VK_Vector, VK_Text);

private

   type Variant_Internal (Kind : Variant_Kind := VK_Null) is record
      case Kind is
         when VK_Null =>
            null;
         when VK_Num =>
            Num_Value : Long_Float;
         when VK_String =>
            String_Value : Natural;
         when VK_Vector =>
            Current_Vector_Size : Natural;
            Vector_Value        : Natural;
         when VK_Text =>
            Current_Text_Size : Natural;
            Text_Value        : Natural;
      end case;
   end record;

   type Variant is new Ada.Finalization.Controlled with record
      V : Variant_Internal;
   end record;
   -- Note that Variant cannot have discriminant with default value, this
   -- is why we have a Variant_Internal type.

end T1;
