-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_worksheet.adb,v $
--  Description     : Basic Work sheet for the notebook
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2003/11/16 12:11:18 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;    use Ada.Strings.Unbounded;

with Ada.Text_Io;              use Ada.Text_IO;
with Ada.Exceptions;           use Ada.Exceptions;
with Ada.Strings;              use Ada.Strings;
with Ada.Strings.Fixed;        use Ada.Strings.Fixed;
with Unchecked_Deallocation;

with Glib;                     use Glib;
-- Gdk
with Gdk;
with Gdk.Drawable;             use Gdk.Drawable;
with Gdk.Bitmap;               use Gdk.Bitmap;
with Gdk.Event;                use Gdk.Event;
with Gdk.Font;                 use Gdk.Font;
with Gdk.Color;                use Gdk.Color;
with Gdk.GC;                   use Gdk.GC;
with Gdk.Pixmap;               use Gdk.Pixmap;
with Gdk.Rectangle;            use Gdk.Rectangle;
with Gdk.Types;                use Gdk.Types;
with Gdk.Window;               use Gdk.Window;
-- Gtk
with Gtk.Rc;
with Gtk;                      use Gtk;
with Gtk.Arguments;            use Gtk.Arguments;
with Gtk.Box;                  use Gtk.Box;
with Gtk.Button;               use Gtk.Button;
with Gtk.Editable;             use Gtk.Editable;
with Gtk.Event_Box;            use Gtk.Event_Box;
with Gtk.Enums;                use Gtk.Enums;
with Gtk.Frame;                use Gtk.Frame;
with Gtk.Handlers;             use Gtk.Handlers;
with Gtk.Label;                use Gtk.Label;
with Gtk.Notebook;             use Gtk.Notebook;

with Gtkada.Handlers;          use Gtkada.Handlers;
with Gtk.Scrolled_Window;      use Gtk.Scrolled_Window;
with Gtk.Style;                use Gtk.Style;
with Gtk.Text;                 use Gtk.Text;
with Gtk.Window;               use Gtk.Window;
with Gtk.Widget;               use Gtk.Widget;
with Gtk.GEntry;               use Gtk.GEntry;

with GUI_Preferences;          use GUI_Preferences;
with GUI_Logging;              use GUI_Logging;
with GUI_Common;               use GUI_Common;

with Project_File;             use Project_File;
with Files;                    use Files;
with Contents_Handler;         use Contents_Handler;

package body GUI_Worksheet is

   Version : constant String := "$Id: gui_worksheet.adb,v 1.9 2003/11/16 12:11:18 merdmann Exp $";

   --- ************************************************************************** ---
   --  ***                       C L A S S    D A T A                         *** ---
   --- ************************************************************************** ---

   ----------------------------
   -- List of active buffers --
   ----------------------------
   type Sheet_List_Record is record
         Name     : Unbounded_String := Null_Unbounded_String;
         Sheet    : Handle;
      end record;

   Sheet_List    : array( 1..512 ) of Sheet_List_Record;

   -----------------
   -- class table --
   -----------------
   type Class_Table_Record is record
         Name      : Unbounded_String := Null_Unbounded_String;
         Allocator : Allocator_Access := null;
      end record;

   CT : array( 1..20 ) of Class_Table_Record;

   --- ************************************************************************** ---
   --- ***                 I N S T A N C E     D A T A                        *** ---
   --- ************************************************************************** ---

   package Sheet_Cb is new Handlers.Callback (Sheet_Box_Record);

   ----------------------
   -- Support Packages --
   ----------------------
   package Destroyed is new Gtk.Handlers.Callback (
      Widget_Type => Gtk_Window_Record);

   -------------------------
   -- Table_Button_Record --
   -------------------------
   type Table_Button_Record is new Gtk_Button_Record with record
         Receiver : Handle  := null;
         Cmd      : Natural := 0;
      end record;

   type Table_Button is access all Table_Button_Record'Class;

   package Button_Cb is new Handlers.Callback (Table_Button_Record);

   --------------
   -- Register --
   --------------
   procedure Register(
      Name  : in String;
      Alloc : in Allocator_Access ) is
   begin
      for I in CT'Range loop
         if CT(I).Name /= Null_Unbounded_String then
            CT(I).Name := To_Unbounded_String( Name );
            Ct(I).Allocator := Alloc;
            exit;
         end if;
      end loop;
   end Register;

   ------------
   -- Create --
   ------------
   function Create(
      Name   : in String ) return Handle is
      Result : Handle := null;
   begin
      for I in CT'Range loop
         if CT(I).Name /= Null_Unbounded_String and then
            To_String(CT(I).Name) = Name
         then
            Result :=  CT(I).Allocator.all;
            Result.Self := Result;
            exit;
         end if;
      end loop;

      return Result;
   end Create;

   --- ************************************************************************** ---
   --- ***                 I N S T A N C E     D A T A                        *** ---
   --- ************************************************************************** ---

   --------------------
   -- Button pressed --
   --------------------
   procedure CB_Button_Pressed(
      Pressed : access Table_Button_Record'Class ) is
   begin
      Command(Pressed.Receiver.all, Pressed.Cmd );
   end CB_Button_Pressed;

   ----------------
   -- Add_Button --
   ----------------
   procedure Add_Button(
      Receiver : in Object'Class;
      Title    : in String;
      Cmd      : in Natural;
      Box      : in out Gtk_Box ) is
      Result   : Table_Button := new Table_Button_Record;
   begin
      Gtk.Button.Initialize( Result, Title );
      Result.Receiver := Receiver.Self;
      Result.Cmd      := Cmd;

      Pack_Start (Box, Result, Expand => False );

      Button_CB.Object_Connect(
         result,
         "clicked",
         Button_CB.To_Marshaller (CB_Button_Pressed'Access ),
         Slot_Object => Result
      );

   end Add_Button;

   -------------------
   -- Locate_Buffer --
   -------------------
   function Locate_Buffer(
      Name : in Unbounded_String ) return Handle is
   begin
      for I in Sheet_List'Range loop
         if Sheet_List(I).Name /= Null_Unbounded_String and then
            Sheet_List(I).Name = Name
         then
            return Sheet_List(I).Sheet;
         end if;
      end loop;

      return null;
   end Locate_Buffer;

   --- ************************************************************************** ---
   --- ***               H A N D L E  B U F F E R S                           *** ---
   --- ************************************************************************** ---

   -------------
   -- Is_Open --
   -------------
   function Is_Open(
      Sheet_Name : in Unbounded_String ) return Boolean is
      -- return true if the buffer is already open
   begin
      for I in Sheet_List'Range loop
         if Sheet_List(I).Name /= Null_Unbounded_String and then
            Sheet_List(I).Name = Sheet_Name
         then
            return True;
         end if;
      end loop;

      return False;
   end Is_Open;

   --- ************************************************************************** ---
   --  ***         H A N D L E     E D I T O R     B U F F E R S              *** ---
   --- ************************************************************************** ---

   ---------------------
   -- Register_Buffer --
   ---------------------
   procedure Register_Buffer(
      Name   : in Unbounded_String;
      Sheet  : in Handle ) is
   begin
      for I in Sheet_List'Range loop
         if Sheet_List(I).Name = Null_Unbounded_String then
            Sheet_List(I).Name    := Name;
            Sheet_List(I).Sheet   := Sheet;
            return;
         end if;
      end loop;
   end Register_Buffer;

   --------------------
   -- Bring_In_Front --
   --------------------
   procedure Bring_In_Front(
      Sheet_Name : in Unbounded_String ) is
      This       : Handle := Locate_Buffer( Sheet_Name );
      Pg         : Gint;
   begin
      if This /= null then
         Pg := Page_Num( Toplevel, This.SheetBox );
         Set_Page( Toplevel, Pg );
      else
         Error( "not found: " & To_String(Sheet_Name) );
      end if;
   end Bring_In_Front;

   --- ************************************************************************** ---
   --- ***                E D I T O R   F U N C T I O N S                     *** ---
   --- ************************************************************************** ---

   ----------------
   -- Initialize --
   ----------------
   procedure Initialize(
      This : in out Object'Class ) is
   begin
      This.Self := This'Unchecked_Access;
   end Initialize;

   --------------
   -- Finalize --
   --------------
   procedure Finalize(
      This : in out Object'Class ) is
   begin
      This.Self := null;
   end Finalize;

   ----------
   -- Self --
   ----------
   function Self(
      This : in Object'Class ) return Handle is
   begin
      return This.Self;
   end Self;

   --------------
   -- Contents --
   --------------
   function Contents(
      This : in Object'Class ) return Contents_Handler.Handle is
   begin
      return This.Handler;
   end Contents;

   --------------
   -- Contents --
   --------------
   function Contents return Contents_Handler.Handle is
      W : Gtk_Widget;
   begin
      W := Get_Child( Get_Cur_Page( Toplevel ) );
      if W /= null then
         return Sheet_Box( W ).Handler ;
      else
         return null;
      end if;
   end Contents;

   -----------------
   -- CB_Activate --
   -----------------
   procedure CB_Activate(
      Box : access Sheet_Box_Record'Class ) is
   begin
      Put_Line("switch");
   end CB_Activate;

   ----------------
   -- Add_Sheet --
   ----------------
   procedure Add_Sheet(
      This        : in out Object'Class;
      Handler     : in Contents_Handler.Handle;
      Sheet_Name  : in Unbounded_String;
      Permanent   : in Boolean := False ) is
      --- Add an sql editor to the workspace notebook
      Abox        : Gtk_Box renames This.Abox;
      Cbox        : Gtk_Box renames This.Cbox;
      Vbox        : Gtk_Box renames This.Vbox;

      Label_Box   : Gtk_Box;
      Label       : Gtk_Label;
      Menu_Box    : Gtk_Box;
      Fr1, Fr2    : Gtk_Frame;
      SheetBox    : Sheet_Box renames This.SheetBox;
      ---
   begin
      if Is_Open( Sheet_Name ) then
         return;
      end if;
      SheetBox := new Sheet_Box_Record;
      Gtk.Event_Box.Initialize( Sheetbox );
      SheetBox.Handler := Handler;
      SheetBox.Sheet   := This.Self;

      Register_Buffer( Sheet_Name, This.Self );

      This.Buffer_Name := Sheet_Name;
      This.Handler     := Handler;
      This.Permanent   := Permanent;

      --------------------------------
      -- The box which contains all --
      --------------------------------
      Gtk_New_Vbox (Vbox);
      Set_Border_Width (Vbox, 2);
      Show_All (This.Vbox);

      -------------------------------
      -- Where to place the editor --
      -------------------------------
      Gtk_New( Fr1 );
      Gtk_New_Hbox(Abox, False, 5 );
      Set_Border_Width (Abox, 5);
      Add( Fr1, Abox );
      Show_All( Abox );
      ----------------------------
      -- Where to place buttons --
      ----------------------------
      Gtk_New( Fr2 );
      Gtk_New_Hbox (Cbox, False, 5);
      Set_Border_Width (cbox, 5);
      Add( Fr2, Cbox );
      Show_All( Cbox );

      Display( This, Abox );

      Pack_Start (Vbox, fr1, Expand => True );
      Pack_End (Vbox, fr2, Expand => False );

      Add( SheetBox, Vbox );
      Show_All( SheetBox  );

      ------------------------------
      -- add the notebook labels  --
      ------------------------------
      Gtk_New_Hbox (Label_Box, False, 0);
      Gtk_New (This.Label, Display_Name(Sheet_Name ) );
      Pack_Start (Label_Box, This.Label, False, True, 0);
      Show_All (Label_Box);

      Gtk_New_Vbox (Menu_Box, False, 0);
      Gtk_New (Label, Display_Name( Sheet_Name ) );
      Pack_Start (Menu_Box, This.Label, False, True, 0);
      Show_All (Menu_Box);

--      Sheet_CB.Object_Connect(
--         SheetBox,
--         "draw_focus",
--         Sheet_CB.To_Marshaller (CB_Activate'Access ),
--         Slot_Object => SheetBox
--      );

      Append_Page_Menu (Toplevel, SheetBox, Label_Box, Menu_Box);

      -- bring sheet into front.
      Set_Page( Toplevel, Page_Num( Toplevel, This.SheetBox ));

   end Add_Sheet;

   -------------------
   -- Remove_Sheet --
   -------------------
   procedure Remove_Sheet (
      Sheet_Name : in Unbounded_String ) is
      ---
      Table      : Handle := Locate_Buffer( Sheet_Name );
   begin
      if Table.Permanent then
         return;
      end if;

      for I in Sheet_List'Range loop
         if Sheet_List(I).Name  /= Null_Unbounded_String and then
            Sheet_List(I).Name = Sheet_Name then
            Sheet_List(I).Name := Null_Unbounded_String;
         end if;
      end loop;

      -- Destroy( Table.Vbox );
      Remove_Page( Toplevel, Page_Num( Toplevel, Table.SheetBox ));
   end Remove_Sheet;

   -------------------
   -- Remove_Sheet --
   -------------------
   procedure Remove_Sheet (
      This  : in out Object'Class ) is
   begin
      if This.Permanent then
         return;
      end if;

      for I in Sheet_List'Range loop
         if Sheet_List(I).Name /= Null_Unbounded_String and then
            Sheet_List(I).Sheet = This.Self
         then
            Sheet_List(I).Name  := Null_Unbounded_String;
            Sheet_List(I).Sheet := null;
            exit;
         end if;
      end loop;

      Remove_Page( Toplevel, Page_Num( Toplevel, This.SheetBox ));
   end Remove_Sheet;

   -----------------
   -- Add_Command --
   -----------------
   procedure Add_Command(
      This : in out Object'Class;
      Text : in String;
      Cmd  : in Natural ) is
   begin
      Add_Button( This, Text,Cmd, This.Cbox);
   end Add_Command;

   --- ************************************************************************** ---
   --- ***                PROCEDURES TO BE EXTENDED                           *** ---
   --- ************************************************************************** ---

   -------------
   -- Command --
   -------------
   procedure Command(
      This : in out Object;
      Cmd  : in Natural ) is
   begin
      GUI_Logging.Log("Pressed cmd: " & Natural'Image( Cmd ) );
   end Command;

   -------------
   -- Display --
   -------------
   procedure Display(
      This : in out Object;
      Box  : in out Gtk_Box ) is
   begin
      GUI_Logging.Error( "GUI_Worksheet: Display not implemented");
   end Display;

end GUI_Worksheet;

