/* gmpc-nowplaying2.c generated by valac, the Vala compiler
 * generated from gmpc-nowplaying2.vala, do not modify */

/* Gnome Music Player Client Multimedia Keys plugin (gmpc-mmkeys)
 * Copyright (C) 2010 Qball Cow <qball@sarine.nl>
 * Project homepage: http://gmpc.wikia.com/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include "gmpc-extras.h"
#include <gdk/gdk.h>
#include <plugin.h>
#include <config1.h>
#include <libmpd/libmpd.h>
#include <glib/gi18n-lib.h>
#include <libmpd/libmpdclient.h>
#include <misc.h>
#include <metadata.h>
#include <gmpc-metaimage.h>
#include <pango/pango.h>
#include <stdio.h>
#include <gmpc-meta-text-view.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <main.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_tree_row_reference_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_row_reference_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;
typedef struct _Block23Data Block23Data;
typedef struct _Block24Data Block24Data;
typedef struct _Block25Data Block25Data;
#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _mpd_data_free0(var) ((var == NULL) ? NULL : (var = (mpd_data_free (var), NULL)))
typedef struct _Block26Data Block26Data;
typedef struct _Block19Data Block19Data;
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))

struct _GmpcPluginMockupPrivate {
	gboolean theme_colors;
	char* title_color;
	char* item_color;
	GdkColor background;
	GdkColor foreground;
	GtkLabel* bitrate_label;
	GtkTreeRowReference* np_ref;
	GtkScrolledWindow* paned;
	GtkEventBox* container;
	gboolean selected;
	char* song_checksum;
};

struct _Block20Data {
	int _ref_count_;
	Block19Data * _data19_;
	gint j;
};

struct _Block21Data {
	int _ref_count_;
	Block19Data * _data19_;
	GmpcMetaTextView* text_view;
	gboolean text_view_queried;
	gint j;
};

struct _Block22Data {
	int _ref_count_;
	Block19Data * _data19_;
	gboolean similar_songs_queried;
	GtkAlignment* similar_songs_box;
	gint j;
};

struct _Block23Data {
	int _ref_count_;
	Block19Data * _data19_;
	gint j;
};

struct _Block24Data {
	int _ref_count_;
	Block19Data * _data19_;
	gint j;
};

struct _Block25Data {
	int _ref_count_;
	Block19Data * _data19_;
	GmpcMetaTextView* text_view;
	gboolean text_view_queried;
	gint j;
};

struct _Block26Data {
	int _ref_count_;
	Block19Data * _data19_;
	mpd_Song* but_song;
};

struct _Block19Data {
	int _ref_count_;
	GmpcPluginMockup * self;
	mpd_Song* song;
	GtkNotebook* notebook;
};


static gpointer gmpc_plugin_mockup_parent_class = NULL;
static GmpcPluginBrowserIfaceIface* gmpc_plugin_mockup_gmpc_plugin_browser_iface_parent_iface = NULL;

#define use_transition_mb2 TRUE
#define some_unique_name_mb2 VERSION
#define GMPC_PLUGIN_MOCKUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_PLUGIN_TYPE_MOCKUP, GmpcPluginMockupPrivate))
enum  {
	GMPC_PLUGIN_MOCKUP_DUMMY_PROPERTY
};
static gint* gmpc_plugin_mockup_real_get_version (GmpcPluginBase* base, int* result_length1);
static const char* gmpc_plugin_mockup_real_get_name (GmpcPluginBase* base);
static void gmpc_plugin_mockup_browser_init (GmpcPluginMockup* self);
static void gmpc_plugin_mockup_real_set_enabled (GmpcPluginBase* base, gboolean state);
static void gmpc_plugin_mockup_real_save_yourself (GmpcPluginBase* base);
static void gmpc_plugin_mockup_update (GmpcPluginMockup* self);
static void gmpc_plugin_mockup_status_changed (GmpcPluginMockup* self, GmpcConnection* conn, MpdObj* server, ChangedStatusType what);
static void gmpc_plugin_mockup_real_browser_add (GmpcPluginBrowserIface* base, GtkWidget* category_tree);
static void gmpc_plugin_mockup_real_browser_selected (GmpcPluginBrowserIface* base, GtkContainer* container);
static void gmpc_plugin_mockup_real_browser_unselected (GmpcPluginBrowserIface* base, GtkContainer* container);
static void gmpc_plugin_mockup_change_color_style (GmpcPluginMockup* self, GtkWidget* bg);
static void gmpc_plugin_mockup_browser_bg_style_changed (GmpcPluginMockup* self, GtkContainer* bg, GtkStyle* style);
static void _gmpc_plugin_mockup_browser_bg_style_changed_gtk_widget_style_set (GtkScrolledWindow* _sender, GtkStyle* previous_style, gpointer self);
static void gmpc_plugin_mockup_clear (GmpcPluginMockup* self);
static char* gmpc_plugin_mockup_get_extension (GmpcPluginMockup* self, const char* path);
static void gmpc_plugin_mockup_update_not_playing (GmpcPluginMockup* self);
static gboolean _lambda27_ (GtkWidget* widget, GdkEventButton* event, GmpcPluginMockup* self);
static gboolean __lambda27__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _lambda28_ (GtkWidget* widget, GdkEventButton* event, GmpcPluginMockup* self);
static gboolean __lambda28__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _lambda29_ (GtkButton* source, Block20Data* _data20_);
static void __lambda29__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (Block20Data* _data20_);
static void _lambda30_ (GtkButton* source, Block21Data* _data21_);
static void __lambda30__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (Block21Data* _data21_);
static void _lambda31_ (GtkButton* source, Block22Data* _data22_);
static void __lambda31__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (Block22Data* _data22_);
static void _lambda32_ (GtkButton* source, Block23Data* _data23_);
static void __lambda32__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (Block23Data* _data23_);
static void _lambda33_ (GtkButton* source, Block24Data* _data24_);
static void __lambda33__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (Block24Data* _data24_);
static void _lambda34_ (GtkButton* source, Block25Data* _data25_);
static void __lambda34__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (Block25Data* _data25_);
static void _lambda35_ (GObject* source, GParamSpec* spec, Block19Data* _data19_);
static void __lambda35__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda36_ (GtkButton* source, Block26Data* _data26_);
static void __lambda36__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (Block26Data* _data26_);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (Block19Data* _data19_);
static void gmpc_plugin_mockup_update_playing (GmpcPluginMockup* self);
static void gmpc_plugin_mockup_select_now_playing_browser (GmpcPluginMockup* self, GtkImageMenuItem* item);
static void _gmpc_plugin_mockup_select_now_playing_browser_gtk_menu_item_activate (GtkImageMenuItem* _sender, gpointer self);
static gint gmpc_plugin_mockup_real_browser_add_go_menu (GmpcPluginBrowserIface* base, GtkMenu* menu);
static void _gmpc_plugin_mockup_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* mi, ChangedStatusType what, gpointer self);
static void _lambda37_ (MpdObj* source, gint connect, GmpcPluginMockup* self);
static void __lambda37__gmpc_connection_connection_changed (GmpcConnection* _sender, MpdObj* mi, gint connect, gpointer self);
static GObject * gmpc_plugin_mockup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gmpc_plugin_mockup_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gint* gmpc_plugin_mockup_real_get_version (GmpcPluginBase* base, int* result_length1) {
	GmpcPluginMockup * self;
	gint* result;
	gint* _tmp0_;
	self = (GmpcPluginMockup*) base;
	result = (_tmp0_ = GMPC_PLUGIN_MOCKUP_version, *result_length1 = G_N_ELEMENTS (GMPC_PLUGIN_MOCKUP_version), _tmp0_);
	return result;
}


static const char* gmpc_plugin_mockup_real_get_name (GmpcPluginBase* base) {
	GmpcPluginMockup * self;
	const char* result;
	self = (GmpcPluginMockup*) base;
	result = "Now Playing";
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gmpc_plugin_mockup_real_set_enabled (GmpcPluginBase* base, gboolean state) {
	GmpcPluginMockup * self;
	self = (GmpcPluginMockup*) base;
	if (state) {
		if (self->priv->paned == NULL) {
			gmpc_plugin_browser_iface_browser_add ((GmpcPluginBrowserIface*) self, (GtkWidget*) playlist3_get_category_tree_view ());
			gmpc_plugin_mockup_browser_init (self);
		}
	} else {
		if (self->priv->np_ref != NULL) {
			GtkTreePath* path;
			path = gtk_tree_row_reference_get_path (self->priv->np_ref);
			if (path != NULL) {
				gint* _tmp0_;
				gint indices_size;
				gint indices_length1;
				gint* indices;
				GtkListStore* model;
				GtkTreeIter iter = {0};
				indices = (_tmp0_ = gtk_tree_path_get_indices (path), indices_length1 = -1, indices_size = indices_length1, _tmp0_);
				cfg_set_single_value_as_int (config, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), "position", indices[0]);
				model = _g_object_ref0 (GTK_LIST_STORE (gtk_tree_row_reference_get_model (self->priv->np_ref)));
				if (gtk_tree_model_get_iter ((GtkTreeModel*) model, &iter, path)) {
					gtk_list_store_remove (model, &iter);
				}
				_g_object_unref0 (model);
			}
			_gtk_tree_path_free0 (path);
		}
		if (self->priv->paned != NULL) {
			GtkScrolledWindow* _tmp1_;
			char* _tmp2_;
			gtk_object_destroy ((GtkObject*) self->priv->paned);
			self->priv->paned = (_tmp1_ = NULL, _g_object_unref0 (self->priv->paned), _tmp1_);
			self->priv->song_checksum = (_tmp2_ = NULL, _g_free0 (self->priv->song_checksum), _tmp2_);
		}
	}
	if (gmpc_plugin_base_get_name ((GmpcPluginBase*) self) != NULL) {
		cfg_set_single_value_as_int (config, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), "enabled", (gint) state);
	}
}


static void gmpc_plugin_mockup_real_save_yourself (GmpcPluginBase* base) {
	GmpcPluginMockup * self;
	self = (GmpcPluginMockup*) base;
	if (self->priv->np_ref != NULL) {
		GtkTreePath* path;
		path = gtk_tree_row_reference_get_path (self->priv->np_ref);
		if (path != NULL) {
			gint* _tmp0_;
			gint indices_size;
			gint indices_length1;
			gint* indices;
			indices = (_tmp0_ = gtk_tree_path_get_indices (path), indices_length1 = -1, indices_size = indices_length1, _tmp0_);
			cfg_set_single_value_as_int (config, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), "position", indices[0]);
		}
		_gtk_tree_path_free0 (path);
	}
}


static void gmpc_plugin_mockup_status_changed (GmpcPluginMockup* self, GmpcConnection* conn, MpdObj* server, ChangedStatusType what) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (server != NULL);
	if (!gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self)) {
		return;
	}
	if (!self->priv->selected) {
		return;
	}
	if ((what & MPD_CST_STATE) == MPD_CST_STATE) {
		gmpc_plugin_mockup_update (self);
	} else {
		if ((what & (MPD_CST_SONGID | MPD_CST_PLAYLIST)) > 0) {
			gmpc_plugin_mockup_update (self);
		}
	}
	if ((what & (MPD_CST_BITRATE | MPD_CST_AUDIOFORMAT)) > 0) {
		if (self->priv->bitrate_label != NULL) {
			gint channels;
			gint bitrate;
			char* _tmp0_;
			channels = mpd_status_get_channels (connection);
			g_debug ("gmpc-nowplaying2.vala:138: bitrate changed");
			bitrate = mpd_status_get_bitrate (connection);
			gtk_label_set_markup (self->priv->bitrate_label, _tmp0_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %i %s, %.1f %s, %i %s", self->priv->item_color, _ ("Format"), channels, ngettext (N_ ("Channel"), N_ ("Channels"), (gulong) channels), mpd_status_get_samplerate (connection) / 1000.0, _ ("kHz"), bitrate, _ ("kbps")));
			_g_free0 (_tmp0_);
		}
	}
}


static void gmpc_plugin_mockup_real_browser_add (GmpcPluginBrowserIface* base, GtkWidget* category_tree) {
	GmpcPluginMockup * self;
	GtkTreeView* tree;
	GtkListStore* store;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeRowReference* _tmp1_;
	GtkTreePath* _tmp0_;
	self = (GmpcPluginMockup*) base;
	g_return_if_fail (category_tree != NULL);
	tree = _g_object_ref0 (GTK_TREE_VIEW (category_tree));
	store = _g_object_ref0 (GTK_LIST_STORE (gtk_tree_view_get_model (tree)));
	model = _g_object_ref0 (gtk_tree_view_get_model (tree));
	playlist3_insert_browser (&iter, cfg_get_single_value_as_int_with_default (config, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), "position", 0));
	gtk_list_store_set (store, &iter, 0, ((GmpcPluginBase*) self)->id, 1, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), 3, "media-audiofile", -1);
	self->priv->np_ref = (_tmp1_ = gtk_tree_row_reference_new (model, _tmp0_ = gtk_tree_model_get_path (model, &iter)), _gtk_tree_row_reference_free0 (self->priv->np_ref), _tmp1_);
	_gtk_tree_path_free0 (_tmp0_);
	_g_object_unref0 (tree);
	_g_object_unref0 (store);
	_g_object_unref0 (model);
}


static void gmpc_plugin_mockup_real_browser_selected (GmpcPluginBrowserIface* base, GtkContainer* container) {
	GmpcPluginMockup * self;
	self = (GmpcPluginMockup*) base;
	g_return_if_fail (container != NULL);
	self->priv->selected = TRUE;
	gmpc_plugin_mockup_browser_init (self);
	gtk_container_add (container, (GtkWidget*) self->priv->paned);
	gtk_widget_show_all ((GtkWidget*) container);
	gtk_widget_ensure_style ((GtkWidget*) container);
	if (self->priv->theme_colors) {
		char* _tmp1_;
		GdkColor _tmp0_;
		char* _tmp3_;
		GdkColor _tmp2_;
		self->priv->title_color = (_tmp1_ = gdk_color_to_string ((_tmp0_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned)->text[GTK_STATE_PRELIGHT], &_tmp0_)), _g_free0 (self->priv->title_color), _tmp1_);
		self->priv->item_color = (_tmp3_ = gdk_color_to_string ((_tmp2_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned)->text[GTK_STATE_PRELIGHT], &_tmp2_)), _g_free0 (self->priv->item_color), _tmp3_);
	}
	gmpc_plugin_mockup_update (self);
}


static void gmpc_plugin_mockup_real_browser_unselected (GmpcPluginBrowserIface* base, GtkContainer* container) {
	GmpcPluginMockup * self;
	self = (GmpcPluginMockup*) base;
	g_return_if_fail (container != NULL);
	self->priv->selected = FALSE;
	gtk_container_remove (container, (GtkWidget*) self->priv->paned);
}


static void gmpc_plugin_mockup_browser_bg_style_changed (GmpcPluginMockup* self, GtkContainer* bg, GtkStyle* style) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (bg != NULL);
	g_debug ("gmpc-nowplaying2.vala:200: Change style signal");
	if (self->priv->theme_colors) {
		char* _tmp1_;
		GdkColor _tmp0_;
		char* _tmp3_;
		GdkColor _tmp2_;
		self->priv->title_color = (_tmp1_ = gdk_color_to_string ((_tmp0_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned)->text[GTK_STATE_PRELIGHT], &_tmp0_)), _g_free0 (self->priv->title_color), _tmp1_);
		self->priv->item_color = (_tmp3_ = gdk_color_to_string ((_tmp2_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned)->text[GTK_STATE_PRELIGHT], &_tmp2_)), _g_free0 (self->priv->item_color), _tmp3_);
	}
	gmpc_plugin_mockup_change_color_style (self, (GtkWidget*) self->priv->container);
}


static void gmpc_plugin_mockup_change_color_style (GmpcPluginMockup* self, GtkWidget* bg) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bg != NULL);
	g_debug ("gmpc-nowplaying2.vala:212: change style");
	if (GTK_IS_SEPARATOR (bg)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = GTK_IS_NOTEBOOK (bg);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = GTK_IS_CHECK_BUTTON (bg);
	}
	if (_tmp0_) {
	} else {
		if (self->priv->theme_colors) {
			GdkColor _tmp2_;
			gtk_widget_modify_bg (bg, GTK_STATE_NORMAL, (_tmp2_ = gtk_widget_get_style ((GtkWidget*) self->priv->paned)->base[GTK_STATE_NORMAL], &_tmp2_));
		} else {
			gtk_widget_modify_bg (bg, GTK_STATE_NORMAL, &self->priv->background);
			gtk_widget_modify_base (bg, GTK_STATE_NORMAL, &self->priv->background);
			gtk_widget_modify_text (bg, GTK_STATE_NORMAL, &self->priv->foreground);
			gtk_widget_modify_fg (bg, GTK_STATE_NORMAL, &self->priv->foreground);
			gtk_widget_modify_text (bg, GTK_STATE_ACTIVE, &self->priv->foreground);
			gtk_widget_modify_fg (bg, GTK_STATE_ACTIVE, &self->priv->foreground);
		}
	}
	if (GTK_IS_CONTAINER (bg)) {
		{
			GList* child_collection;
			GList* child_it;
			child_collection = gtk_container_get_children (GTK_CONTAINER (bg));
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* child;
				child = _g_object_ref0 ((GtkWidget*) child_it->data);
				{
					gmpc_plugin_mockup_change_color_style (self, child);
					_g_object_unref0 (child);
				}
			}
			_g_list_free0 (child_collection);
		}
	}
}


static void _gmpc_plugin_mockup_browser_bg_style_changed_gtk_widget_style_set (GtkScrolledWindow* _sender, GtkStyle* previous_style, gpointer self) {
	gmpc_plugin_mockup_browser_bg_style_changed (self, _sender, previous_style);
}


static void gmpc_plugin_mockup_browser_init (GmpcPluginMockup* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->paned == NULL) {
		GtkScrolledWindow* _tmp0_;
		GtkEventBox* _tmp1_;
		self->priv->paned = (_tmp0_ = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL)), _g_object_unref0 (self->priv->paned), _tmp0_);
		gtk_scrolled_window_set_policy (self->priv->paned, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_scrolled_window_set_shadow_type (self->priv->paned, GTK_SHADOW_NONE);
		self->priv->container = (_tmp1_ = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ()), _g_object_unref0 (self->priv->container), _tmp1_);
		gtk_event_box_set_visible_window (self->priv->container, TRUE);
		g_signal_connect_object ((GtkWidget*) self->priv->paned, "style-set", (GCallback) _gmpc_plugin_mockup_browser_bg_style_changed_gtk_widget_style_set, self, 0);
		gtk_scrolled_window_add_with_viewport (self->priv->paned, (GtkWidget*) self->priv->container);
		g_object_set ((GObject*) gtk_scrolled_window_get_vadjustment (self->priv->paned), "step-increment", 20.0, NULL);
		gtk_widget_show_all ((GtkWidget*) self->priv->paned);
	}
}


static void gmpc_plugin_mockup_clear (GmpcPluginMockup* self) {
	GList* list;
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	list = gtk_container_get_children ((GtkContainer*) self->priv->container);
	{
		GList* child_collection;
		GList* child_it;
		child_collection = list;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child;
			child = _g_object_ref0 ((GtkWidget*) child_it->data);
			{
				gtk_object_destroy ((GtkObject*) child);
				_g_object_unref0 (child);
			}
		}
	}
	self->priv->bitrate_label = (_tmp0_ = NULL, _g_object_unref0 (self->priv->bitrate_label), _tmp0_);
	_g_list_free0 (list);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static char* gmpc_plugin_mockup_get_extension (GmpcPluginMockup* self, const char* path) {
	char* result;
	glong length;
	glong i;
	char* retv;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	length = string_get_length (path);
	i = length;
	retv = NULL;
	{
		gboolean _tmp0_;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			if (!_tmp0_) {
				i--;
			}
			_tmp0_ = FALSE;
			if (i > 0) {
				_tmp1_ = (length - i) < 8;
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			if (g_utf8_get_char (g_utf8_offset_to_pointer (path, i)) == '.') {
				char* _tmp2_;
				retv = (_tmp2_ = string_substring (path, i + 1, -1), _g_free0 (retv), _tmp2_);
				result = retv;
				return result;
			}
		}
	}
	result = retv;
	return result;
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static gboolean _lambda27_ (GtkWidget* widget, GdkEventButton* event, GmpcPluginMockup* self) {
	gboolean result;
	char* artist;
	g_return_val_if_fail (widget != NULL, FALSE);
	artist = g_strdup ((const char*) g_object_get_data ((GObject*) widget, "artist"));
	info2_fill_artist_view (artist);
	result = FALSE;
	_g_free0 (artist);
	return result;
}


static gboolean __lambda27__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	return _lambda27_ (_sender, event, self);
}


static gboolean _lambda28_ (GtkWidget* widget, GdkEventButton* event, GmpcPluginMockup* self) {
	gboolean result;
	char* artist;
	char* album;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (widget != NULL, FALSE);
	artist = g_strdup ((const char*) g_object_get_data ((GObject*) widget, "artist"));
	album = g_strdup ((const char*) g_object_get_data ((GObject*) widget, "album"));
	if (artist != NULL) {
		_tmp0_ = album != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		info2_fill_album_view (artist, album);
		result = TRUE;
		_g_free0 (artist);
		_g_free0 (album);
		return result;
	}
	result = FALSE;
	_g_free0 (artist);
	_g_free0 (album);
	return result;
}


static gboolean __lambda28__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	return _lambda28_ (_sender, event, self);
}


static void _lambda29_ (GtkButton* source, Block20Data* _data20_) {
	Block19Data* _data19_;
	GmpcPluginMockup * self;
	_data19_ = _data20_->_data19_;
	self = _data19_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-nowplaying2.vala:569: notebook page %i clicked", _data20_->j);
	gtk_notebook_set_current_page (_data19_->notebook, _data20_->j);
}


static void __lambda29__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda29_ (_sender, self);
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	++_data20_->_ref_count_;
	return _data20_;
}


static void block20_data_unref (Block20Data* _data20_) {
	if ((--_data20_->_ref_count_) == 0) {
		block19_data_unref (_data20_->_data19_);
		g_slice_free (Block20Data, _data20_);
	}
}


static void _lambda30_ (GtkButton* source, Block21Data* _data21_) {
	Block19Data* _data19_;
	GmpcPluginMockup * self;
	_data19_ = _data21_->_data19_;
	self = _data19_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-nowplaying2.vala:595: notebook page %i clicked", _data21_->j);
	gtk_notebook_set_current_page (_data19_->notebook, _data21_->j);
	if (!_data21_->text_view_queried) {
		gmpc_meta_text_view_query_text_from_song (_data21_->text_view, _data19_->song);
		_data21_->text_view_queried = TRUE;
		gmpc_plugin_mockup_change_color_style (self, (GtkWidget*) _data21_->text_view);
	}
}


static void __lambda30__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda30_ (_sender, self);
}


static Block21Data* block21_data_ref (Block21Data* _data21_) {
	++_data21_->_ref_count_;
	return _data21_;
}


static void block21_data_unref (Block21Data* _data21_) {
	if ((--_data21_->_ref_count_) == 0) {
		block19_data_unref (_data21_->_data19_);
		_g_object_unref0 (_data21_->text_view);
		g_slice_free (Block21Data, _data21_);
	}
}


static void _lambda31_ (GtkButton* source, Block22Data* _data22_) {
	Block19Data* _data19_;
	GmpcPluginMockup * self;
	_data19_ = _data22_->_data19_;
	self = _data19_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-nowplaying2.vala:626: notebook page %i clicked", _data22_->j);
	gtk_notebook_set_current_page (_data19_->notebook, _data22_->j);
	if (!_data22_->similar_songs_queried) {
		GmpcWidgetSimilarSongs* similar_songs;
		similar_songs = g_object_ref_sink (gmpc_widget_similar_songs_new (_data19_->song));
		gmpc_widget_similar_songs_update (similar_songs);
		_data22_->similar_songs_queried = TRUE;
		gtk_container_add ((GtkContainer*) _data22_->similar_songs_box, (GtkWidget*) similar_songs);
		gmpc_plugin_mockup_change_color_style (self, (GtkWidget*) _data22_->similar_songs_box);
		gtk_widget_show_all ((GtkWidget*) _data22_->similar_songs_box);
		_g_object_unref0 (similar_songs);
	}
}


static void __lambda31__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda31_ (_sender, self);
}


static Block22Data* block22_data_ref (Block22Data* _data22_) {
	++_data22_->_ref_count_;
	return _data22_;
}


static void block22_data_unref (Block22Data* _data22_) {
	if ((--_data22_->_ref_count_) == 0) {
		block19_data_unref (_data22_->_data19_);
		_g_object_unref0 (_data22_->similar_songs_box);
		g_slice_free (Block22Data, _data22_);
	}
}


static void _lambda32_ (GtkButton* source, Block23Data* _data23_) {
	Block19Data* _data19_;
	GmpcPluginMockup * self;
	_data19_ = _data23_->_data19_;
	self = _data19_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-nowplaying2.vala:660: notebook page %i clicked", _data23_->j);
	gtk_notebook_set_current_page (_data19_->notebook, _data23_->j);
}


static void __lambda32__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda32_ (_sender, self);
}


static Block23Data* block23_data_ref (Block23Data* _data23_) {
	++_data23_->_ref_count_;
	return _data23_;
}


static void block23_data_unref (Block23Data* _data23_) {
	if ((--_data23_->_ref_count_) == 0) {
		block19_data_unref (_data23_->_data19_);
		g_slice_free (Block23Data, _data23_);
	}
}


static void _lambda33_ (GtkButton* source, Block24Data* _data24_) {
	Block19Data* _data19_;
	GmpcPluginMockup * self;
	_data19_ = _data24_->_data19_;
	self = _data19_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-nowplaying2.vala:676: notebook page %i clicked", _data24_->j);
	gtk_notebook_set_current_page (_data19_->notebook, _data24_->j);
}


static void __lambda33__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda33_ (_sender, self);
}


static Block24Data* block24_data_ref (Block24Data* _data24_) {
	++_data24_->_ref_count_;
	return _data24_;
}


static void block24_data_unref (Block24Data* _data24_) {
	if ((--_data24_->_ref_count_) == 0) {
		block19_data_unref (_data24_->_data19_);
		g_slice_free (Block24Data, _data24_);
	}
}


static void _lambda34_ (GtkButton* source, Block25Data* _data25_) {
	Block19Data* _data19_;
	GmpcPluginMockup * self;
	_data19_ = _data25_->_data19_;
	self = _data19_->self;
	g_return_if_fail (source != NULL);
	g_debug ("gmpc-nowplaying2.vala:699: notebook page %i clicked", _data25_->j);
	gtk_notebook_set_current_page (_data19_->notebook, _data25_->j);
	if (!_data25_->text_view_queried) {
		gmpc_meta_text_view_query_text_from_song (_data25_->text_view, _data19_->song);
		_data25_->text_view_queried = TRUE;
		gmpc_plugin_mockup_change_color_style (self, (GtkWidget*) _data25_->text_view);
	}
}


static void __lambda34__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda34_ (_sender, self);
}


static Block25Data* block25_data_ref (Block25Data* _data25_) {
	++_data25_->_ref_count_;
	return _data25_;
}


static void block25_data_unref (Block25Data* _data25_) {
	if ((--_data25_->_ref_count_) == 0) {
		block19_data_unref (_data25_->_data19_);
		_g_object_unref0 (_data25_->text_view);
		g_slice_free (Block25Data, _data25_);
	}
}


static void _lambda35_ (GObject* source, GParamSpec* spec, Block19Data* _data19_) {
	GmpcPluginMockup * self;
	gint page;
	self = _data19_->self;
	g_return_if_fail (source != NULL);
	g_return_if_fail (spec != NULL);
	page = gtk_notebook_get_current_page (_data19_->notebook);
	cfg_set_single_value_as_int (config, "NowPlaying", "last-page", (gint) page);
}


static void __lambda35__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda35_ (_sender, pspec, self);
}


static void _lambda36_ (GtkButton* source, Block26Data* _data26_) {
	Block19Data* _data19_;
	GmpcPluginMockup * self;
	_data19_ = _data26_->_data19_;
	self = _data19_->self;
	g_return_if_fail (source != NULL);
	info2_fill_album_view (_data19_->song->artist, _data26_->but_song->album);
}


static void __lambda36__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda36_ (_sender, self);
}


static Block26Data* block26_data_ref (Block26Data* _data26_) {
	++_data26_->_ref_count_;
	return _data26_;
}


static void block26_data_unref (Block26Data* _data26_) {
	if ((--_data26_->_ref_count_) == 0) {
		block19_data_unref (_data26_->_data19_);
		_mpd_freeSong0 (_data26_->but_song);
		g_slice_free (Block26Data, _data26_);
	}
}


static Block19Data* block19_data_ref (Block19Data* _data19_) {
	++_data19_->_ref_count_;
	return _data19_;
}


static void block19_data_unref (Block19Data* _data19_) {
	if ((--_data19_->_ref_count_) == 0) {
		_g_object_unref0 (_data19_->self);
		_mpd_freeSong0 (_data19_->song);
		_g_object_unref0 (_data19_->notebook);
		g_slice_free (Block19Data, _data19_);
	}
}


static void gmpc_plugin_mockup_update_playing (GmpcPluginMockup* self) {
	GError * _inner_error_;
	Block19Data* _data19_;
	char* checksum;
	char* _tmp0_;
	GtkVBox* vbox;
	GtkHBox* hbox;
	GtkAlignment* ali;
	GmpcMetaImage* album_image;
	GtkAlignment* _tmp1_;
	GmpcMetaImage* artist_image;
	GtkVBox* info_vbox;
	GtkHSeparator* sep;
	GtkHBox* hboxje;
	gint i;
	GSList* group;
	gboolean _tmp30_ = FALSE;
	GtkAlignment* _tmp34_;
	GtkHBox* bottom_hbox;
	GtkVBox* metadata_vbox;
	GtkHSeparator* _tmp35_;
	gboolean _tmp36_ = FALSE;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = g_object_ref (self);
	_data19_->song = _mpd_songDup0 (mpd_playlist_get_current_song (connection));
	if (_data19_->song == NULL) {
		g_debug ("gmpc-nowplaying2.vala:292: GMPC Is playing, cannot get this");
		gmpc_plugin_mockup_update_not_playing (self);
		block19_data_unref (_data19_);
		return;
	}
	checksum = mpd_song_checksum (_data19_->song);
	if (_vala_strcmp0 (checksum, self->priv->song_checksum) == 0) {
		_g_free0 (checksum);
		block19_data_unref (_data19_);
		return;
	}
	gmpc_plugin_mockup_clear (self);
	self->priv->song_checksum = (_tmp0_ = g_strdup (checksum), _g_free0 (self->priv->song_checksum), _tmp0_);
	vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 8);
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	ali = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f));
	album_image = g_object_ref_sink (gmpc_metaimage_new_size (META_ALBUM_ART, 200));
	gmpc_metaimage_set_scale_up (album_image, TRUE);
	gmpc_metaimage_set_squared (album_image, FALSE);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) album_image);
	gmpc_metaimage_update_cover_from_song (album_image, _data19_->song);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	ali = (_tmp1_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (1.f, 0.f, 0.f, 0.f)), _g_object_unref0 (ali), _tmp1_);
	artist_image = g_object_ref_sink (gmpc_metaimage_new_size (META_ARTIST_ART, 200));
	gmpc_metaimage_set_scale_up (artist_image, TRUE);
	gmpc_metaimage_set_squared (artist_image, FALSE);
	gmpc_metaimage_update_cover_from_song (artist_image, _data19_->song);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) artist_image);
	gtk_box_pack_end ((GtkBox*) hbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	info_vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	if (_data19_->song->title != NULL) {
		GtkHBox* box;
		GmpcFavoritesButton* fav_button;
		GtkAlignment* _tmp2_;
		GtkLabel* label;
		char* _tmp3_;
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		fav_button = g_object_ref_sink (gmpc_favorites_button_new ());
		gmpc_favorites_button_set_song (fav_button, _data19_->song);
		ali = (_tmp2_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f)), _g_object_unref0 (ali), _tmp2_);
		gtk_container_add ((GtkContainer*) ali, (GtkWidget*) fav_button);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data19_->song->title));
		gtk_label_set_selectable (label, TRUE);
		gtk_label_set_markup (label, _tmp3_ = g_markup_printf_escaped ("<span color='%s' size='%i' weight='bold'>%s</span>", self->priv->title_color, PANGO_SCALE * 20, _data19_->song->title));
		_g_free0 (_tmp3_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		if (mpd_sticker_supported (connection)) {
			GmpcRating* rating_button;
			GtkAlignment* _tmp4_;
			rating_button = g_object_ref_sink (gmpc_rating_new (connection, _data19_->song));
			ali = (_tmp4_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f)), _g_object_unref0 (ali), _tmp4_);
			gtk_container_add ((GtkContainer*) ali, (GtkWidget*) rating_button);
			gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
			_g_object_unref0 (rating_button);
		}
		_g_object_unref0 (box);
		_g_object_unref0 (fav_button);
		_g_object_unref0 (label);
	} else {
		if (_data19_->song->name != NULL) {
			GtkLabel* label;
			char* _tmp5_;
			label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data19_->song->name));
			gtk_label_set_selectable (label, TRUE);
			gtk_label_set_markup (label, _tmp5_ = g_markup_printf_escaped ("<span color='%s' size='%i' weight='bold'>%s</span>", self->priv->title_color, PANGO_SCALE * 20, _data19_->song->name));
			_g_free0 (_tmp5_);
			gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
			gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
			gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
			_g_object_unref0 (label);
		} else {
			if (_data19_->song->file != NULL) {
				char* filename;
				GtkLabel* label;
				char* _tmp10_;
				filename = g_path_get_basename (_data19_->song->file);
				label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data19_->song->name));
				gtk_label_set_selectable (label, TRUE);
				{
					GRegex* regex;
					char* _tmp6_;
					char* _tmp7_;
					regex = g_regex_new ("\\.[0-9a-zA-Z]*$", 0, 0, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch8_g_regex_error;
						}
						_g_free0 (filename);
						_g_object_unref0 (label);
						_g_free0 (checksum);
						_g_object_unref0 (vbox);
						_g_object_unref0 (hbox);
						_g_object_unref0 (ali);
						_g_object_unref0 (album_image);
						_g_object_unref0 (artist_image);
						_g_object_unref0 (info_vbox);
						block19_data_unref (_data19_);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp6_ = g_regex_replace_literal (regex, filename, (gssize) (-1), 0, "", 0, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_regex_unref0 (regex);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch8_g_regex_error;
						}
						_g_regex_unref0 (regex);
						_g_free0 (filename);
						_g_object_unref0 (label);
						_g_free0 (checksum);
						_g_object_unref0 (vbox);
						_g_object_unref0 (hbox);
						_g_object_unref0 (ali);
						_g_object_unref0 (album_image);
						_g_object_unref0 (artist_image);
						_g_object_unref0 (info_vbox);
						block19_data_unref (_data19_);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					filename = (_tmp7_ = _tmp6_, _g_free0 (filename), _tmp7_);
					_g_regex_unref0 (regex);
				}
				goto __finally8;
				__catch8_g_regex_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						fprintf (stdout, "%s", e->message);
						g_assert_not_reached ();
						_g_error_free0 (e);
					}
				}
				__finally8:
				if (_inner_error_ != NULL) {
					_g_free0 (filename);
					_g_object_unref0 (label);
					_g_free0 (checksum);
					_g_object_unref0 (vbox);
					_g_object_unref0 (hbox);
					_g_object_unref0 (ali);
					_g_object_unref0 (album_image);
					_g_object_unref0 (artist_image);
					_g_object_unref0 (info_vbox);
					block19_data_unref (_data19_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				{
					GRegex* regex;
					char* _tmp8_;
					char* _tmp9_;
					regex = g_regex_new ("_", 0, 0, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch9_g_regex_error;
						}
						_g_free0 (filename);
						_g_object_unref0 (label);
						_g_free0 (checksum);
						_g_object_unref0 (vbox);
						_g_object_unref0 (hbox);
						_g_object_unref0 (ali);
						_g_object_unref0 (album_image);
						_g_object_unref0 (artist_image);
						_g_object_unref0 (info_vbox);
						block19_data_unref (_data19_);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp8_ = g_regex_replace_literal (regex, filename, (gssize) (-1), 0, " ", 0, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_regex_unref0 (regex);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch9_g_regex_error;
						}
						_g_regex_unref0 (regex);
						_g_free0 (filename);
						_g_object_unref0 (label);
						_g_free0 (checksum);
						_g_object_unref0 (vbox);
						_g_object_unref0 (hbox);
						_g_object_unref0 (ali);
						_g_object_unref0 (album_image);
						_g_object_unref0 (artist_image);
						_g_object_unref0 (info_vbox);
						block19_data_unref (_data19_);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					filename = (_tmp9_ = _tmp8_, _g_free0 (filename), _tmp9_);
					_g_regex_unref0 (regex);
				}
				goto __finally9;
				__catch9_g_regex_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						fprintf (stdout, "%s", e->message);
						g_assert_not_reached ();
						_g_error_free0 (e);
					}
				}
				__finally9:
				if (_inner_error_ != NULL) {
					_g_free0 (filename);
					_g_object_unref0 (label);
					_g_free0 (checksum);
					_g_object_unref0 (vbox);
					_g_object_unref0 (hbox);
					_g_object_unref0 (ali);
					_g_object_unref0 (album_image);
					_g_object_unref0 (artist_image);
					_g_object_unref0 (info_vbox);
					block19_data_unref (_data19_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				gtk_label_set_markup (label, _tmp10_ = g_markup_printf_escaped ("<span color='%s' size='%i' weight='bold'>%s</span>", self->priv->title_color, PANGO_SCALE * 20, filename));
				_g_free0 (_tmp10_);
				gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
				gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
				gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
				_g_free0 (filename);
				_g_object_unref0 (label);
			}
		}
	}
	if (_data19_->song->artist != NULL) {
		GtkEventBox* event;
		GtkHBox* box;
		GtkLabel* label;
		GtkImage* image;
		char* _tmp11_;
		event = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ());
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data19_->song->artist));
		gtk_label_set_selectable (label, TRUE);
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-artist", GTK_ICON_SIZE_MENU));
		gtk_container_add ((GtkContainer*) event, (GtkWidget*) image);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) event, FALSE, FALSE, (guint) 0);
		gtk_label_set_markup (label, _tmp11_ = g_markup_printf_escaped ("<span size='xx-large' weight='bold'>%s</span>", _data19_->song->artist));
		_g_free0 (_tmp11_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		g_object_set_data_full ((GObject*) event, "artist", (void*) g_strdup_printf ("%s", _data19_->song->artist), (GDestroyNotify) g_free);
		g_signal_connect_object ((GtkWidget*) event, "button-press-event", (GCallback) __lambda27__gtk_widget_button_press_event, self, 0);
		_g_object_unref0 (event);
		_g_object_unref0 (box);
		_g_object_unref0 (label);
		_g_object_unref0 (image);
	}
	if (_data19_->song->album != NULL) {
		GtkEventBox* event;
		GtkHBox* box;
		GtkLabel* label;
		GtkImage* image;
		char* _tmp12_;
		char* _tmp15_;
		event = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ());
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data19_->song->album));
		gtk_label_set_selectable (label, TRUE);
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-album", GTK_ICON_SIZE_MENU));
		gtk_container_add ((GtkContainer*) event, (GtkWidget*) image);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) event, FALSE, FALSE, (guint) 0);
		_tmp12_ = NULL;
		if (_data19_->song->date != NULL) {
			char* _tmp13_;
			_tmp12_ = (_tmp13_ = g_strdup_printf ("(%s)", _data19_->song->date), _g_free0 (_tmp12_), _tmp13_);
		} else {
			char* _tmp14_;
			_tmp12_ = (_tmp14_ = g_strdup (""), _g_free0 (_tmp12_), _tmp14_);
		}
		gtk_label_set_markup (label, _tmp15_ = g_markup_printf_escaped ("<span size='x-large' weight='bold'>%s %s</span>", _data19_->song->album, _tmp12_));
		_g_free0 (_tmp15_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		g_object_set_data_full ((GObject*) event, "artist", (void*) g_strdup_printf ("%s", _data19_->song->artist), (GDestroyNotify) g_free);
		g_object_set_data_full ((GObject*) event, "album", (void*) g_strdup_printf ("%s", _data19_->song->album), (GDestroyNotify) g_free);
		g_signal_connect_object ((GtkWidget*) event, "button-press-event", (GCallback) __lambda28__gtk_widget_button_press_event, self, 0);
		_g_object_unref0 (event);
		_g_object_unref0 (box);
		_g_object_unref0 (label);
		_g_object_unref0 (image);
		_g_free0 (_tmp12_);
	}
	if (_data19_->song->genre != NULL) {
		GtkHBox* box;
		GtkLabel* label;
		GtkImage* image;
		char* _tmp16_;
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data19_->song->title));
		gtk_label_set_selectable (label, TRUE);
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-genre", GTK_ICON_SIZE_MENU));
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		gtk_label_set_markup (label, _tmp16_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %s", self->priv->item_color, _ ("Genre"), _data19_->song->genre));
		_g_free0 (_tmp16_);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (box);
		_g_object_unref0 (label);
		_g_object_unref0 (image);
	}
	{
		GtkHBox* box;
		GtkImage* image;
		GtkLabel* _tmp17_;
		gint bitrate;
		gint channels;
		char* _tmp18_;
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-format", GTK_ICON_SIZE_MENU));
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		self->priv->bitrate_label = (_tmp17_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data19_->song->title)), _g_object_unref0 (self->priv->bitrate_label), _tmp17_);
		gtk_label_set_selectable (self->priv->bitrate_label, TRUE);
		gtk_label_set_ellipsize (self->priv->bitrate_label, PANGO_ELLIPSIZE_END);
		gtk_misc_set_alignment ((GtkMisc*) self->priv->bitrate_label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->bitrate_label, TRUE, TRUE, (guint) 0);
		bitrate = mpd_status_get_bitrate (connection);
		channels = mpd_status_get_channels (connection);
		gtk_label_set_markup (self->priv->bitrate_label, _tmp18_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %i %s, %.1f %s, %i %s", self->priv->item_color, _ ("Format"), channels, ngettext (N_ ("Channel"), N_ ("Channels"), (gulong) channels), mpd_status_get_samplerate (connection) / 1000.0, _ ("kHz"), bitrate, _ ("kbps")));
		_g_free0 (_tmp18_);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (box);
		_g_object_unref0 (image);
	}
	if (_data19_->song->file != NULL) {
		char* extension;
		char* _tmp19_;
		extension = NULL;
		extension = (_tmp19_ = gmpc_plugin_mockup_get_extension (self, _data19_->song->file), _g_free0 (extension), _tmp19_);
		if (extension != NULL) {
			GtkHBox* box;
			GtkImage* image;
			GtkLabel* label;
			char* _tmp20_;
			box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
			image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-codec", GTK_ICON_SIZE_MENU));
			gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
			label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data19_->song->title));
			gtk_label_set_selectable (label, TRUE);
			gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
			gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
			gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
			gtk_label_set_markup (label, _tmp20_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %s", self->priv->item_color, _ ("Codec"), extension));
			_g_free0 (_tmp20_);
			gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
			_g_object_unref0 (box);
			_g_object_unref0 (image);
			_g_object_unref0 (label);
		}
		_g_free0 (extension);
	}
	if (_data19_->song->time > 0) {
		GtkHBox* box;
		GtkImage* image;
		GtkLabel* label;
		char* _tmp22_;
		char* _tmp21_;
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-track-length", GTK_ICON_SIZE_MENU));
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (""));
		gtk_label_set_selectable (label, TRUE);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		gtk_label_set_markup (label, _tmp22_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %s", self->priv->item_color, _ ("Length"), _tmp21_ = format_time_real ((gulong) _data19_->song->time, "")));
		_g_free0 (_tmp22_);
		_g_free0 (_tmp21_);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (box);
		_g_object_unref0 (image);
		_g_object_unref0 (label);
	}
	if (_data19_->song->track != NULL) {
		GtkHBox* box;
		GtkImage* image;
		GtkLabel* label;
		char* _tmp23_;
		char* _tmp26_;
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-num-tracks", GTK_ICON_SIZE_MENU));
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (""));
		gtk_label_set_selectable (label, TRUE);
		gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
		_tmp23_ = NULL;
		if (_data19_->song->disc != NULL) {
			char* _tmp24_;
			_tmp23_ = (_tmp24_ = g_strdup_printf ("[%s]", _data19_->song->disc), _g_free0 (_tmp23_), _tmp24_);
		} else {
			char* _tmp25_;
			_tmp23_ = (_tmp25_ = g_strdup (""), _g_free0 (_tmp23_), _tmp25_);
		}
		gtk_label_set_markup (label, _tmp26_ = g_markup_printf_escaped ("<span color='%s' weight='bold'>%s:</span> %s %s", self->priv->item_color, _ ("Track number"), _data19_->song->track, _tmp23_));
		_g_free0 (_tmp26_);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) info_vbox, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (box);
		_g_object_unref0 (image);
		_g_object_unref0 (label);
		_g_free0 (_tmp23_);
	}
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) info_vbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	sep = g_object_ref_sink ((GtkHSeparator*) gtk_hseparator_new ());
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 4);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	hboxje = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	_data19_->notebook = g_object_ref_sink ((GtkNotebook*) gtk_notebook_new ());
	gtk_notebook_set_show_border (_data19_->notebook, FALSE);
	gtk_notebook_set_show_tabs (_data19_->notebook, FALSE);
	i = 0;
	group = NULL;
	if (cfg_get_single_value_as_int_with_default (config, "MetaData", "show-lyrics", 1) == 1) {
		Block20Data* _data20_;
		GtkAlignment* alib;
		GmpcMetaTextView* text_view;
		GtkLabel* _tmp27_;
		GtkRadioButton* button;
		_data20_ = g_slice_new0 (Block20Data);
		_data20_->_ref_count_ = 1;
		_data20_->_data19_ = block19_data_ref (_data19_);
		alib = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 0.f));
		text_view = g_object_ref_sink (gmpc_meta_text_view_new (META_SONG_TXT));
		text_view->force_ro = TRUE;
		gtk_text_view_set_left_margin ((GtkTextView*) text_view, 8);
		gmpc_meta_text_view_query_text_from_song (text_view, _data19_->song);
		gtk_container_add ((GtkContainer*) alib, (GtkWidget*) text_view);
		gtk_notebook_append_page (_data19_->notebook, (GtkWidget*) alib, (GtkWidget*) (_tmp27_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("Lyrics"))));
		_g_object_unref0 (_tmp27_);
		button = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_label (group, "Lyrics"));
		group = gtk_radio_button_get_group (button);
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data20_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda29__gtk_button_clicked, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
		i++;
		gtk_widget_show ((GtkWidget*) alib);
		_g_object_unref0 (alib);
		_g_object_unref0 (text_view);
		_g_object_unref0 (button);
		block20_data_unref (_data20_);
	}
	if (cfg_get_single_value_as_int_with_default (config, "MetaData", "show-guitar-tabs", 1) == 1) {
		Block21Data* _data21_;
		GtkAlignment* alib;
		GtkLabel* _tmp28_;
		GtkRadioButton* button;
		_data21_ = g_slice_new0 (Block21Data);
		_data21_->_ref_count_ = 1;
		_data21_->_data19_ = block19_data_ref (_data19_);
		alib = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 0.f));
		_data21_->text_view = g_object_ref_sink (gmpc_meta_text_view_new (META_SONG_GUITAR_TAB));
		_data21_->text_view->force_ro = TRUE;
		_data21_->text_view->use_monospace = TRUE;
		gtk_text_view_set_left_margin ((GtkTextView*) _data21_->text_view, 8);
		_data21_->text_view_queried = FALSE;
		gtk_container_add ((GtkContainer*) alib, (GtkWidget*) _data21_->text_view);
		gtk_notebook_append_page (_data19_->notebook, (GtkWidget*) alib, (GtkWidget*) (_tmp28_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Guitar Tabs")))));
		_g_object_unref0 (_tmp28_);
		button = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_label (group, _ ("Guitar Tabs")));
		group = gtk_radio_button_get_group (button);
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data21_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda30__gtk_button_clicked, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
		if (i == 0) {
			gmpc_meta_text_view_query_text_from_song (_data21_->text_view, _data19_->song);
			_data21_->text_view_queried = TRUE;
		}
		gtk_widget_show ((GtkWidget*) alib);
		i++;
		_g_object_unref0 (alib);
		_g_object_unref0 (button);
		block21_data_unref (_data21_);
	}
	if (cfg_get_single_value_as_int_with_default (config, "MetaData", "show-similar-songs", 1) == 1) {
		Block22Data* _data22_;
		GtkLabel* _tmp29_;
		GtkRadioButton* button;
		_data22_ = g_slice_new0 (Block22Data);
		_data22_->_ref_count_ = 1;
		_data22_->_data19_ = block19_data_ref (_data19_);
		_data22_->similar_songs_queried = FALSE;
		_data22_->similar_songs_box = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f));
		gtk_notebook_append_page (_data19_->notebook, (GtkWidget*) _data22_->similar_songs_box, (GtkWidget*) (_tmp29_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Similar Songs")))));
		_g_object_unref0 (_tmp29_);
		button = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_label (group, _ ("Similar Songs")));
		group = gtk_radio_button_get_group (button);
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data22_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda31__gtk_button_clicked, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
		if (i == 0) {
			GmpcWidgetSimilarSongs* similar_songs;
			similar_songs = g_object_ref_sink (gmpc_widget_similar_songs_new (_data19_->song));
			gmpc_widget_similar_songs_update (similar_songs);
			_data22_->similar_songs_queried = TRUE;
			gtk_container_add ((GtkContainer*) _data22_->similar_songs_box, (GtkWidget*) similar_songs);
			gtk_widget_show_all ((GtkWidget*) _data22_->similar_songs_box);
			_g_object_unref0 (similar_songs);
		}
		gtk_widget_show ((GtkWidget*) _data22_->similar_songs_box);
		i++;
		_g_object_unref0 (button);
		block22_data_unref (_data22_);
	}
	if (cfg_get_single_value_as_int_with_default (config, "MetaData", "show-similar-artist", 1) == 1) {
		_tmp30_ = _data19_->song->artist != NULL;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		Block23Data* _data23_;
		GmpcWidgetSimilarArtist* similar_artist;
		GtkLabel* _tmp31_;
		GtkRadioButton* button;
		_data23_ = g_slice_new0 (Block23Data);
		_data23_->_ref_count_ = 1;
		_data23_->_data19_ = block19_data_ref (_data19_);
		similar_artist = g_object_ref_sink (gmpc_widget_similar_artist_new (connection, _data19_->song));
		gtk_notebook_append_page (_data19_->notebook, (GtkWidget*) similar_artist, (GtkWidget*) (_tmp31_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Similar Artist")))));
		_g_object_unref0 (_tmp31_);
		button = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_label (group, _ ("Similar Artist")));
		group = gtk_radio_button_get_group (button);
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data23_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda32__gtk_button_clicked, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		gtk_widget_show ((GtkWidget*) similar_artist);
		i++;
		_g_object_unref0 (similar_artist);
		_g_object_unref0 (button);
		block23_data_unref (_data23_);
	}
	if (cfg_get_single_value_as_int_with_default (config, "MetaData", "show-web-links", 1) == 1) {
		Block24Data* _data24_;
		GmpcSongLinks* song_links;
		GtkLabel* _tmp32_;
		GtkRadioButton* button;
		_data24_ = g_slice_new0 (Block24Data);
		_data24_->_ref_count_ = 1;
		_data24_->_data19_ = block19_data_ref (_data19_);
		song_links = g_object_ref_sink (gmpc_song_links_new (GMPC_SONG_LINKS_TYPE_SONG, _data19_->song));
		gtk_notebook_append_page (_data19_->notebook, (GtkWidget*) song_links, (GtkWidget*) (_tmp32_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Web Links")))));
		_g_object_unref0 (_tmp32_);
		button = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_label (group, _ ("Web Links")));
		group = gtk_radio_button_get_group (button);
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data24_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda33__gtk_button_clicked, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
		gtk_widget_show ((GtkWidget*) song_links);
		i++;
		_g_object_unref0 (song_links);
		_g_object_unref0 (button);
		block24_data_unref (_data24_);
	}
	if (cfg_get_single_value_as_int_with_default (config, "MetaData", "show-artist-information", 1) == 1) {
		Block25Data* _data25_;
		GtkAlignment* alib;
		GtkLabel* _tmp33_;
		GtkRadioButton* button;
		_data25_ = g_slice_new0 (Block25Data);
		_data25_->_ref_count_ = 1;
		_data25_->_data19_ = block19_data_ref (_data19_);
		alib = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 0.f));
		_data25_->text_view = g_object_ref_sink (gmpc_meta_text_view_new (META_ARTIST_TXT));
		_data25_->text_view->force_ro = TRUE;
		_data25_->text_view->use_monospace = FALSE;
		gtk_text_view_set_left_margin ((GtkTextView*) _data25_->text_view, 8);
		_data25_->text_view_queried = FALSE;
		gtk_container_add ((GtkContainer*) alib, (GtkWidget*) _data25_->text_view);
		gtk_notebook_append_page (_data19_->notebook, (GtkWidget*) alib, (GtkWidget*) (_tmp33_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Artist information")))));
		_g_object_unref0 (_tmp33_);
		button = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_label (group, _ ("Artist information")));
		group = gtk_radio_button_get_group (button);
		gtk_box_pack_start ((GtkBox*) hboxje, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
		_data25_->j = i;
		g_signal_connect_data ((GtkButton*) button, "clicked", (GCallback) __lambda34__gtk_button_clicked, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
		if (i == 0) {
			gmpc_meta_text_view_query_text_from_song (_data25_->text_view, _data19_->song);
			_data25_->text_view_queried = TRUE;
		}
		gtk_widget_show ((GtkWidget*) alib);
		i++;
		_g_object_unref0 (alib);
		_g_object_unref0 (button);
		block25_data_unref (_data25_);
	}
	g_signal_connect_data ((GObject*) _data19_->notebook, "notify::page", (GCallback) __lambda35__g_object_notify, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	if (i > 0) {
		gint page;
		page = cfg_get_single_value_as_int_with_default (config, "NowPlaying", "last-page", 0);
		if (page > i) {
			gtk_notebook_set_current_page (_data19_->notebook, 0);
		} else {
			GtkRadioButton* w;
			w = _g_object_ref0 ((GtkRadioButton*) g_slist_nth_data (group, (guint) ((i - page) - 1)));
			gtk_toggle_button_set_active ((GtkToggleButton*) w, TRUE);
			gtk_notebook_set_current_page (_data19_->notebook, page);
			_g_object_unref0 (w);
		}
	}
	ali = (_tmp34_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.f, 0.f)), _g_object_unref0 (ali), _tmp34_);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) hboxje);
	bottom_hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	metadata_vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	sep = (_tmp35_ = g_object_ref_sink ((GtkHSeparator*) gtk_hseparator_new ()), _g_object_unref0 (sep), _tmp35_);
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 1);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) metadata_vbox, (GtkWidget*) _data19_->notebook, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) bottom_hbox, (GtkWidget*) metadata_vbox, TRUE, TRUE, (guint) 0);
	if (_data19_->song->album != NULL) {
		_tmp36_ = _data19_->song->artist != NULL;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		GtkVSeparator* sep2;
		gint albums;
		GtkAlignment* _tmp37_;
		GtkVBox* album_hbox;
		GtkLabel* label;
		char* _tmp38_;
		MpdData* list;
		MpdData* data;
		sep2 = g_object_ref_sink ((GtkVSeparator*) gtk_vseparator_new ());
		gtk_widget_set_size_request ((GtkWidget*) sep2, -1, 4);
		gtk_box_pack_start ((GtkBox*) bottom_hbox, (GtkWidget*) sep2, FALSE, FALSE, (guint) 0);
		albums = 0;
		ali = (_tmp37_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.0f, 0.0f, 0.0f, 0.0f)), _g_object_unref0 (ali), _tmp37_);
		album_hbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
		gtk_widget_set_size_request ((GtkWidget*) album_hbox, 250, -1);
		gtk_container_add ((GtkContainer*) ali, (GtkWidget*) album_hbox);
		gtk_box_pack_start ((GtkBox*) bottom_hbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_data19_->song->artist));
		gtk_label_set_selectable (label, TRUE);
		gtk_widget_set_size_request ((GtkWidget*) label, 240, -1);
		gtk_label_set_markup (label, _tmp38_ = g_markup_printf_escaped ("<span size='x-large' weight='bold' color='%s'>%s</span><span size='x-large' weight='bold'> %s</span>", self->priv->item_color, _ ("Other albums by"), _data19_->song->artist));
		_g_free0 (_tmp38_);
		gtk_label_set_line_wrap_mode (label, PANGO_WRAP_WORD_CHAR);
		gtk_label_set_line_wrap (label, TRUE);
		gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
		gtk_box_pack_start ((GtkBox*) album_hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
		mpd_database_search_field_start (connection, MPD_TAG_ITEM_ALBUM);
		mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, _data19_->song->artist);
		list = NULL;
		data = mpd_database_search_commit (connection);
		if (data != NULL) {
			const MpdData* iter;
			iter = mpd_data_get_first (data);
			{
				gboolean _tmp39_;
				_tmp39_ = TRUE;
				while (TRUE) {
					mpd_Song* _tmp40_;
					char* _tmp41_;
					char* _tmp42_;
					MpdData* ydata;
					if (!_tmp39_) {
						if (!(iter != NULL)) {
							break;
						}
					}
					_tmp39_ = FALSE;
					if (_vala_strcmp0 (iter->tag, _data19_->song->album) == 0) {
						iter = mpd_data_get_next_real (iter, FALSE);
						continue;
					}
					list = mpd_new_data_struct_append (list);
					list->type = MPD_DATA_TYPE_SONG;
					list->song = (_tmp40_ = mpd_newSong (), _mpd_freeSong0 (list->song), _tmp40_);
					list->song->artist = (_tmp41_ = g_strdup (_data19_->song->artist), _g_free0 (list->song->artist), _tmp41_);
					list->song->album = (_tmp42_ = g_strdup (iter->tag), _g_free0 (list->song->album), _tmp42_);
					mpd_database_search_field_start (connection, MPD_TAG_ITEM_DATE);
					mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ARTIST, _data19_->song->artist);
					mpd_database_search_add_constraint (connection, MPD_TAG_ITEM_ALBUM, iter->tag);
					ydata = mpd_database_search_commit (connection);
					if (ydata != NULL) {
						char* _tmp43_;
						list->song->date = (_tmp43_ = g_strdup (ydata->tag), _g_free0 (list->song->date), _tmp43_);
					}
					iter = mpd_data_get_next_real (iter, FALSE);
					_mpd_data_free0 (ydata);
				}
			}
		}
		list = misc_sort_mpddata_by_album_disc_track (list);
		if (list != NULL) {
			const MpdData* iter;
			iter = mpd_data_get_first (list);
			{
				gboolean _tmp44_;
				_tmp44_ = TRUE;
				while (TRUE) {
					Block26Data* _data26_;
					GtkButton* button;
					GtkHBox* but_hbox;
					GmpcMetaImage* image;
					GtkLabel* but_label;
					char* strlabel;
					gboolean _tmp45_ = FALSE;
					char* _tmp50_;
					_data26_ = g_slice_new0 (Block26Data);
					_data26_->_ref_count_ = 1;
					_data26_->_data19_ = block19_data_ref (_data19_);
					if (!_tmp44_) {
						if (!(iter != NULL)) {
							block26_data_unref (_data26_);
							break;
						}
					}
					_tmp44_ = FALSE;
					button = g_object_ref_sink ((GtkButton*) gtk_button_new ());
					gtk_button_set_relief (button, GTK_RELIEF_NONE);
					but_hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
					gtk_container_add ((GtkContainer*) button, (GtkWidget*) but_hbox);
					image = g_object_ref_sink (gmpc_metaimage_new_size (META_ALBUM_ART, 48));
					_data26_->but_song = _mpd_songDup0 (iter->song);
					gmpc_metaimage_set_squared (image, TRUE);
					gmpc_metaimage_update_cover_from_song_delayed (image, _data26_->but_song);
					gtk_box_pack_start ((GtkBox*) but_hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
					but_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (iter->song->album));
					gtk_label_set_selectable (but_label, TRUE);
					gtk_misc_set_alignment ((GtkMisc*) but_label, 0.0f, 0.5f);
					strlabel = g_strdup ("");
					if (iter->song->date != NULL) {
						_tmp45_ = string_get_length (iter->song->date) > 0;
					} else {
						_tmp45_ = FALSE;
					}
					if (_tmp45_) {
						char* _tmp47_;
						char* _tmp46_;
						strlabel = (_tmp47_ = g_strconcat (strlabel, _tmp46_ = g_strdup_printf ("%s\n", iter->song->date), NULL), _g_free0 (strlabel), _tmp47_);
						_g_free0 (_tmp46_);
					}
					if (iter->song->album != NULL) {
						char* _tmp48_;
						strlabel = (_tmp48_ = g_strconcat (strlabel, iter->song->album, NULL), _g_free0 (strlabel), _tmp48_);
					} else {
						char* _tmp49_;
						strlabel = (_tmp49_ = g_strconcat (strlabel, _ ("No Album"), NULL), _g_free0 (strlabel), _tmp49_);
					}
					gtk_label_set_markup (but_label, _tmp50_ = g_markup_printf_escaped ("<b>%s</b>", strlabel));
					_g_free0 (_tmp50_);
					gtk_label_set_ellipsize (but_label, PANGO_ELLIPSIZE_END);
					gtk_box_pack_start ((GtkBox*) but_hbox, (GtkWidget*) but_label, TRUE, TRUE, (guint) 0);
					gtk_box_pack_start ((GtkBox*) album_hbox, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
					g_signal_connect_data (button, "clicked", (GCallback) __lambda36__gtk_button_clicked, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
					albums++;
					iter = mpd_data_get_next_real (iter, FALSE);
					_g_object_unref0 (button);
					_g_object_unref0 (but_hbox);
					_g_object_unref0 (image);
					_g_object_unref0 (but_label);
					_g_free0 (strlabel);
					block26_data_unref (_data26_);
				}
			}
		}
		if (albums == 0) {
			gtk_object_destroy ((GtkObject*) album_hbox);
			gtk_object_destroy ((GtkObject*) sep2);
		}
		_g_object_unref0 (sep2);
		_g_object_unref0 (album_hbox);
		_g_object_unref0 (label);
		_mpd_data_free0 (list);
		_mpd_data_free0 (data);
	}
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) bottom_hbox, TRUE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self->priv->container, (GtkWidget*) vbox);
	gmpc_plugin_mockup_change_color_style (self, (GtkWidget*) self->priv->container);
	gtk_widget_show_all ((GtkWidget*) self->priv->container);
	_g_free0 (checksum);
	_g_object_unref0 (vbox);
	_g_object_unref0 (hbox);
	_g_object_unref0 (ali);
	_g_object_unref0 (album_image);
	_g_object_unref0 (artist_image);
	_g_object_unref0 (info_vbox);
	_g_object_unref0 (sep);
	_g_object_unref0 (hboxje);
	_g_object_unref0 (bottom_hbox);
	_g_object_unref0 (metadata_vbox);
	block19_data_unref (_data19_);
}


static void gmpc_plugin_mockup_update_not_playing (GmpcPluginMockup* self) {
	GError * _inner_error_;
	char* _tmp0_;
	GtkIconTheme* it;
	GtkIconInfo* info;
	char* path;
	GtkImage* image;
	GtkHBox* hbox;
	GtkLabel* label;
	char* _tmp3_;
	GtkAlignment* ali;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	gmpc_plugin_mockup_clear (self);
	self->priv->song_checksum = (_tmp0_ = NULL, _g_free0 (self->priv->song_checksum), _tmp0_);
	it = _g_object_ref0 (gtk_icon_theme_get_default ());
	info = gtk_icon_theme_lookup_icon (it, "gmpc", 150, 0);
	path = g_strdup (gtk_icon_info_get_filename (info));
	image = NULL;
	if (path != NULL) {
		{
			GdkPixbuf* pb;
			GtkImage* _tmp1_;
			pb = gdk_pixbuf_new_from_file_at_scale (path, 150, 150, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch10_g_error;
			}
			image = (_tmp1_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_pixbuf (pb)), _g_object_unref0 (image), _tmp1_);
			_g_object_unref0 (pb);
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("gmpc-nowplaying2.vala:870: Failed to load the gmpc logo: %s", e->message);
				_g_error_free0 (e);
				_g_object_unref0 (it);
				_gtk_icon_info_free0 (info);
				_g_free0 (path);
				_g_object_unref0 (image);
				return;
			}
		}
		__finally10:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (it);
			_gtk_icon_info_free0 (info);
			_g_free0 (path);
			_g_object_unref0 (image);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (image == NULL) {
		GtkImage* _tmp2_;
		image = (_tmp2_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("gmpc", GTK_ICON_SIZE_DIALOG)), _g_object_unref0 (image), _tmp2_);
	}
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Gnome Music Player Client")));
	gtk_label_set_selectable (label, TRUE);
	gtk_label_set_markup (label, _tmp3_ = g_strdup_printf ("<span size='%i' weight='bold'>%s</span>", 28 * PANGO_SCALE, _ ("Gnome Music Player Client")));
	_g_free0 (_tmp3_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	ali = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f));
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) hbox);
	gtk_container_add ((GtkContainer*) self->priv->container, (GtkWidget*) ali);
	gmpc_plugin_mockup_change_color_style (self, (GtkWidget*) self->priv->container);
	gtk_widget_show_all ((GtkWidget*) self->priv->container);
	_g_object_unref0 (it);
	_gtk_icon_info_free0 (info);
	_g_free0 (path);
	_g_object_unref0 (image);
	_g_object_unref0 (hbox);
	_g_object_unref0 (label);
	_g_object_unref0 (ali);
}


static void gmpc_plugin_mockup_update (GmpcPluginMockup* self) {
	g_return_if_fail (self != NULL);
	switch (mpd_player_get_state (connection)) {
		case MPD_STATUS_STATE_PLAY:
		case MPD_STATUS_STATE_PAUSE:
		{
			g_debug ("gmpc-nowplaying2.vala:902: Update playing");
			gmpc_plugin_mockup_update_playing (self);
			break;
		}
		default:
		{
			g_debug ("gmpc-nowplaying2.vala:906: update not playing");
			gmpc_plugin_mockup_update_not_playing (self);
			break;
		}
	}
}


static void gmpc_plugin_mockup_select_now_playing_browser (GmpcPluginMockup* self, GtkImageMenuItem* item) {
	GtkTreeView* tree;
	GtkTreeSelection* sel;
	GtkTreePath* path;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	tree = playlist3_get_category_tree_view ();
	sel = _g_object_ref0 (gtk_tree_view_get_selection (tree));
	path = gtk_tree_row_reference_get_path (self->priv->np_ref);
	if (path != NULL) {
		gtk_tree_selection_select_path (sel, path);
	}
	_g_object_unref0 (sel);
	_gtk_tree_path_free0 (path);
}


static void _gmpc_plugin_mockup_select_now_playing_browser_gtk_menu_item_activate (GtkImageMenuItem* _sender, gpointer self) {
	gmpc_plugin_mockup_select_now_playing_browser (self, _sender);
}


static gint gmpc_plugin_mockup_real_browser_add_go_menu (GmpcPluginBrowserIface* base, GtkMenu* menu) {
	GmpcPluginMockup * self;
	gint result;
	self = (GmpcPluginMockup*) base;
	g_return_val_if_fail (menu != NULL, 0);
	if (gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self)) {
		GtkImageMenuItem* item;
		GtkImage* _tmp0_;
		item = g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_ ("Now Playing")));
		gtk_image_menu_item_set_image (item, (GtkWidget*) (_tmp0_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("media-audiofile", GTK_ICON_SIZE_MENU))));
		_g_object_unref0 (_tmp0_);
		g_signal_connect_object ((GtkMenuItem*) item, "activate", (GCallback) _gmpc_plugin_mockup_select_now_playing_browser_gtk_menu_item_activate, self, 0);
		gtk_widget_add_accelerator ((GtkWidget*) item, "activate", gtk_menu_get_accel_group (menu), (guint) 0x069, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
		gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
		result = 1;
		_g_object_unref0 (item);
		return result;
	}
	result = 0;
	return result;
}


GmpcPluginMockup* gmpc_plugin_mockup_construct (GType object_type) {
	GmpcPluginMockup * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GmpcPluginMockup* gmpc_plugin_mockup_new (void) {
	return gmpc_plugin_mockup_construct (GMPC_PLUGIN_TYPE_MOCKUP);
}


static void _gmpc_plugin_mockup_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* mi, ChangedStatusType what, gpointer self) {
	gmpc_plugin_mockup_status_changed (self, _sender, mi, what);
}


static void _lambda37_ (MpdObj* source, gint connect, GmpcPluginMockup* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (source != NULL);
	if (connect == 0) {
		_tmp0_ = self->priv->paned != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gmpc_plugin_mockup_update_not_playing (self);
	}
}


static void __lambda37__gmpc_connection_connection_changed (GmpcConnection* _sender, MpdObj* mi, gint connect, gpointer self) {
	_lambda37_ (mi, connect, self);
}


static GObject * gmpc_plugin_mockup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcPluginMockup * self;
	parent_class = G_OBJECT_CLASS (gmpc_plugin_mockup_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_PLUGIN_MOCKUP (obj);
	{
		char* background;
		char* foreground;
		((GmpcPluginBase*) self)->plugin_type = 2 | 8;
		g_signal_connect_object (gmpcconn, "status-changed", (GCallback) _gmpc_plugin_mockup_status_changed_gmpc_connection_status_changed, self, 0);
		g_signal_connect_object (gmpcconn, "connection-changed", (GCallback) __lambda37__gmpc_connection_connection_changed, self, 0);
		background = cfg_get_single_value_as_string_with_default (config, "Now Playing", "background-color", "#000");
		foreground = cfg_get_single_value_as_string_with_default (config, "Now Playing", "foreground-color", "#FFF");
		gdk_color_parse (background, &self->priv->background);
		gdk_color_parse (foreground, &self->priv->foreground);
		_g_free0 (background);
		_g_free0 (foreground);
	}
	return obj;
}


static void gmpc_plugin_mockup_class_init (GmpcPluginMockupClass * klass) {
	gmpc_plugin_mockup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcPluginMockupPrivate));
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = gmpc_plugin_mockup_real_get_version;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = gmpc_plugin_mockup_real_get_name;
	GMPC_PLUGIN_BASE_CLASS (klass)->set_enabled = gmpc_plugin_mockup_real_set_enabled;
	GMPC_PLUGIN_BASE_CLASS (klass)->save_yourself = gmpc_plugin_mockup_real_save_yourself;
	G_OBJECT_CLASS (klass)->constructor = gmpc_plugin_mockup_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_plugin_mockup_finalize;
}


static void gmpc_plugin_mockup_gmpc_plugin_browser_iface_interface_init (GmpcPluginBrowserIfaceIface * iface) {
	gmpc_plugin_mockup_gmpc_plugin_browser_iface_parent_iface = g_type_interface_peek_parent (iface);
	iface->browser_add = gmpc_plugin_mockup_real_browser_add;
	iface->browser_selected = gmpc_plugin_mockup_real_browser_selected;
	iface->browser_unselected = gmpc_plugin_mockup_real_browser_unselected;
	iface->browser_add_go_menu = gmpc_plugin_mockup_real_browser_add_go_menu;
}


static void gmpc_plugin_mockup_instance_init (GmpcPluginMockup * self) {
	self->priv = GMPC_PLUGIN_MOCKUP_GET_PRIVATE (self);
	self->priv->theme_colors = (gboolean) cfg_get_single_value_as_int_with_default (config, "Now Playing", "use-theme-color", 1);
	self->priv->title_color = cfg_get_single_value_as_string_with_default (config, "Now Playing", "title-color", "#4d90dd");
	self->priv->item_color = cfg_get_single_value_as_string_with_default (config, "Now Playing", "item-color", "#304ab8");
	self->priv->bitrate_label = NULL;
	self->priv->np_ref = NULL;
	self->priv->paned = NULL;
	self->priv->container = NULL;
	self->priv->selected = FALSE;
	self->priv->song_checksum = NULL;
}


static void gmpc_plugin_mockup_finalize (GObject* obj) {
	GmpcPluginMockup * self;
	self = GMPC_PLUGIN_MOCKUP (obj);
	_g_free0 (self->priv->title_color);
	_g_free0 (self->priv->item_color);
	_g_object_unref0 (self->priv->bitrate_label);
	_gtk_tree_row_reference_free0 (self->priv->np_ref);
	_g_object_unref0 (self->priv->paned);
	_g_object_unref0 (self->priv->container);
	_g_free0 (self->priv->song_checksum);
	G_OBJECT_CLASS (gmpc_plugin_mockup_parent_class)->finalize (obj);
}


GType gmpc_plugin_mockup_get_type (void) {
	static GType gmpc_plugin_mockup_type_id = 0;
	if (gmpc_plugin_mockup_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcPluginMockupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_plugin_mockup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcPluginMockup), 0, (GInstanceInitFunc) gmpc_plugin_mockup_instance_init, NULL };
		static const GInterfaceInfo gmpc_plugin_browser_iface_info = { (GInterfaceInitFunc) gmpc_plugin_mockup_gmpc_plugin_browser_iface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gmpc_plugin_mockup_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "GmpcPluginMockup", &g_define_type_info, 0);
		g_type_add_interface_static (gmpc_plugin_mockup_type_id, GMPC_PLUGIN_TYPE_BROWSER_IFACE, &gmpc_plugin_browser_iface_info);
	}
	return gmpc_plugin_mockup_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




