/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "gtklabel-utils.h"

#include <glib/gprintf.h>


static GtkWidget *
gtk_label_new_vprintf (const gchar *format,
		       va_list      args)
{
  GtkWidget *label;
  gchar *tmp;
  gint len;

  len = g_vasprintf (&tmp, format, args);

  label = gtk_label_new (tmp);

  g_free (tmp);

  return label;
}

static void
gtk_label_set_text_vprintf (GtkLabel    *label,
			    const gchar *format,
			    va_list      args)
{
  gchar *tmp;
  gint len;

  len = g_vasprintf (&tmp, format, args);

  gtk_label_set_text (label, tmp);

  g_free (tmp);
}

static void
gtk_label_set_markup_vprintf (GtkLabel    *label,
			      const gchar *format,
			      va_list      args)
{
  gchar *tmp;
  gint len;

  len = g_vasprintf (&tmp, format, args);

  gtk_label_set_markup (label, tmp);

  g_free (tmp);
}

GtkWidget *
gtk_label_new_printf (const gchar *format,
		      ...)
{
  GtkWidget *label;
  va_list args;

  va_start (args, format);

  label = gtk_label_new_vprintf (format, args);

  va_end (args);

  return label;
}

void
gtk_label_set_text_printf (GtkLabel    *label,
			   const gchar *format,
			   ...)
{
  va_list args;

  g_return_if_fail (label != NULL);
  g_return_if_fail (GTK_IS_LABEL (label));


  va_start (args, format);

  gtk_label_set_text_vprintf (label, format, args);

  va_end (args);
}

void
gtk_label_set_markup_printf (GtkLabel    *label,
			     const gchar *format,
			     ...)
{
  va_list args;

  g_return_if_fail (label != NULL);
  g_return_if_fail (GTK_IS_LABEL (label));


  va_start (args, format);

  gtk_label_set_markup_vprintf (label, format, args);

  va_end (args);
}
