/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#ifndef __G_NODE_UTILS_H__
#define __G_NODE_UTILS_H__


#include <glib.h>


G_BEGIN_DECLS



#define g_node_parent(node)	((node) ? ((GNode*)(node))->parent : NULL)
#define g_node_children(node)	g_node_first_child (node)


typedef GNodeForeachFunc GNodeForallFunc;

  
void g_node_remove_link        (GNode           *node);
void g_node_unparent           (GNode           *node);
void g_node_reparent           (GNode           *node,
				GNode           *new_parent);

void g_node_forall_subtree     (GNode		*top,
				GNodeForallFunc	 func,
				gpointer	 user_data);
void g_node_forall_siblings    (GNode		*node,
				GNodeForallFunc	 func,
				gpointer	 user_data);
void g_node_forall_children    (GNode		*node,
				GNodeForallFunc	 func,
				gpointer	 user_data);
void g_node_forall_ancestors   (GNode		*node,
				GNodeForallFunc	 func,
				gpointer	 user_data);
void g_node_forall_descendants (GNode		*node,
				GNodeForallFunc	 func,
				gpointer	 user_data);
void g_node_forall_depth       (GNode		*node,
				guint            depth,
				GNodeForallFunc	 func,
				gpointer	 user_data);

void g_node_forall_subtree_data	    (GNode    *top,
				     GFunc     func,
				     gpointer  user_data);
void g_node_forall_siblings_data    (GNode    *node,
				     GFunc     func,
				     gpointer  user_data);
void g_node_forall_children_data    (GNode    *node,
				     GFunc     func,
				     gpointer  user_data);
void g_node_forall_ancestors_data   (GNode    *node,
				     GFunc     func,
				     gpointer  user_data);
void g_node_forall_descendants_data (GNode    *node,
				     GFunc     func,
				     gpointer  user_data);
void g_node_forall_depth_data       (GNode    *node,
				     guint     depth,
				     GFunc     func,
				     gpointer  user_data);



G_END_DECLS


#endif /* __G_NODE_UTILS_H__ */
