/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "gtkvmpaned.h"

static void gtk_vmpaned_class_init (GtkVMPanedClass *klass);
static void gtk_vmpaned_init       (GtkVMPaned	    *vmpaned);



static GtkMPanedClass *parent_class = NULL;


GType
gtk_vmpaned_get_type (void)
{
  static GType vmpaned_type = 0;

  if (!vmpaned_type)
    {
      static const GTypeInfo vmpaned_info =
      {
	sizeof (GtkVMPanedClass),
	NULL,		/* base_init */
	NULL,		/* base_finalize */
	(GClassInitFunc) gtk_vmpaned_class_init,
	NULL,		/* class_finalize */
	NULL,		/* class_data */
	sizeof (GtkVMPaned),
	0,		/* n_preallocs */
	(GInstanceInitFunc) gtk_vmpaned_init,
        NULL,           /* value_table */
      };

      vmpaned_type = g_type_register_static (GTK_TYPE_MPANED,
					     "GtkVMPaned",
					     &vmpaned_info, 0);
    }

  return vmpaned_type;
}

static void
gtk_vmpaned_class_init (GtkVMPanedClass *klass)
{
  GObjectClass   *gobject_class;
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GtkContainerClass *container_class;

  gobject_class = G_OBJECT_CLASS (klass);
  object_class = (GtkObjectClass*) klass;
  widget_class = (GtkWidgetClass*) klass;
  container_class = (GtkContainerClass*) klass;

  parent_class = g_type_class_peek_parent (klass);
}

static void
gtk_vmpaned_init (GtkVMPaned *vmpaned)
{
  GTK_MPANED (vmpaned)->orientation = GTK_ORIENTATION_VERTICAL;
}

GtkWidget*
gtk_vmpaned_new (void)
{
  return g_object_new (GTK_TYPE_VMPANED, NULL);
}
