/*
 * Copyright (C) 2000-2010  Innocent De Marchi
 * email: tangram.peces@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <QtGui>
#include <math.h>

#include "conjuntpeces.h"
#include "comuns/constants.h"
#include "funcions.h"


ConjuntPeces::ConjuntPeces()
{
   // arrayPeces.resize(0);
    escala=ESCALA_GENERAL;
    //cream el tangram clàssic
    creaConjunt(TIPUS_TANGRAM_T7_CLASSIC,55.0);
}


ConjuntPeces::ConjuntPeces(int tipusTangram)
{
   // arrayPeces.resize(0);
    escala=ESCALA_GENERAL;
    creaConjunt(tipusTangram,55.0);
}


ConjuntPeces::ConjuntPeces(int tipusTangram,double pescala){
   // arrayPeces.resize(0);
    escala= pescala;
    creaConjunt(tipusTangram,escala);
}

/*
Col·loca les peces a l'atzar
*/
void ConjuntPeces::colocaPecesAtzar(){
 for(int i=0;i<=arrayPeces.size()-1;i++){
       arrayPeces[i]->colocaPecaAtzar();
       arrayPeces[i]->setSelected(false);
       }
}

/*
Col·loca les peces segons les dades passades
*/
void ConjuntPeces::colocaPeces(QString dades){
  if (dades.isNull() || dades.isEmpty()){
      return;
  }
  else {
  QStringList list1 = dades.split(" ");
  int tPeca,simPeca;
  float pX,pY,angle;
  float pescala=list1.at(0).toFloat()/escala;

    for(int i=0;i<=arrayPeces.size()-1;i++){
      tPeca=list1.at(1+i*5).toInt();
      pX=list1.at(2+i*5).toFloat()/pescala;
      pY=list1.at(3+i*5).toFloat()/pescala;
      angle=list1.at(4+i*5).toFloat();
      simPeca=list1.at(5+i*5).toInt();

     //arrayPeces[i]->creaPeca(tPeca);
     // 25/02/11 Canvis en la creació de peces
    // arrayPeces[i]->creaPeca(tPeca,dadesPeces.value(tPeca-1));
     arrayPeces[i]->creaPeca(tPeca);
     arrayPeces[i]->setPos(pX,pY);
     if (simPeca==1){
        arrayPeces[i]->simetriaPeca();
        }
     arrayPeces[i]->setAngleRotacio(angle);
     arrayPeces[i]->actualitzaPeca();
    }
   centraFiguraScene();
  }
}

void ConjuntPeces::colocaPeca(QString dades, int indexPeca,QPointF punt){
if (dades.isNull() || dades.isEmpty()){
      return;
  }
  else {
  QStringList list1 = dades.split(" ");
  int tPeca,simPeca;
  float pX,pY,angle;
      tPeca=list1.at(0).toInt();
      pX=punt.x()+list1.at(1).toFloat();
      pY=punt.y()+list1.at(2).toFloat();
      angle=list1.at(3).toFloat();
      simPeca=list1.at(4).toInt();
     // 25/02/11 Canvis en la creació de peces
    // arrayPeces[indexPeca]->creaPeca(tPeca,dadesPeces.value(tPeca-1));
     arrayPeces[indexPeca]->creaPeca(tPeca);
     arrayPeces[indexPeca]->setPos(pX,pY);
     if (simPeca==1){
        arrayPeces[indexPeca]->simetriaPeca();
        }
     arrayPeces[indexPeca]->setAngleRotacio(angle);
     arrayPeces[indexPeca]->actualitzaPeca();
  }
}
/*
  Recol·loca el conjunt de peces fent coincidir el seu
  vertexSuperiorEsquerra amb el punt passat per paràmetre
  */
void ConjuntPeces::recolocaPeces(QPointF punt){
    QPointF vertexSupEsq=vertexSuperiorEsquerra();
    for(int i=0;i<=arrayPeces.size()-1;i++){
      arrayPeces[i]->setPos(arrayPeces[i]->pos()-(vertexSupEsq-punt));
    }
}


void ConjuntPeces::simetriaVertical(){
//Cal assegurar-se que la figura està centrada
centraFiguraScene();
float valor=arrayPeces[0]->scene()->height()/2 ;
for(int i=0;i<=arrayPeces.size()-1;i++){
    arrayPeces[i]->setPos(2*valor-arrayPeces[i]->pos().x(),
                                      arrayPeces[i]->pos().y());
    arrayPeces[i]->simetriaPeca();
  }
centraFiguraScene();
}

void ConjuntPeces::simetriaHoritzontal(){
//Cal assegurar-se que la figura està centrada
centraFiguraScene();
float valor=arrayPeces[0]->scene()->height()/2 ;
for(int i=0;i<=arrayPeces.size()-1;i++){
    arrayPeces[i]->setPos(arrayPeces[i]->pos().x(),
                                      2*valor-arrayPeces[i]->pos().y());
    arrayPeces[i]->rotaPeca(PI);
    arrayPeces[i]->simetriaPeca();
  }
centraFiguraScene();
}


/**
* Retorna una cadena amb les coordenades de les peces
* per tal de desar-les a un arxiu de text
*/
QString ConjuntPeces::coordenadesFigura(){
  QPointF verSuperiorEsquerra;
  verSuperiorEsquerra=vertexSuperiorEsquerra();
  QString dadesFigura=QString("%1 ").arg(escala);
  for(int i=0;i<=arrayPeces.size()-1;i++){
    dadesFigura=dadesFigura+
        arrayPeces[i]->cadenaPropietatsPeca(verSuperiorEsquerra);
    }
 return dadesFigura;
}

/**
* Retorna les coordenades (en forma de Point), del vèrtex
* superior-esquerra de les Peces passades
* per paràmetre
*/
QPointF ConjuntPeces::vertexSuperiorEsquerra(){
  QPointF verSuperiorEsquerra(10000.0,10000.0);
  QVector<QPointF> pSolucio;
  for(int i=0;i<=arrayPeces.size()-1;i++){
     arrayPeces[i]->puntsSolucio(pSolucio,1.0);
     for(int j=0;j<=pSolucio.size()-1;j++){
        verSuperiorEsquerra.setX(qMin(pSolucio[j].x(),
                                   verSuperiorEsquerra.rx()));
        verSuperiorEsquerra.setY(qMin(pSolucio[j].y(),
                                   verSuperiorEsquerra.ry()));
     }
  }
      return verSuperiorEsquerra;
 }


QPointF ConjuntPeces::vertexInferiorDreta(){
  QPointF verInferiorDreta(0.0,0.0);
  QVector<QPointF> pSolucio;
  for(int i=0;i<=arrayPeces.size()-1;i++){
     arrayPeces[i]->puntsSolucio(pSolucio,1.0);
     for(int j=0;j<=pSolucio.size()-1;j++){
        verInferiorDreta.setX(qMax(pSolucio[j].x(),
                                   verInferiorDreta.rx()));
        verInferiorDreta.setY(qMax(pSolucio[j].y(),
                                   verInferiorDreta.ry()));
     }
  }
 return verInferiorDreta;
 }

 /**
* Centra la figura en el panell
*/
void ConjuntPeces::centraFiguraScene(){
    QPointF centreScene=arrayPeces[0]->scene()->sceneRect().center();
    QPointF centreFigura=QRectF(vertexSuperiorEsquerra(),vertexInferiorDreta()).center();
    QPointF vectorPosicio=centreScene-centreFigura;
    for(int i=0;i<=arrayPeces.size()-1;i++){
        arrayPeces[i]->setPos(arrayPeces[i]->scenePos()+vectorPosicio);
    }
}

QRectF ConjuntPeces::rectangleFigura(){
 // QRectF rectFigura=QRectF(vertexSuperiorEsquerra(),vertexInferiorDreta());
  return QRectF(vertexSuperiorEsquerra(),vertexInferiorDreta());
}


/*
Color de les peces del conjunt
*/
void ConjuntPeces::colorPecesConjunt(QColor color){
  for(int i=0;i<=arrayPeces.size()-1;i++){
       arrayPeces[i]->setColorPeca(color);
       arrayPeces[i]->setColorLimits(color);
       }
}

/*
Fa les tasques necessàries pel conjunt de peces de mostra
*/
void ConjuntPeces::conjuntDeMostra(){
   //posam el color a negre
 for(int i=0;i<=arrayPeces.size()-1;i++){
       arrayPeces[i]->setColorPeca(Qt::black);
       arrayPeces[i]->setColorLimits(Qt::black);
       arrayPeces[i]->pecaMostra=true;
       arrayPeces[i]->setZValue(-1);
       }
}

/*
Mostra la solució
*/
void ConjuntPeces::conjuntSolucio(){
 conjuntVisible(true);
 centraFiguraScene();
 for(int i=0;i<=arrayPeces.size()-1;i++){
       arrayPeces[i]->solucio=true;
       arrayPeces[i]->actualitzaPeca();
       }
}

/*
Posa la figura (resolta) en color verd
*/
void ConjuntPeces::conjuntFiguraResolta(){
 for(int i=0;i<=arrayPeces.size()-1;i++){
       arrayPeces[i]->setColorPeca(Qt::green);
       arrayPeces[i]->setColorLimits(Qt::green);
       }
}
/*
Controla si el conjunt és visible
*/
void ConjuntPeces::conjuntVisible(bool visible){
 for(int i=0;i<=arrayPeces.size()-1;i++){
       arrayPeces[i]->pecaVisible=visible;
       arrayPeces[i]->actualitzaPeca();
       }
}


/*
Crea un conjunt segons els paràmetres passats
*/
void ConjuntPeces::creaConjunt(int ptipusTangram, double pescala){
  QStringList dadesTangram;
  /* 14/02/11
     Llista amb les dades per a la construcció de cada joc de tangram
     -L'ordre a la llista és el codi del tangram-1
     -Nombre de peces del joc
     -Codis de cada peça
   Cal tenir present que l'ordre de creación de les peces és important
   que coincideixi amb l'ordre en què estan a l'arxiu de dades de
   les figures.
    NOU TANGRAM 3 */
  dadesTangram.append("7,1,2,2,3,4,4,5"); //tangram clàssic                                       codi 1
  dadesTangram.append("5,7,2,4,6,6"); //Tangram 5                                                 codi 2
  dadesTangram.append("6,10,3,3,11,8,9"); //Tangram 6 I                                           codi 3
  dadesTangram.append("7,12,1,2,2,3,3,8"); //Tangram de Fletcher (Pitàgores)                      codi 4
  dadesTangram.append("7,3,3,13,14,15,15,16"); //Tangram del xinès també Tangram Pitagòric    codi 5
  dadesTangram.append("7,17,1,2,3,3,5,13"); //Tangram de la saviesa Chie-No-Ita                   codi 6
  dadesTangram.append("8,1,2,2,3,3,3,13,14"); //Tangram 8                                         codi 7
  dadesTangram.append("9,18,18,18,19,19,19,19,20,20"); //Tangram 9                                codi 8
  dadesTangram.append("10,21,21,22,22,23,23,1,2,2,17"); //Tangram 10                              codi 9
  dadesTangram.append("11,24,24,25,25,23,23,23,22,22,22,22"); //Tangram 11                        codi 10
  dadesTangram.append("12,1,2,2,2,3,13,15,26,26,26,27,27"); //Tangram rus                         codi 11
  dadesTangram.append("13,1,1,1,2,2,2,2,2,2,2,2,2,2"); //Tangram 13                               codi 12
  dadesTangram.append("14,1,1,2,2,2,2,3,3,4,4,4,4,5,5"); //Tangram 14                             codi 13
  dadesTangram.append("3,28,29,30"); //Tangram de Brügner                                         codi 14
  dadesTangram.append("6,31,32,34,35,36,21"); //Tangram Hexagrama                                 codi 15
  dadesTangram.append("9,37,37,38,38,39,39,40,40,41"); //Tangram de l'ou                          codi 16
  dadesTangram.append("9,42,42,42,43,43,13,1,2,5"); //Tangram del cor                             codi 17
  dadesTangram.append("14,44,45,45,46,47,48,48,49,50,51,52,53,54,55");
  ///Tangram Stomachion o Luculus Archimedius                              codi 18
  dadesTangram.append("4,2,56,58,59"); //Tangram de 4 peces I                                     codi 19
  dadesTangram.append("10,60,60,60,60,61,61,62,62,63,63"); //Tangram circular I                   codi 20
  dadesTangram.append("7,64,65,66,21,21,24,24"); //Tangram 7 I                                    codi 21
  //dadesTangram.append("8,67,67,67,68,69,65,64,22"); //Tangram circular de 8 peces CII             codi 22
  dadesTangram.append("8,22,64,65,67,67,67,68,69"); //Tangram circular de 8 peces CII             codi 22
  dadesTangram.append("6,70,71,72,1,5,3"); //Tangram 6 II                                         codi 23
  dadesTangram.append("7,73,1,5,3,2,70,13"); //Tangram 7 II Revathi                               codi 24
  dadesTangram.append("5,3,3,13,16,12"); //Tangram 5 I Regulus                                    codi 25
  dadesTangram.append("7,3,3,13,12,2,5,5"); //Tangram 7 Heptex                                    codi 26
  dadesTangram.append("5,78,74,75,76,77"); //Tangram de Sam Lloyds                                codi 27
  dadesTangram.append("9,79,79,80,80,81,82,83,84,84"); //Tangram "los nueve tangram"              codi 28
  dadesTangram.append("10,74,74,74,74,74,76,76,76,76,76"); //Tangram Egipci                       codi 29
  dadesTangram.append("4,3,85,85,86"); //Tangram de 4 peces II                                    codi 30
  dadesTangram.append("14,87,88,89,90,90,91,91,91,92,93,94,95,3,74");
                        //Tangram Stomachion rectangular                                          codi 31
  dadesTangram.append("11,54,45,46,47,48,46,76,90,53,45,48");
  //Tangram Stomach (modificació de Stomachion)                                                   codi 32
  dadesTangram.append("10,15,15,15,15,3,3,3,3,3,3"); //Tangram Elzzup (10 peces)                  codi 33
  dadesTangram.append("8,31,32,34,35,36,21,33,57"); //Tangram dels vuit elements (8 peces)        codi 34
  dadesTangram.append("12,1,2,2,2,3,13,15,26,96,96,97,97"); //Tangram 12 peces             codi 35
  dadesTangram.append("5,3,1,16,4,98"); //Tangram 5 II                                     codi 36
  dadesTangram.append("8,3,3,13,14,15,15,99,99"); //Tangram Armonigrama                       codi 37
  dadesTangram.append("8,3,3,13,1,2,2,2,12"); //Tangramrectangular 8 peces                    codi 38

//dimensionam l'array de les peces
QStringList dadesDelTangram=dadesTangram.value(ptipusTangram-1).split(",");
arrayPeces.resize(dadesDelTangram.value(0).toInt());
//escales especials
if (ptipusTangram==11){pescala=FACTOR_TR*pescala;}  //Tangram rus
if (ptipusTangram==31){pescala=0.9*pescala;}  //Tangram Stomachion rectangular
if (ptipusTangram==28){pescala=FACTOR_T9T*pescala;};//Tangram "los nueve tangram"
if (ptipusTangram==35){pescala=1.5*pescala;};//Tangram 5 II
if (ptipusTangram==38){pescala=1.3*pescala;};//Tangram rectangular

//cream i carregam les peces
for(int i=0;i<=arrayPeces.size()-1;i++){
    //especial per a dues peces de Tangram Stomach
    if(  (ptipusTangram==TIPUS_TANGRAM_STOMACH) &&
       (  (dadesDelTangram.value(i+1).toInt()==76 ) || (dadesDelTangram.value(i+1).toInt()==90 ) )) {
        arrayPeces.replace(i, new Peca(dadesDelTangram.value(i+1).toInt(),escalaStomach*pescala) ) ;
   }
   else
   arrayPeces.replace(i, new Peca(dadesDelTangram.value(i+1).toInt(),pescala) ) ;
}
 //emplenam la propietat conjuntDePeces
    for(int i=0;i<=arrayPeces.size()-1;i++){
        arrayPeces[i]->conjuntDePeces=this;
        arrayPeces[i]->indexEnElConjunt=i;
    }

/* 14/02/11
if(arrayPeces.size()>0){ arrayPeces.clear();}
    switch (ptipusTangram){
     case TIPUS_TANGRAM_TB:
     //Tangram de Brugner
        arrayPeces.resize(3);
      break;
     case TIPUS_TANGRAM_T4:
     case TIPUS_TANGRAM_T4II:
     //Tangram de 4 peces
        arrayPeces.resize(4);
      break;
     case TIPUS_TANGRAM_T5:
     case TIPUS_TANGRAM_TREGULUS:
     case TIPUS_TANGRAM_TSL:
        arrayPeces.resize(5);
      break;
     case TIPUS_TANGRAM_T6:
     case TIPUS_TANGRAM_T6II:
     case TIPUS_TANGRAM_TH: //Tangram hexagrama
        arrayPeces.resize(6);
      break;
     case TIPUS_TANGRAM_T7_CLASSIC:
     case TIPUS_TANGRAM_T7I:
     case TIPUS_TANGRAM_T7II:
     case TIPUS_TANGRAM_TF:
     case TIPUS_TANGRAM_THEP:
     case TIPUS_TANGRAM_TX:
     case TIPUS_TANGRAM_TS:
        arrayPeces.resize(7);
      break;
     case TIPUS_TANGRAM_T8:
     case TIPUS_TANGRAM_TCII:
        arrayPeces.resize(8);
      break;
     case TIPUS_TANGRAM_T9:
     case TIPUS_TANGRAM_TOU://Tangram de l'ou
     case TIPUS_TANGRAM_COR://Tangram del cor
     case TIPUS_TANGRAM_T9T:
        arrayPeces.resize(9);
      break;
     case TIPUS_TANGRAM_TE:
     case TIPUS_TANGRAM_T10:
     case  TIPUS_TANGRAM_EL:
     case TIPUS_TANGRAM_TCIRI://tangram circular I
        arrayPeces.resize(10);
      break;
     case TIPUS_TANGRAM_T11:
     case TIPUS_TANGRAM_STOMACH:
        arrayPeces.resize(11);
      break;
     case TIPUS_TANGRAM_TR:
     //Tangram rus
        arrayPeces.resize(12);
      break;
     case TIPUS_TANGRAM_T13:
        arrayPeces.resize(13);
      break;
     case TIPUS_TANGRAM_T14:
     case TIPUS_TANGRAM_STOMACHION:
     case TIPUS_TANGRAM_STOMACHION_II:
        arrayPeces.resize(14);
      break;
     default:
      arrayPeces.resize(7);
      ptipusTangram=TIPUS_TANGRAM_T7_CLASSIC;
       }//final switch

    //ara cream les peces
    creaJocPeces(ptipusTangram,pescala);
    //emplenam la propietat conjuntDePeces
    for(int i=0;i<=arrayPeces.size()-1;i++){
        arrayPeces[i]->conjuntDePeces=this;
        arrayPeces[i]->indexEnElConjunt=i;
    }
*/
 }//final creaConjunt

/* 14/02/11
Crea les peces del conjunt

void ConjuntPeces::creaJocPeces(int ptipusTangram,double pescala){
switch(ptipusTangram){    
    case TIPUS_TANGRAM_TB:
     //Tangram de Brugner
        arrayPeces.replace(0, new Peca(TB_TRIANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(1, new Peca(TB_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(2, new Peca(TB_TRIANGLE_PETIT,pescala) ) ;
      break;
    case TIPUS_TANGRAM_T4:
     //Tangram de 4 peces
        arrayPeces.replace(0, new Peca(T4_TRAPEZI_GRAN,pescala) ) ;
        arrayPeces.replace(1, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(T4_TRAPEZI_PETIT,pescala) ) ;
        arrayPeces.replace(3, new Peca(T4_PECA_GRAN,pescala) ) ;
      break;
    case TIPUS_TANGRAM_T4II:
     //Tangram de 4 II peces
        arrayPeces.replace(0, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(1, new Peca(T4II_TRAPEZI_1,pescala) ) ;
        arrayPeces.replace(2, new Peca(T4II_TRAPEZI_1,pescala) ) ;
        arrayPeces.replace(3, new Peca(T4II_TRAPEZI_2,pescala) ) ;
      break;
    case TIPUS_TANGRAM_T5:
        arrayPeces.replace(0, new Peca(T5_TRAPEZI,pescala) ) ;
        arrayPeces.replace(1, new Peca(T5_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(T5_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(3, new Peca(T5_TRIANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(4, new Peca(T5_TRIANGLE_GRAN,pescala) ) ;
     break;
    case TIPUS_TANGRAM_TSL:
        arrayPeces.replace(0, new Peca(TSL_QUADRAT,pescala) ) ;
        arrayPeces.replace(1, new Peca(TSL_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(TSL_TRIANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(3, new Peca(TSL_TRAPEZI,pescala) ) ;
        arrayPeces.replace(4, new Peca(TSL_HEXAGON,pescala) ) ;

     break;
    case TIPUS_TANGRAM_TREGULUS:
        //Tangram 5 Regulus
        arrayPeces.replace(0, new Peca(TX_TRIANGLE,pescala) ) ;
        arrayPeces.replace(1, new Peca(TX_TRIANGLE,pescala) ) ;
        arrayPeces.replace(2, new Peca(TX_TRAPEZI_MITJA,pescala) ) ;
        arrayPeces.replace(3, new Peca(TX_PENTAGON,pescala) ) ;
        arrayPeces.replace(4, new Peca(TF_TRAPEZI,pescala) ) ;
       break;

     case TIPUS_TANGRAM_TH: //Tangram hexagrama
        arrayPeces.replace(0, new Peca(TH_ROMBE_GRAN,pescala) ) ;
        arrayPeces.replace(1, new Peca(TH_ROMBE_PETIT,pescala) ) ;
   //El comentat és correcte, però les dades de les figures tenen l'altre
  //   arrayPeces.replace(2, new Peca(TH_TRIANGLE_EQUILATER_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(T10_TRIANGLE_EQUILATER_GRAN,pescala) ) ;
        arrayPeces.replace(3, new Peca(TH_TRIANGLE_EQUILATER_MINUSCUL,pescala) ) ;
        arrayPeces.replace(4, new Peca(TH_HEXAGON,pescala) ) ;
        arrayPeces.replace(5, new Peca(TH_TRAPEZI,pescala) ) ;
      break;
    case TIPUS_TANGRAM_T6:
        arrayPeces.replace(0, new Peca(T6_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(1, new Peca(T6_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(2, new Peca(T6_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(3, new Peca(T6_TRIANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(4, new Peca(T6_QUADRAT,pescala) ) ;
        arrayPeces.replace(5, new Peca(T6_TRAPEZI,pescala) ) ;
     break;
    case TIPUS_TANGRAM_T6II:
        arrayPeces.replace(0, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(1, new Peca(T7_TRAPEZI,pescala) ) ;
        arrayPeces.replace(2, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(3, new Peca(T6II_DOS_TRIANGLES,pescala) ) ;
        arrayPeces.replace(4, new Peca(T6II_TRIANGLE_TRAPEZI,pescala) ) ;
        arrayPeces.replace(5, new Peca(T6II_QUADRAT_TRIANGLE,pescala) ) ;
     break;
    case TIPUS_TANGRAM_T7I:
        //Tangram 7 I (Ivy japones)
        arrayPeces.replace(0, new Peca(T10_TRIANGLE_EQUILATER_GRAN,pescala) ) ;
        arrayPeces.replace(1, new Peca(T10_TRIANGLE_EQUILATER_GRAN,pescala) ) ;
        arrayPeces.replace(2, new Peca(T11_TRIANGLE_RECTANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(3, new Peca(T11_TRIANGLE_RECTANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(4, new Peca(T7I_TRAPEZI,pescala) ) ;
        arrayPeces.replace(5, new Peca(T7I_PARALELOGRAM,pescala) ) ;
        arrayPeces.replace(6, new Peca(T7I_PENTAGON,pescala) ) ;
       break;
    case TIPUS_TANGRAM_T7II:
        //Tangram 7 II (Revathi)
        arrayPeces.replace(0, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(1, new Peca(T7_TRAPEZI,pescala) ) ;
        arrayPeces.replace(2, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(3, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(4, new Peca(T6II_DOS_TRIANGLES,pescala) ) ;
        arrayPeces.replace(5, new Peca(TX_TRAPEZI_MITJA,pescala) ) ;
        arrayPeces.replace(6, new Peca(T7II_TRAPEZI,pescala) ) ;
       break;
    case TIPUS_TANGRAM_TF:
        //Tangram de Fletcher
        arrayPeces.replace(0, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(1, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(3, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(4, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(5, new Peca(T6_QUADRAT,pescala) ) ;
        arrayPeces.replace(6, new Peca(TF_TRAPEZI,pescala) ) ;
       break;
    case TIPUS_TANGRAM_THEP:
        //Tangram Heptex
        arrayPeces.replace(0, new Peca(TX_TRIANGLE,pescala) ) ;
        arrayPeces.replace(1, new Peca(TX_TRIANGLE,pescala) ) ;
        arrayPeces.replace(2, new Peca(TX_TRAPEZI_MITJA,pescala) ) ;
        arrayPeces.replace(3, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(4, new Peca(TF_TRAPEZI,pescala) ) ;
        arrayPeces.replace(5, new Peca(T7_TRAPEZI,pescala) ) ;
        arrayPeces.replace(6, new Peca(T7_TRAPEZI,pescala) ) ;
       break;
    case TIPUS_TANGRAM_TX:
        //Tangram del xinès
        arrayPeces.replace(0, new Peca(TX_TRIANGLE,pescala) ) ;
        arrayPeces.replace(1, new Peca(TX_TRIANGLE,pescala) ) ;
        arrayPeces.replace(2, new Peca(TX_TRAPEZI_MITJA,pescala) ) ;
        arrayPeces.replace(3, new Peca(TX_TRAPEZI_GRAN,pescala) ) ;
        arrayPeces.replace(4, new Peca(TX_TRAPEZI_PETIT,pescala) ) ;
        arrayPeces.replace(5, new Peca(TX_TRAPEZI_PETIT,pescala) ) ;
        arrayPeces.replace(6, new Peca(TX_PENTAGON,pescala) ) ;
       break;
    case TIPUS_TANGRAM_TS:
        //Tangram de la saviesa
        arrayPeces.replace(0, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(1, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(3, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(4, new Peca(T7_TRAPEZI,pescala) ) ;
        arrayPeces.replace(5, new Peca(TX_TRAPEZI_MITJA,pescala) ) ;
        arrayPeces.replace(6, new Peca(TS_TRAPEZI,pescala) ) ;
       break;
    case TIPUS_TANGRAM_T7_CLASSIC:
        // Tangram clàssic
        arrayPeces.replace(0, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(1, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(3, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(4, new Peca(T7_TRIANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(5, new Peca(T7_TRIANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(6, new Peca(T7_TRAPEZI,pescala) ) ;
       break;
     case TIPUS_TANGRAM_T8:
        arrayPeces.replace(0, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(1, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(3, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(4, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(5, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(6, new Peca(TX_TRAPEZI_MITJA,pescala) ) ;
        arrayPeces.replace(7, new Peca(TX_TRAPEZI_GRAN,pescala) ) ;
      break;
     case TIPUS_TANGRAM_TCII:
        arrayPeces.replace(0, new Peca(T10_TRIANGLE_EQUILATER_PETIT,pescala) ) ;
        arrayPeces.replace(1, new Peca(T7I_TRAPEZI,pescala) ) ;
        arrayPeces.replace(2, new Peca(T7I_PARALELOGRAM,pescala) ) ;
        arrayPeces.replace(3, new Peca(TCII_TRIANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(4, new Peca(TCII_TRIANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(5, new Peca(TCII_TRIANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(6, new Peca(TCII_TRIANGLE_ISOSCELES_ARC,pescala) ) ;
        arrayPeces.replace(7, new Peca(TCII_ARC,pescala) ) ;
      break;
     case TIPUS_TANGRAM_TOU://Tangram de l'ou
        arrayPeces.replace(0, new Peca(TOU_TRIANGLE_RECTANGLE_GRAN_ARC,pescala) ) ;
        arrayPeces.replace(1, new Peca(TOU_TRIANGLE_RECTANGLE_GRAN_ARC,pescala) ) ;
        arrayPeces.replace(2, new Peca(TOU_TRIANGLE_ISOSCELES_ARC,pescala) ) ;
        arrayPeces.replace(3, new Peca(TOU_TRIANGLE_ISOSCELES_ARC,pescala) ) ;
        arrayPeces.replace(4, new Peca(TOU_TRIANGLE_ISOSCELES,pescala) ) ;
        arrayPeces.replace(5, new Peca(TOU_TRIANGLE_ISOSCELES,pescala) ) ;
        arrayPeces.replace(6, new Peca(TOU_TRAPEZI_ARC,pescala) ) ;
        arrayPeces.replace(7, new Peca(TOU_TRAPEZI_ARC,pescala) ) ;
        arrayPeces.replace(8, new Peca(TOU_TRIANGLE_ISOSCELES_PETIT,pescala) ) ;
      break;
     case TIPUS_TANGRAM_COR://Tangram del cor
        arrayPeces.replace(0, new Peca(TCOR_TRIANGLE_ISOSCELES_ARC,pescala) ) ;
        arrayPeces.replace(1, new Peca(TCOR_TRIANGLE_ISOSCELES_ARC,pescala) ) ;
        arrayPeces.replace(2, new Peca(TCOR_TRIANGLE_ISOSCELES_ARC,pescala) ) ;
        arrayPeces.replace(3, new Peca(TCOR_TRIANGLE_ISOSCELES_PETIT_ARC,pescala) ) ;
        arrayPeces.replace(4, new Peca(TCOR_TRIANGLE_ISOSCELES_PETIT_ARC,pescala) ) ;
        arrayPeces.replace(5, new Peca(TX_TRAPEZI_MITJA,pescala) ) ;
        arrayPeces.replace(6, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(7, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(8, new Peca(T7_TRAPEZI,pescala) ) ;
      break;
     case TIPUS_TANGRAM_T9:escalaStomach
        arrayPeces.replace(0, new Peca(T9_TRIANGLE_EQUILATER,pescala) ) ;
        arrayPeces.replace(1, new Peca(T9_TRIANGLE_EQUILATER,pescala) ) ;
        arrayPeces.replace(2, new Peca(T9_TRIANGLE_EQUILATER,pescala) ) ;
        arrayPeces.replace(3, new Peca(T9_TRIANGLE_RECTANGLE,pescala) ) ;
        arrayPeces.replace(4, new Peca(T9_TRIANGLE_RECTANGLE,pescala) ) ;
        arrayPeces.replace(5, new Peca(T9_TRIANGLE_RECTANGLE,pescala) ) ;
        arrayPeces.replace(6, new Peca(T9_TRIANGLE_RECTANGLE,pescala) ) ;
        arrayPeces.replace(7, new Peca(T9_ROMBE,pescala) ) ;
        arrayPeces.replace(8, new Peca(T9_ROMBE,pescala) ) ;
      break;
     case TIPUS_TANGRAM_T9T:
      pescala=FACTOR_T9T*pescala;
        arrayPeces.replace(0, new Peca(T9T_TRIANGLE_ISOSCELES_PETIT,pescala) ) ;
        arrayPeces.replace(1, new Peca(T9T_TRIANGLE_ISOSCELES_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(T9T_TRIANGLE_ISOSCELES_GRAN,pescala) ) ;
        arrayPeces.replace(3, new Peca(T9T_TRIANGLE_ISOSCELES_GRAN,pescala) ) ;
        arrayPeces.replace(4, new Peca(T9T_TRIANGLE_RECTANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(5, new Peca(T9T_TRIANGLE_RECTANGLE_GRAN_1,pescala) ) ;
        arrayPeces.replace(6, new Peca(T9T_TRIANGLE_RECTANGLE_GRAN_2,pescala) ) ;
        arrayPeces.replace(7, new Peca(T9T_TRAPEZI,pescala) ) ;
        arrayPeces.replace(8, new Peca(T9T_TRAPEZI,pescala) ) ;
      break;
      case TIPUS_TANGRAM_T10:
        arrayPeces.replace(0, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(1, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(3, new Peca(TS_TRAPEZI,pescala) ) ;
        arrayPeces.replace(4, new Peca(T10_TRIANGLE_EQUILATER_GRAN,pescala) ) ;
        arrayPeces.replace(5, new Peca(T10_TRIANGLE_EQUILATER_GRAN,pescala) ) ;
        arrayPeces.replace(6, new Peca(T10_TRIANGLE_EQUILATER_PETIT,pescala) ) ;
        arrayPeces.replace(7, new Peca(T10_TRIANGLE_EQUILATER_PETIT,pescala) ) ;
        arrayPeces.replace(8, new Peca(T10_ROMBE,pescala) ) ;
        arrayPeces.replace(9, new Peca(T10_ROMBE,pescala) ) ;
      break;
      case TIPUS_TANGRAM_TE:
        arrayPeces.replace(0, new Peca(TSL_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(1, new Peca(TSL_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(TSL_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(3, new Peca(TSL_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(4, new Peca(TSL_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(5, new Peca(TSL_TRAPEZI,pescala) ) ;
        arrayPeces.replace(6, new Peca(TSL_TRAPEZI,pescala) ) ;
        arrayPeces.replace(7, new Peca(TSL_TRAPEZI,pescala) ) ;
        arrayPeces.replace(8, new Peca(TSL_TRAPEZI,pescala) ) ;
        arrayPeces.replace(9, new Peca(TSL_TRAPEZI,pescala) ) ;
      break;
      case TIPUS_TANGRAM_EL:
        arrayPeces.replace(0, new Peca(TX_TRAPEZI_PETIT,pescala) ) ;
        arrayPeces.replace(1, new Peca(TX_TRAPEZI_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(TX_TRAPEZI_PETIT,pescala) ) ;
        arrayPeces.replace(3, new Peca(TX_TRAPEZI_PETIT,pescala) ) ;
        arrayPeces.replace(4, new Peca(TX_TRIANGLE,pescala) ) ;
        arrayPeces.replace(5, new Peca(TX_TRIANGLE,pescala) ) ;
        arrayPeces.replace(6, new Peca(TX_TRIANGLE,pescala) ) ;
        arrayPeces.replace(7, new Peca(TX_TRIANGLE,pescala) ) ;
        arrayPeces.replace(8, new Peca(TX_TRIANGLE,pescala) ) ;
        arrayPeces.replace(9, new Peca(TX_TRIANGLE,pescala) ) ;
      break;
      case TIPUS_TANGRAM_TCIRI:
        arrayPeces.replace(0, new Peca(TCIRI_TRIANGLE,pescala) ) ;
        arrayPeces.replace(1, new Peca(TCIRI_TRIANGLE,pescala) ) ;
        arrayPeces.replace(2, new Peca(TCIRI_TRIANGLE,pescala) ) ;
        arrayPeces.replace(3, new Peca(TCIRI_TRIANGLE,pescala) ) ;
        arrayPeces.replace(4, new Peca(TCIRI_TRIANGLE_ARC,pescala) ) ;
        arrayPeces.replace(5, new Peca(TCIRI_TRIANGLE_ARC,pescala) ) ;
        arrayPeces.replace(6, new Peca(TCIRI_TRIANGLE_OBTUS_ARC,pescala) ) ;
        arrayPeces.replace(7, new Peca(TCIRI_TRIANGLE_OBTUS_ARC,pescala) ) ;
        arrayPeces.replace(8, new Peca(TCIRI_TRIANGLE_OBTUS_GRAN_ARC,pescala) ) ;
        arrayPeces.replace(9, new Peca(TCIRI_TRIANGLE_OBTUS_GRAN_ARC,pescala) ) ;
      break;
     case TIPUS_TANGRAM_T11:
     // pescala=FACTOR_T11*pescala;
        arrayPeces.replace(0, new Peca(T10_ROMBE,pescala) ) ;
        arrayPeces.replace(1, new Peca(T10_ROMBE,pescala) ) ;
        arrayPeces.replace(2, new Peca(T10_ROMBE,pescala) ) ;
        arrayPeces.replace(3, new Peca(T10_TRIANGLE_EQUILATER_PETIT,pescala) ) ;
        arrayPeces.replace(4, new Peca(T10_TRIANGLE_EQUILATER_PETIT,pescala) ) ;
        arrayPeces.replace(5, new Peca(T10_TRIANGLE_EQUILATER_PETIT,pescala) ) ;
        arrayPeces.replace(6, new Peca(T10_TRIANGLE_EQUILATER_PETIT,pescala) ) ;
        arrayPeces.replace(7, new Peca(T11_TRIANGLE_RECTANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(8, new Peca(T11_TRIANGLE_RECTANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(9, new Peca(T11_TRIANGLE_OBTUS,pescala) ) ;
        arrayPeces.replace(10, new Peca(T11_TRIANGLE_OBTUS,pescala) ) ;
      break;
     case TIPUS_TANGRAM_TR:
     //Tangram rus
      pescala=FACTOR_TR*pescala;
        arrayPeces.replace(0, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(1, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(3, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(4, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(5, new Peca(TX_TRAPEZI_MITJA,pescala) ) ;
        arrayPeces.replace(6, new Peca(TX_TRAPEZI_PETIT,pescala) ) ;
        arrayPeces.replace(7, new Peca(TR_TRIANGLE_MOLT_PETIT,pescala) ) ;
        arrayPeces.replace(8, new Peca(TR_TRIANGLE_MOLT_PETIT,pescala) ) ;
        arrayPeces.replace(9, new Peca(TR_TRIANGLE_MOLT_PETIT,pescala) ) ;
        arrayPeces.replace(10, new Peca(TR_TRAPEZI,pescala) ) ;
        arrayPeces.replace(11, new Peca(TR_TRAPEZI,pescala) ) ;
      break;      
     case TIPUS_TANGRAM_T13:
        arrayPeces.replace(0, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(1, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(2, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(3, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(4, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(5, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(6, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(7, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(8, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(9, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(10, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(11, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(12, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
      break;
     case TIPUS_TANGRAM_T14:
     //és la duplicació del tangram clàssic
        arrayPeces.replace(0, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(1, new Peca(T7_QUADRAT,pescala) ) ;
        arrayPeces.replace(2, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(3, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(4, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(5, new Peca(T7_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(6, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(7, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(8, new Peca(T7_TRIANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(9, new Peca(T7_TRIANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(10, new Peca(T7_TRIANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(11, new Peca(T7_TRIANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(12, new Peca(T7_TRAPEZI,pescala) ) ;
        arrayPeces.replace(13, new Peca(T7_TRAPEZI,pescala) ) ;
      break;
     case TIPUS_TANGRAM_STOMACH:
        arrayPeces.replace(0, new Peca(TST_QUADRILATER_9,pescala) ) ;
        arrayPeces.replace(1, new Peca(TST_TRIANGLE_1,pescala) ) ;
        arrayPeces.replace(2, new Peca(TST_TRIANGLE_RECTANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(3, new Peca(TST_TRIANGLE_2,pescala) ) ;
        arrayPeces.replace(4, new Peca(TST_TRIANGLE_3,pescala) ) ;
        arrayPeces.replace(5, new Peca(TST_TRIANGLE_RECTANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(6, new Peca(TSL_TRAPEZI,escalaStomach*pescala) ) ;
        arrayPeces.replace(7, new Peca(TSTII_TRIANGLE_4,escalaStomach*pescala) ) ;
        arrayPeces.replace(8, new Peca(TST_PENTAGON_8,pescala) ) ;
        arrayPeces.replace(9, new Peca(TST_TRIANGLE_1,pescala) ) ;
        arrayPeces.replace(10, new Peca(TST_TRIANGLE_3,pescala) ) ;
      break;

     case TIPUS_TANGRAM_STOMACHION:
        arrayPeces.replace(0, new Peca(TST_TRIANGLE_RECTANGLE,pescala) ) ;
        arrayPeces.replace(1, new Peca(TST_TRIANGLE_1,pescala) ) ;
        arrayPeces.replace(2, new Peca(TST_TRIANGLE_RECTANGLE_GRAN,pescala) ) ;
        arrayPeces.replace(3, new Peca(TST_TRIANGLE_2,pescala) ) ;
        arrayPeces.replace(4, new Peca(TST_TRIANGLE_3,pescala) ) ;
        arrayPeces.replace(5, new Peca(TST_TRIANGLE_4,pescala) ) ;
        arrayPeces.replace(6, new Peca(TST_TRIANGLE_5,pescala) ) ;
        arrayPeces.replace(7, new Peca(TST_TRIANGLE_6,pescala) ) ;
        arrayPeces.replace(8, new Peca(TST_TRIANGLE_7,pescala) ) ;
        arrayPeces.replace(9, new Peca(TST_TRIANGLE_1,pescala) ) ;
        arrayPeces.replace(10, new Peca(TST_TRIANGLE_3,pescala) ) ;
        arrayPeces.replace(11, new Peca(TST_PENTAGON_8,pescala) ) ;
        arrayPeces.replace(12, new Peca(TST_QUADRILATER_9,pescala) ) ;
        arrayPeces.replace(13, new Peca(TST_QUADRILATER_10,pescala) ) ;
      break;
//Tangram Stomachion modificat
     case TIPUS_TANGRAM_STOMACHION_II:
      pescala=0.9*pescala;
        arrayPeces.replace(0, new Peca(T7_TRIANGLE_MITJA,pescala) ) ;
        arrayPeces.replace(1, new Peca(TSL_TRIANGLE_PETIT,pescala) ) ;
        arrayPeces.replace(2, new Peca(TSTII_QUADRILATER_1,pescala) ) ;
        arrayPeces.replace(3, new Peca(TSTII_QUADRILATER_2,pescala) ) ;
        arrayPeces.replace(4, new Peca(TSTII_TRIANGLE_RECT_1,pescala) ) ;
        arrayPeces.replace(5, new Peca(TSTII_TRIANGLE_4,pescala) ) ;
        arrayPeces.replace(6, new Peca(TSTII_TRIANGLE_4,pescala) ) ;
        arrayPeces.replace(7, new Peca(TSTII_TRIANGLE_5,pescala) ) ;
        arrayPeces.replace(8, new Peca(TSTII_TRIANGLE_5,pescala) ) ;
        arrayPeces.replace(9, new Peca(TSTII_TRIANGLE_5,pescala) ) ;
        arrayPeces.replace(10, new Peca(TSTII_PENTAGON,pescala) ) ;
        arrayPeces.replace(11, new Peca(TSTII_TRIANGLE_7,pescala) ) ;
        arrayPeces.replace(12, new Peca(TSTII_TRIANGLE_8,pescala) ) ;
        arrayPeces.replace(13, new Peca(TSTII_TRIANGLE_9,pescala) ) ;
      break;
   }//final switch
}//final creaJocPeces
*/
