/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

typedef struct {
  globus_mutex_t	mtx;
  globus_cond_t		cond;
  int			flags;
#define EF_EXIT		0x1
#define EF_RUN		0x2
#define EF_RUNNING	0x4
} EVENTCONTROL;

extern int	event_init();
extern void	event_queue(void *(*fun)(void *a), int *interval);
void		event_cancel(void *(*fun)(void *a));
extern void	event_process();
extern int	event_exists(void *(*fun)(void *a));
extern void	event_now(void *(*fun)(void *a));
extern int	event_when();
