/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * internal.h
 *
 * rcsid = "$Header: /home/globdev/CVS/globus-packages/nexus/source/nexus/internal.h,v 1.46 2006/01/19 05:57:05 mlink Exp $"
 */

#define _NX_SYSTEM_COMPILE

#include "nexus.h"
#include "globus_io.h"

/*
 * Now include all of the necessary system headers
 */
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>

#if defined(TARGET_ARCH_SOLARIS) 
#include <netdb.h>
#endif

#if defined(TARGET_ARCH_HPUX)
#include <sys/param.h> /* for MAXHOSTNAMELEN */

#include <sys/socket.h> /* for gethostbyname */
#include <netinet/in.h>
#include <netdb.h>

#include <unistd.h> /* for _SC_MAX_OPEN */
#endif

#ifdef HAVE_LIBC_H
#include <libc.h>
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef STDC_HEADERS
#include <stdlib.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#ifdef HAVE_SYS_ACCESS_H
#include <sys/access.h>
#endif

#ifdef HAVE_SYS_ERRNO_H
#include <sys/errno.h>
#endif

#ifdef TARGET_ARCH_PARAGON
#define NEXUS_ARGS "NexusArgs" /* Environment variable */
#endif

/*
 * Now include the rest of the internal Nexus headers.
 */
#include "defs.h"
#include "macros.h"
#include "types.h"
#include "funcs.h"
#include "globus_common.h"
#include "globals.h"
#ifdef BUILD_PROFILE
#include "pablo.h"
#endif

