/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * fault.c
 *
 * Fault tolerance interface code.
 */

static char *rcsid = "$Header: /home/globdev/CVS/globus-packages/nexus/source/nexus/fault.c,v 1.9 2006/01/19 05:57:05 mlink Exp $";

#include "internal.h"

static int (*callback_func_save)(void *user_arg,
			    int fault_code);
static void *callback_func_user_arg_save;


/*
 * _nx_fault_tolerance_new_process_params()
 */
int _nx_fault_tolerance_new_process_params(char *buf, int size)
{
    return(0);
} /* _nx_fault_tolerance_new_process_params() */


/*
 * _nx_fault_tolerance_init()
 */
void _nx_fault_tolerance_init(void)
{
     _nx_fault_tolerant = NEXUS_FALSE;
} /* _nx_fault_tolerance_init() */


/*
 * nexus_enable_fault_tolerance()
 */
void nexus_enable_fault_tolerance(int (*callback_func)(void *user_arg,
						       int fault_code),
				  void *callback_func_user_arg)
{
    callback_func_save = callback_func;
    callback_func_user_arg_save = callback_func_user_arg;
    
     _nx_fault_tolerant = NEXUS_TRUE;
} /* nexus_enable_fault_tolerance() */


/*
 * _nx_fault_detected()
 */
int _nx_fault_detected(int fault_code)
{
    int rc;
    if (!_nx_fault_tolerant)
    {
	rc = -1;
    }
    else if (callback_func_save)
    {
	rc = (*callback_func_save)(callback_func_user_arg_save,
				   fault_code);
    }
    else
    {
	rc = 0;
    }
    return(rc);
} /* _nx_fault_detected() */
