/*
 * Portions of this file Copyright 1999-2005 University of Chicago
 * Portions of this file Copyright 1999-2005 The University of Southern California.
 *
 * This file or a portion of this file is licensed under the
 * terms of the Globus Toolkit Public License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * If you redistribute this file, with or without
 * modifications, you must include this notice in the file.
 */


#ifndef GLOBUS_DUROC_RSL_H
#define GLOBUS_DUROC_RSL_H

/********************************************************************
 *
 * This file defines the DUROC rsl manipulation routines
 *
 ********************************************************************/

#include "globus_rsl.h"

#include "globus_common.h"

typedef globus_rsl_t * globus_duroc_rsl_ast_t;

#define globus_duroc_rsl_parse(descr) globus_rsl_parse ((char *)descr)
#define globus_duroc_rsl_unparse globus_rsl_unparse

globus_duroc_rsl_ast_t 
globus_duroc_rsl_strip_globus_duroc_fields (globus_duroc_rsl_ast_t request);
globus_duroc_rsl_ast_t  globus_duroc_rsl_copy (globus_duroc_rsl_ast_t request);
int globus_duroc_rsl_setenv (globus_duroc_rsl_ast_t request, 
			     const char *name, 
			     const char *value);
int globus_duroc_rsl_free (globus_duroc_rsl_ast_t request);
int globus_duroc_rsl_ismulti (globus_duroc_rsl_ast_t request);
int globus_duroc_rsl_multicount (globus_duroc_rsl_ast_t request);
int globus_duroc_rsl_num_nodes (globus_duroc_rsl_ast_t request, int *num_nodes);
globus_list_t *globus_duroc_rsl_subrequests_list (globus_duroc_rsl_ast_t request);
int globus_duroc_rsl_subrequests_list_free (globus_list_t *subrequests);
char *globus_duroc_rsl_globus_gram_contact (globus_duroc_rsl_ast_t request);
int globus_duroc_rsl_label (globus_rsl_t *request, char ** labelp);
int globus_duroc_rsl_starttype (globus_duroc_rsl_ast_t request, char ** strp);
int globus_duroc_rsl_commstype (globus_duroc_rsl_ast_t request, char ** strp);
void globus_duroc_rsl_add_output_defaults (globus_duroc_rsl_ast_t request, char * gass_url);
int globus_duroc_rsl_stdout (globus_duroc_rsl_ast_t request, char ** strp);
int globus_duroc_rsl_stderr (globus_duroc_rsl_ast_t request, char ** strp);

#endif /* GLOBUS_DUROC_RSL_H */

