/*
 * Portions of this file Copyright 1999-2005 University of Chicago
 * Portions of this file Copyright 1999-2005 The University of Southern California.
 *
 * This file or a portion of this file is licensed under the
 * terms of the Globus Toolkit Public License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * If you redistribute this file, with or without
 * modifications, you must include this notice in the file.
 */


#ifndef GLOBUS_DUROC_COMMON_H_INTERNAL
#define GLOBUS_DUROC_COMMON_H_INTERNAL

#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif
 

#include "globus_duroc_common.h"

#include "globus_i_duroc_common_nxbuff.h"
#include "globus_i_duroc_common_rsl.h"
#include "globus_i_duroc_common_utils.h"

EXTERN_C_BEGIN


#ifdef GLOBUS_DUROC_DEBUG
#define GLOBUS_DUROC_DEBUG_FLAG 1
#else
#define GLOBUS_DUROC_DEBUG_FLAG 0
#endif

#ifdef    GLOBUS_DUROC_ABORT_AT_ERROR

#define globus_duroc_at_error(string, intcode) \
    (assert(0))

#elif defined(GLOBUS_DUROC_VERBOSE_AT_ERROR)
     
#define globus_duroc_at_error(string, intcode) \
     (utils_debug (1 /* always enable */, \
		   "%s: %d: %s failure %d\n", \
		   __FILE__, __LINE__, string, intcode), \
      (0))
     
#else

#define globus_duroc_at_error(string, intcode) \
    (utils_debug (0 /* always disable */, \
                  ""), \
     (0))

#endif /* GLOBUS_DUROC_ABORT_AT_ERROR */


EXTERN_C_END

#endif /* GLOBUS_DUROC_COMMON_H_INTERNAL */

