/*
 * Portions of this file Copyright 1999-2005 University of Chicago
 * Portions of this file Copyright 1999-2005 The University of Southern California.
 *
 * This file or a portion of this file is licensed under the
 * terms of the Globus Toolkit Public License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * If you redistribute this file, with or without
 * modifications, you must include this notice in the file.
 */

#ifndef GLOBUS_DUCT_COMMON_H
#define GLOBUS_DUCT_COMMON_H

#include <unistd.h>

#include "globus_common.h"
#include "nexus.h"                      /* for buffer ops */

/* protocol version tag for consistency checking */

/* version history:
 *  301  --  initial versioned protocol
 */
#define GLOBUS_DUCT_DATA_PROTOCOL_MIN_VERSION            301
#define GLOBUS_DUCT_DATA_PROTOCOL_MAX_VERSION            301

/* version history:
 *  501  --  initial versioned protocol
 */
#define GLOBUS_DUCT_CHECKIN_PROTOCOL_MIN_VERSION         501
#define GLOBUS_DUCT_CHECKIN_PROTOCOL_MAX_VERSION         501

/* version history:
 *  701  --  initial versioned protocol
 */
#define GLOBUS_DUCT_CONFIG_PROTOCOL_MIN_VERSION          701
#define GLOBUS_DUCT_CONFIG_PROTOCOL_MAX_VERSION          701

#define GLOBUS_DUCT_SUCCESS                                0
#define GLOBUS_DUCT_ERROR_INVALID_PARAMETER                1
#define GLOBUS_DUCT_ERROR_NOT_SUPPORTED                    2
#define GLOBUS_DUCT_ERROR_INIT_FAILED                      3
#define GLOBUS_DUCT_ERROR_CHECKIN_FAILED                   4
#define GLOBUS_DUCT_ERROR_CONTROL_ABORTED                  5
#define GLOBUS_DUCT_ERROR_CHECKIN_PROTOCOL_MISMATCH        6
#define GLOBUS_DUCT_ERROR_SEND_FAILED                      7
#define GLOBUS_DUCT_ERROR_DATA_PROTOCOL_MISMATCH           8
#define GLOBUS_DUCT_ERROR_CONFIG_PROTOCOL_MISMATCH         9

#define GLOBUS_DUCT_MAX_MSG_LENGTH 8096

int nxbuff_put_stringval (nexus_buffer_t *buff, const char *string);
int nxbuff_get_stringval (nexus_buffer_t *buff, char **string);
void nxbuff_free_stringval (char *string);

int nxbuff_put_byte (nexus_buffer_t *buff, globus_byte_t b);
int nxbuff_get_byte (nexus_buffer_t *buff, globus_byte_t *b);

int nxbuff_put_int (nexus_buffer_t *buff, int i);
int nxbuff_get_int (nexus_buffer_t *buff, int *i);

int nxbuff_put_float (nexus_buffer_t *buff, float f);
int nxbuff_get_float (nexus_buffer_t *buff, float *f);

int nxbuff_put_startpoint_transfer (nexus_buffer_t *buff, 
                                    nexus_startpoint_t *sp);

int nxbuff_get_startpoint (nexus_buffer_t *buff, 
                           nexus_startpoint_t *sp);


#endif /* GLOBUS_DUCT_COMMON_H */
