/*
  Glaurung, a UCI chess playing engine.
  Copyright (C) 2004-2007 Tord Romstad

  Glaurung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  Glaurung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#if !defined(CASTLE_H_INCLUDED)
#define CASTLE_H_INCLUDED

////
//// Types
////

/// Castle rights, encoded as bit fields:
enum CastleRights {
  NO_CASTLES = 0, 
  WHITE_OO = 1, BLACK_OO = 2, 
  WHITE_OOO = 4, BLACK_OOO = 8,
  ALL_CASTLES = 15
};


////
//// Inline functions
////

inline CastleRights operator& (CastleRights c1, CastleRights c2) {
  return CastleRights(int(c1) & int(c2));
}

inline void operator&= (CastleRights& c1, CastleRights c2) {
  c1 = CastleRights(c1 & c2);
}

inline CastleRights operator| (CastleRights c1, CastleRights c2) {
  return CastleRights(int(c1) | int(c2));
}

inline void operator|= (CastleRights& c1, CastleRights c2) {
  c1 = CastleRights(c1 | c2);
}

inline CastleRights operator^ (CastleRights c1, CastleRights c2) {
  return CastleRights(int(c1) ^ int(c2));
}

inline void operator^= (CastleRights& c1, CastleRights c2) {
  c1 = CastleRights(c1 ^ c2);
}


#endif // !defined(CASTLE_H_INCLUDED)
