/*
 * BackupRestore.java
 *
 * Created on December 13, 2000, 6:08 AM
 */

package com.sun.enterprise.config.backup;

import com.sun.enterprise.config.backup.status.BackupStatus;
import com.sun.enterprise.config.backup.status.RemoveStatus;
import com.sun.enterprise.config.backup.status.RestoreStatus;
import com.sun.enterprise.config.backup.status.UndoRestoreStatus;

/**
 * This Interface is exposed by the mbean and also
 * by the backupRestore utility.
 * This class has all methods required to implement
 * backup-restore functionality
 *
 * @author  sridatta
 */
public interface BackupRestore {
    
    /**
     * Backsup the configuration into a default location
     * DefaultLocation is specified by $DomainRoot/backup
     * Use the other method backup(String targetFileName) if
     * you need to specify the source file
     *
     * @param userInfo is a string entered by the user. It can
     * be null.
     *
     * @return BackupRestoreStatus Detailed backup information
     */
    BackupStatus backup(String userInfo);
    
    /**
     * backs up the configuration to the target filename
     * @return BackupRestoreStatus Detailed backup information
     */
    BackupStatus backup(String targetFileName, String userInfo);
    
    /**
     * Restores the configuration from the last backup file
     *
     * @return RestoreStatus Detailed Status Information
     */
    RestoreStatus restore();
    
    /**
      * restores the configuration from the specified file
     * Note that this can be a backup from this domain OR
     * from other domain!! Hence it can be used to replicate
     * servers
     * @return RestoreStatus detailed status information
     */
    RestoreStatus restore(String backupFileName);
    
    /** 
     * This method can be used to undo a just performed restore.
     * Every restore keeps the information before restoring in
     * a file. So that restore can be undone.
     *
     * @UndoRestoreStatus status of the undo restore operation
     */
    UndoRestoreStatus undoRestore();
    
    /**
     * Get a report of all available backups
     */
    BackupStatus[] listBackups();    
    
    /**
     * remove by specifying a file name
     */
    RemoveStatus removeBackup(String backupFileName);
    
    /**
     * Get a report of previous history
     * 
     */
    BackupHistory getBackupHistory(int number) throws BackupException;
    
    /**
     * cleanup the history
     * A best effort solution. Does not throw exception.
     */
    BackupHistory clearBackupHistory();
}