#!/usr/bin/ruby -w
# -*- ruby -*-

class String

  # Returns the string, as a number if it is one, and nil otherwise.
  def num
    begin
      Integer(self)
    rescue ArgumentError => ae
      nil
    end
  end

end



module Enumerable

  def collect_with_index(&blk)
    ary = []
    self.each_with_index do |item, idx|
      ary << blk.call(item, idx)
    end
    ary
  end
  
  def select_with_index(arg = nil, &blk)
    ary = []
    self.each_with_index do |item, idx|
      eq = arg ? arg == item : blk.call(item, idx)
      if eq
        ary << item
      end
    end
    ary
  end

  alias :orig_select  :select
  alias :orig_collect :collect
  alias :orig_detect  :detect
  alias :orig_reject  :reject

  NOT_NIL = Object.new

  origw = $-w
  $-w = false
  def select(arg = NOT_NIL, &blk)
    ary = []
    self.each_with_index do |item, idx|
      ary << item if _match?(arg, item, idx, &blk)
    end
    ary
  end

  def detect(arg = NOT_NIL, &blk)
    self.each_with_index do |item, idx|
      return item if _match?(arg, item, idx, &blk)
    end
    nil
  end
  $-w = origw

  def _match?(arg, item, idx, &blk)
    if blk 
      args = [ item ]
      args << idx if idx && blk.arity > 1
      blk.call(*args)
    elsif arg == NOT_NIL
      !item.nil?
    else
      arg == item
    end
  end
  
end


class MatchData

  origw = $-w
  $-w = false
  def inspect
    to_a.inspect
  end
  $-w = origw

end
