// $Id: toolitem.cc,v 1.7 2004/10/07 14:33:40 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2004  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "toolitem.hh"

static Gtk_ToolItem Gtk_ToolItem(false);

const std::string Gtk_ToolItem::TypeName(const Widget &w) const
{  return GtkPrefix()+"ToolItem";
}

const std::string Gtk_ToolItem::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"toolitem.h";
}

Gtk_ToolItem::Gtk_ToolItem(bool base_class_init)
{  if (!base_class_init) Writer["GtkToolItem"]=this;
}

void Gtk_ToolItem::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
}

bool Gtk_ToolItem::NeedExplicitCtor(const Widget &w) const
{  return false; }

bool Gtk_ToolItem::isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  const char prefix[]="gtk_tool_item_";
   const int plen(sizeof(prefix)-1);
   if (method.substr(0,plen)==prefix) method=method.substr(plen);
   if (((method=="set_homogeneous" || method=="set_expand" || method=="set_use_drag_window")
   	&& matches("bool\\ \\_",args)))
   {  scope=Gtk_ToolItem::TypeName(w);
      is_signal=false;
      return true;
   }
   return Parent::isInternalMethod(w,method,args,scope,is_signal);
}

void Gtk_ToolItem::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  if (GTKMM24)
   {  If24(f);
      Parent::Configure(w,f,instance);

      WriteBoolProperty(w,f,instance, "visible_horizontal");
      WriteBoolProperty(w,f,instance, "visible_vertical");
      WriteBoolProperty(w,f,instance, "is_important");
      /// ???
      WriteBoolProperty(w,f,instance, "homogeneous");
      WriteBoolProperty(w,f,instance, "expand");
      WriteBoolProperty(w,f,instance, "expand");
      /// tooltip???
      WriteBoolProperty(w,f,instance, "use_drag_window");
      
      if (!w.getProperty("tooltip").empty())
        f.Statement() << instance << "set_tooltip(_tooltips, "
              << Configuration.Translatable(w.getProperty("tooltip")) << ")";
      f.EndIf();
   }
}

void Gtk_ToolItem::CreatePointer(const Widget &w, CxxFile &f) const
{  if (GTKMM24) 
   {  If24(f);
      Parent::CreatePointer(w,f);
      f.EndIf();
   }
}

void Gtk_ToolItem::GHInclude(const Widget &w, CxxFile &f) const
{  if (GTKMM24) 
   {  If24(f); Parent::GHInclude(w,f); f.EndIf(); }
}

void Gtk_ToolItem::GCInclude(const Widget &w, CxxFile &f) const
{  if (GTKMM24) 
   {  If24(f); Parent::GCInclude(w,f); f.EndIf(); }
}

void Gtk_ToolItem::Configure_show(const Widget &w, CxxFile &f,const std::string &instance) const
{  if (GTKMM24) 
   {  If24(f); Parent::Configure_show(w,f,instance); f.EndIf(); }
}

void Gtk_ToolItem::AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const
{  if (GTKMM24) 
   {  If24(f); Parent::AddChildren(w,f,instance,writer_for_subw,widget_for_subw); f.EndIf(); }
}

void Gtk_ToolItem::GHDeclaration(const Widget &w, CxxFile &f) const
{  if (GTKMM24) 
   {  If24(f); Parent::GHDeclaration(w,f); f.EndIf(); }
}
