// $Id: gnome_dock.cc,v 1.6 2002/11/04 11:31:03 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

class Gnome_Dock : public Gtk_Container
{public:
	typedef Gtk_Container Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gnome_Dock();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	virtual void AddChild(const Widget &w,CxxFile &f,const std::string &instance) const;
};

static Gnome_Dock Gnome_Dock;

const std::string Gnome_Dock::TypeName(const Widget &w) const
{  return GnomeUIPrefix()+"Dock";
}

const std::string Gnome_Dock::IncludeName(const Widget &w) const
{  return Configuration.GnomeUImmIncludePath()+"dock.h";
}

Gnome_Dock::Gnome_Dock()
{  Writer["GnomeDock"]=this;
}

void Gnome_Dock::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

// set is missing!
//   WriteBoolProperty(w,f,instance, "allow_floating", true, "allow_floating_items");
   bool allow_floating(w.getBoolProperty("allow_floating"));
   f.Statement() << instance << "allow_floating_items(" << PRINT_BOOL(allow_floating) << ')';
}

void Gnome_Dock::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{  // const ChildParamList ch=w.get_Child_params();
   
   if (w.ChildName()=="GnomeDock:contents")
   {  f.Statement() << instance << "set_client_area("
   		<< Reference(w) << ')';
   }
   else
   {  std::string placement(w.getProperty("placement","GNOME_DOCK_TOP"));
      int band(w.getIntProperty("band",0));
      int position(w.getIntProperty("position",0));
      int offset(w.getIntProperty("offset",0));
      bool in_new_band(w.getBoolProperty("in_new_band"));
      f.Statement() << instance << "add_item(" << Reference(w)
   	<< ", " << placement << ", " << band << ", " << position << ", "
   	<< offset << ", " << PRINT_BOOL(in_new_band) << ')';
   // add_floating_item (w,x,y,GtkOrientation orientation)
// #warning floating support missing ???
   }
}

