// $Id: calendar.cc,v 1.12 2002/05/24 06:24:11 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "widget.hh"

class Gtk_Calendar : public Gtk_Widget
{public:
	typedef Gtk_Widget Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Calendar();
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};

static Gtk_Calendar Gtk_Calendar;

const std::string Gtk_Calendar::TypeName(const Widget &w) const
{  return GtkPrefix()+"Calendar";
}

const std::string Gtk_Calendar::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"calendar.h";
}

Gtk_Calendar::Gtk_Calendar()
{  Writer["GtkCalendar"]=this;
}

void Gtk_Calendar::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   std::string options("0");
   if (w.getBoolProperty("show_heading",true)) options+="|GTK_CALENDAR_SHOW_HEADING";
   if (w.getBoolProperty("show_day_names",true)) options+="|GTK_CALENDAR_SHOW_DAY_NAMES";
   if (w.getBoolProperty("no_month_change")) options+="|GTK_CALENDAR_NO_MONTH_CHANGE";
   if (w.getBoolProperty("show_week_numbers")) options+="|GTK_CALENDAR_SHOW_WEEK_NUMBERS";
   if (w.getBoolProperty("week_start_monday")) options+="|GTK_CALENDAR_WEEK_START_MONDAY";
   if (options.size()>1) // strip leading '0|'
      options=options.substr(2);
   if (GTKMM1)
      f.Statement() << instance << "display_options((GtkCalendarDisplayOptions)(" << options << "))";
   else   
      f.Statement() << instance << "display_options(" << Gtkmm2Namespace(options) << ")";
}

