// $Id: accellabel.cc,v 1.3 2003/03/05 09:34:51 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "label.hh"

class Gtk_AccelLabel : public Gtk_Label
{public:
	typedef Gtk_Label Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_AccelLabel(bool base_class_init=true);
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};


static Gtk_AccelLabel Gtk_AccelLabel(false);

const std::string Gtk_AccelLabel::TypeName(const Widget &w) const
{  return GtkPrefix()+"AccelLabel";
}

const std::string Gtk_AccelLabel::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"accellabel.h";
}

Gtk_AccelLabel::Gtk_AccelLabel(bool base_class_init)
{  if (!base_class_init) Writer["GtkAccelLabel"]=this;
}

void Gtk_AccelLabel::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   // we can't get parent (yet)
   // f.Statement() << instance << "set_accel_widget(" << Reference(parent) << ")";
}
