// $Id: WriterBase_matches.cc,v 1.8 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "WriterBase.hh"

bool WriterBase::matches(const std::string &pattern, const std::string &s)
{  std::string::const_iterator pp(pattern.begin());
   std::string::const_iterator pe(pattern.end());
   std::string::const_iterator sp(s.begin());
   std::string::const_iterator se(s.end());
   
   while (sp!=se || pp!=pe)
   {  if (pp==pe) return false;
      else if (sp==se)
      {  if (*pp!='*') return false; // pattern left at end of s
         ++pp; // end on s stops *
      }
      else 
      {  switch(*pp)
         {  case '*':
               if (pp+1!=pe && *sp==*(pp+1)) 
                  ++pp; // char following * found, stop *
               else ++sp; // skip *sp
               break;
            case '?': 
               ++sp; ++pp;
               break;
            case '\\':
               ++pp;
               if (pp==pe) return false;
               switch(*pp)
               {  case '\\':
                  case '*':
                  case '?':
                     if (*pp!=*sp) return false;
                     ++sp; ++pp;
                     break;
                  case ' ': // skip whitespace
                     ++pp;
                     while (sp!=se && (*sp==' ' || *sp=='\t' || *sp=='\n')) 
                        ++sp;
                     break;
                  case '_': // skip identifier
                     ++pp;
                     if (*sp!='_' && !isalpha(*sp)) return false;
                     while (*sp=='_' || isalpha(*sp)) ++sp;
                     break;
               }
               break;
            default: if (*pp!=*sp) return false;
               ++sp; ++pp;
               break;
         }
      }
   }
   return true;
}
