// $Id: MakeFile.hh,v 1.10 2001/10/12 07:11:09 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef MAKEFILE_HH
#define MAKEFILE_HH

#include "SystemFile.hh"

/* egcs 1.x issues an error and gcc-2.95 crashes */

class MakeFile : public SystemFile
{
public:
	MakeFile() {}
protected:
	MakeFile(MakeFile *fp,unsigned int stage=0) : SystemFile(fp) {}
public:
//	void close();
	
	// 2do: Convenience Functions for Makefiles
	MakeFile &Dependancy(const std::string &s)
	{  return *this << "\\\n\t" << s << " "; }

/* egcs 1.x issues an error and gcc-2.95 crashes */
#if defined __GNUC__ && __GNUC__ >= 3
	// adaptor
	template <class U> MakeFile &operator<<(const U &t)
	{  ((SystemFile&)(*this)) << t;
	   return *this;
	}
#else
#	define op_shl(U) MakeFile &operator<<(const U &t) \
		{  ((SystemFile&)(*this)) << t; \
		   return *this; \
		}
		
	op_shl(std::string)
	op_shl(char*)
	op_shl(int)
	op_shl(char)
	op_shl(float)
#undef op_shl	
#endif	
};

#endif
