// $Id: GladeTag.hh,v 1.2 2002/05/31 07:42:56 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2002  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GLADETAG_HH
#define GLADETAG_HH
#include <Tag.hh>

// this class exists only to provide additional methods which hide the
// glade-1 vs glade-2 difference for Signals and Accelerators
//
// simply recast a pointer and use the methods

class GladeTag : public Tag
{	// we can't declare members since the pointers need to be equivalent
	// this class should only add new methods
	
	// we can't construct this object, yet
	GladeTag();
public:
//	GladeTag(Tag &t) // does this work?
//	{  this=static_cast<GladeTag*>(&t); }
	
	std::string getGladeAttr(const std::string &name, const std::string &def="") const;
	bool getGladeBoolAttr(const std::string &name, bool def=false) const;
	bool hasGladeAttr(const std::string &name) const;
	void setWidgetType(const std::string &type);
};

#endif
