/*
 *  
 *  $Id: pasodatosgenerales.h 4403 2011-11-14 10:59:24Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iwizard.h>
#include "pasosimportacionvisualizatorbase.h"
#include <string>
#include <vector>
#include "datospersistentesimportacion.h"
#include <api/dicom/idicomizador.h>
#include <wx/ginkgostyle/ginkgostyle.h>

namespace GNC {
	namespace GCS {
		class IEntorno;
	}
}

namespace GNKVisualizator {
	namespace GUI {

		class PasoDatosGenerales: public PanelDatosGeneralesBase,public IPasoWizard
		{
			public:
				PasoDatosGenerales(wxWindow* pParent,IWizard* pWizard,const GnkPtr<TipoWizardImportacion>& datosPersistentes,const std::string &dirTemporal,GNC::GCS::IEntorno * pEntorno);
				~PasoDatosGenerales();

			//region "Metodos heredados de IPasoWizard"
				virtual bool Attach();

				virtual std::string GetTitle();

				virtual std::string GetSubTitle();

				virtual bool Siguiente();

				virtual bool Anterior();

				virtual bool Cancelar();

				virtual bool Validar();
			//endregion
			protected:
				virtual std::string GetPacienteNombre();
				virtual std::string GetPacienteApellido1();
				virtual std::string GetPacienteApellido2();
				virtual std::string GetPacienteIdentificador();
				virtual std::string GetPacienteFechaNacimiento();
				virtual std::string GetPacienteEdad();
				virtual std::string GetPacientePeso();
				virtual std::string GetPacienteAltura();
				virtual std::string GetPacienteSexo();

				void OnKillFocusEstudioTimeControl(wxFocusEvent &event);
				virtual void OnCheckBoxReferenciarEstudioClick(wxCommandEvent &event);
				void EnableComponents(bool enable);

				virtual std::string GetEstudioFecha();
				virtual std::string GetEstudioTime();
				virtual std::string GetEstudioDescripcion();

				void OnKillFocusSerieTimeControl(wxFocusEvent &event);
				virtual void OnCheckBoxReferenciarSerieClick(wxCommandEvent &event);

				virtual std::string GetSerieFecha();
				virtual std::string GetSerieTime();
				virtual std::string GetSerieDescripcion();



				GnkPtr<TipoWizardImportacion> m_pDatosPersistentes;
				GNC::GCS::IEntorno *             m_pEntorno;
				std::string m_dirTemporal;
				bool m_dicomizado;

				// Helpers: AutoEdad
				int CalcularEdad();
		};
	}
}
